#ifndef _ZCORE_WINDOW_H
#define _ZCORE_WINDOW_H
/**
 * \defgroup msg_hook_fns Message or event hook functions
 * @{
 */
#include "zcore_type.h"
#define HOOK_GOON       0
#define HOOK_STOP       1

/**
 * Type of message hook function.
 */
typedef ZSINT32 (* MSGHOOK)(ZVOID* context, HWND dst_wnd, ZSINT32 msg, WPARAM wparam, LPARAM lparam);

/**
 * Structure defines a message hook.
 */
typedef struct _HOOKINFO
{
    /** the context which will be passed to the hook function. */
    ZVOID* context;
    /** the pointer to the hook function. */
    MSGHOOK hook;
} HOOKINFO;


typedef struct _HWNDTHEME
{
    ZSINT32 iBkColor;     //background color
    ZSINT32 iFrColor;     //front color
    ZVOID *pBkPicture;    //picture of background
} HWNDTHEME;

typedef enum tag_WINSTYLE
{
    MAIN_WIN = 0,
    MIDDLE_WIN,
    TOP_WIN
} WINSTYLE;


/*registers a key message hook pointed.*/
MSGHOOK RegisterKeyMsgHook (ZVOID* context, MSGHOOK hook);
/*Registers a mouse message hook.*/
MSGHOOK RegisterMouseMsgHook (ZVOID* context, MSGHOOK hook);
MSGHOOK RegisterHwndMsgHook (ZVOID* context, MSGHOOK hook);
/*ճܴע */
MSGHOOK RegisterCBWinMsgHook (ZVOID* context, MSGHOOK hook);

/*Window styles*/
#define WS_NONE              0x00000000L /*None style*/
#define WS_OVERLAPPED        0x00000000L /*not supported*/

#define WS_CHILD             0x40000000L /*Indicates the window is a child*/
#define WS_VISIBLE           0x08000000L /*Creates a window initially visible*/
#define WS_DISABLED          0x04000000L /*Creates a window initially disabled*/

#define WS_DLGFRAME          0x00800000L
#define WS_COMBINESTYLE      0x00800000L /*Creates a window with combine style*/
#define WS_BORDER            0x00400000L /*Creates a window with border*/
#define WS_THICKFRAME        0x00200000L /*Creates a window with thick frame*/
#define WS_THINFRAME         0x00100000L /*Creates a window with thin frame*/
#define WS_VSCROLL           0x00080000L /*Creates a window with vertical scroll bar*/
#define WS_HSCROLL           0x00040000L /*Creates a window with horizontal scroll bar*/
#define WS_GROUP             0x00020000L /*Indicates the control is the leader of a group*/
#define WS_TABSTOP           0x00010000L /*Indicates the user can set the input focus to the control by using Tab key*/

/*Window extended styles*/
#define WS_EX_NONE           0x00000000L /*None extended window style*/
#define WS_EX_SURFACE        0x00000001L
#define WS_EX_USEPRIVATECDC  0x00000002L /*The window has its own private client device context*/
#define WS_EX_NOPARENTNOTIFY 0x00000004L
#define WS_EX_TOPMOST        0x00000008L /*The main window is a topmost (always on top) window*/
#define WS_EX_OUTLINETEXT    0x00000010L
#define WS_EX_TRANSPARENT    0x00000020L /*The window is transparent*/
#define WS_EX_LAYERED        0x00000040L
#define WS_EX_TOOLWINDOW     0x00000080L /*The main window is a tool window, which can not gain the input focus*/
#define WS_EX_CLEANINPUTMSG  0x00000100L /*During changing the active window, the old one's input message should be cleared*/
#define WS_EX_USEPRIVATEDC   0x00000200L
#define WS_EX_CLIPCHILDREN   0x80000000L /*When paint the window, the children areas will be clipped*/

#ifndef _TYPE_WNDPROC
#define _TYPE_WNDPROC
typedef ZSINT32 (* WNDPROC)(HWND, ZSINT32, WPARAM, LPARAM);
#endif

#define HWND_NULL           0
#define HWND_INVALID        0xFFFFFFFF

/*defines a main window.*/
typedef struct _MAINWINCREATE
{
    /** the style of the main window */
    ZDWORD dwStyle;
    /** the extended style of the main window */
    ZDWORD dwExStyle;
    /** the caption of the main window */
    const ZCHAR* spCaption;
    /** the handle to the menu of the main window */
    HMENU hMenu;
    /** the handle to the cursor of the main window */
    HCURSOR hCursor;
    /** the handle to the icon of the main window */
    HICON hIcon;
    /** the hosting main window */
    HWND  hHosting;
    /** the window callback procedure */
    ZSINT32 (*MainWindowProc)(HWND, ZSINT32, WPARAM, LPARAM);
    /** the position of the main window in the screen coordinates */
    ZSINT32 lx, ty, rx, by;
    /** the pixel value of background color of the main window */
    ZSINT32 iBkColor;
    /** the first private data associated with the main window */
    ZDWORD dwAddData;
    ZSINT32 layerID;
    ZSINT32 rotation;
    /** reserved, do not use */
    ZDWORD dwReserved;
}MAINWINCREATE;
typedef MAINWINCREATE* PMAINWINCREATE;

/*Cleans up system resource associated with a main window.*/
ZVOID MainWindowThreadCleanup(HWND hMainWnd);
#define MainWindowCleanup(hwnd)      MainWindowThreadCleanup(hwnd)

/*Creates a main window.*/
HWND CreateMainWindow (PMAINWINCREATE pCreateStruct);
/*Destroys a main window.*/
ZBOOL DestroyMainWindow (HWND hWnd);
/*The default main window callback procedure.*/
ZSINT32 DefaultMainWinProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
/*The default window callback procedure.*/
ZSINT32 DefaultWindowProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
/*The default control callback procedure.*/
ZSINT32 DefaultControlProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
/*Updates a window.*/
ZVOID UpdateWindow (HWND hWnd, ZBOOL bErase);
/* ShowWindow operations*/
#define SW_HIDE              	0x0000
#define SW_SHOW              	0x0010
#define SW_SHOWNORMAL        	0x0100
/*Shows or hides a window.*/
ZBOOL ShowWindow (HWND hWnd, ZSINT32 iCmdShow);
/*Enables of disables a window.*/
ZBOOL EnableWindow (HWND hWnd, ZBOOL fEnable);
/*Determines whether the specified window is enabled for mouse and keyboard input.*/
ZBOOL IsWindowEnabled (HWND hWnd);
/*Retrives the client rectangle of a window.*/
ZBOOL GetClientRect(HWND hWnd, PRECT prc);
/*Returns the current background color of a window.*/
ZSINT32 GetWindowBkColor (HWND hWnd);
/*Sets the background color of a window.*/
ZSINT32 SetWindowBkColor (HWND hWnd, ZSINT32 new_bkcolor);
/*Retrives the default font of a window.*/
PLOGFONT GetWindowFont (HWND hWnd);
/*Sets the default font of a window.*/
PLOGFONT SetWindowFont (HWND hWnd, PLOGFONT pLogFont);
/*Retrives the style of a window.*/
ZDWORD GetWindowStyle (HWND hWnd);
/*Retrives the extended style of a window.*/
ZDWORD GetWindowExStyle (HWND hWnd);
ZBOOL ExcludeWindowStyle (HWND hWnd, ZDWORD dwStyle);
ZBOOL IncludeWindowStyle (HWND hWnd, ZDWORD dwStyle);
ZBOOL ExcludeWindowExStyle (HWND hWnd, ZDWORD dwStyle);
ZBOOL IncludeWindowExStyle (HWND hWnd, ZDWORD dwStyle);
/*Retrives the callback procedure of a window.*/
WNDPROC GetWindowCallbackProc (HWND hWnd);
/*Sets the callback procedure of a window.*/
WNDPROC SetWindowCallbackProc (HWND hWnd, WNDPROC newProc);
/*Retrives the first additional data of a window.*/
ZDWORD GetWindowAdditionalData (HWND hWnd);
/*Sets the first additional data of a window.*/
ZDWORD SetWindowAdditionalData (HWND hWnd, ZDWORD newData);
/*Retrives the second additional data of a window.*/
ZDWORD GetWindowAdditionalData2 (HWND hWnd);
/*Sets the second additional data of a window.*/
ZDWORD SetWindowAdditionalData2 (HWND hWnd, ZDWORD newData);
/*Retrives the additional data of a control class.*/
ZDWORD GetWindowClassAdditionalData (HWND hWnd);
/*Sets the additional data of a control class.*/
ZDWORD SetWindowClassAdditionalData (HWND hWnd, ZDWORD newData);
/*Retrives the caption of a window.*/
/*ڴУûжԱʼûʾSetWindowCaptionǰ,øú
ܻȡڵı */
const ZCHAR* GetWindowCaption (HWND hWnd);
/*Sets the caption of a window.*/
/* ýӿڲôڱ⣬ҿstaticؼʾݣ
ýӿòǷWS_CAPTIONʽ */
ZBOOL SetWindowCaption (HWND hWnd, const ZCHAR* spCaption);
/*Makes a rectangle region in the client area of a window invalid.*/
ZBOOL InvalidateRect(HWND hWnd, const RECT* prc, ZBOOL bEraseBkgnd);
/*Prepares a window for painting.*/
HDC BeginPaint(HWND hWnd);
/*Marks the end of painting in a window.*/
ZVOID EndPaint(HWND hWnd, HDC hdc);
/*Converts the client coordinates of a point to screen coordinates.*/
ZVOID ClientToScreen (HWND hWnd, ZSINT32* x, ZSINT32* y);
/*Converts the screen coordinates of a point to client coordinates.*/
ZVOID ScreenToClient (HWND hWnd, ZSINT32* x, ZSINT32* y);
/*Converts the window coordinates of a point to screen coordinates.*/
ZVOID WindowToScreen (HWND hWnd, ZSINT32* x, ZSINT32* y);
/*Converts the screen coordinates of a point to window coordinates.*/
ZVOID ScreenToWindow (HWND hWnd, ZSINT32* x, ZSINT32* y);
/*Determines whether a window is a main window.*/
ZBOOL IsMainWindow (HWND hWnd);
/*Determines whether a window is a control.*/
ZBOOL IsControl (HWND hWnd);
/*Determines whether a window handle identifies an existing window.*/
ZBOOL IsWindow (HWND hWnd);
/*Retrieves the handle to a child window's parent window.*/
HWND GetParent (HWND hWnd);
/*Retrives the handle to the main window contains a window.*/
HWND GetMainWindowHandle (HWND hWnd);
/*Retrieves the visibility state of a window.*/
ZBOOL IsWindowVisible (HWND hWnd);
/*Retrives the dimensions of the bounding rectangle of a window.*/
ZBOOL GetWindowRect (HWND hWnd, PRECT prc);
/*Retrives the next control in a window.*/
HWND GetNextChild (HWND hWnd, HWND hChild);
/*Retrives the next main window in the system according to the zorder.*/
HWND GetNextMainWindow (HWND hMainWnd);
/*Retrives the hosting main window of a main window.*/
HWND GetHosting (HWND hMainWnd);
/*Retrives the first hosted main window of a main window.*/
HWND GetFirstHosted (HWND hHosting);
/*Retrives the next hosted main window of a main window.*/
HWND GetNextHosted (HWND hHosting, HWND hHosted);
/*Retrieves the length of a window's text.*/
ZSINT32 GetWindowTextLength (HWND hWnd);
/*Copies the text of a window's into a buffer.*/
ZSINT32 GetWindowText (HWND hWnd, ZCHAR* spString, ZSINT32 nMaxLen);
/*Sets the text of a window.*/
ZBOOL SetWindowText (HWND hWnd, const ZCHAR* spString);
/*Retrieves the handle to the window's active child that has the keyboard focus.*/
HWND GetFocusChild (HWND hWnd);
/*Sets the active child of a window.*/
HWND SetFocusChild (HWND hWnd);
#define SetFocus SetFocusChild
#define GetFocus GetFocusChild
/*Retrieves the main window handle to the active main window.*/
HWND GetActiveWindow (ZVOID);
/*Sets a main window to be the active main window.*/
HWND SetActiveWindow (HWND hMainWnd);
#define GetForegroundWindow GetActiveWindow
#define SetForegroundWindow SetActiveWindow
/*Changes the position and dimensions of a window.*/
ZBOOL MoveWindow (HWND hWnd, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, ZBOOL fPaint);
/*Scrolls the content of a window's client area.*/
ZVOID ScrollWindow (HWND hWnd, ZSINT32 iOffx, ZSINT32 iOffy, const RECT* rc1, const RECT* rc2);

/*
 *:   GetWindowdId
 *:   ָھID
 *˭:   hwnd  ָھ
 *		      pId   ָID ָ(ID޸)
 *ֵ     :   TRUE  IDɹ
 *               FALSE IDʧ
 */
ZBOOL GetWindowId(HWND hwnd, ZSINT32 *pId);

/*
 *:   SetWindowdId
 *:   ָڵID
 *˭:   hwnd  ָھ
 *			  id    ID
 *ֵ     :   TRUE   IDɹ
 *               FALSE  IDʧ
 */
ZBOOL SetWindowId(HWND hwnd, ZSINT32 id);

/*
 *:   GetWindowTheme
 *:   ָھ
 *˭:   hwnd    ָھ
 *		      pTheme  ָָ(޸)
 *ֵ     :  TRUE  ɹ
 *              FALSE ʧ
 */
ZBOOL GetWindowTheme(HWND hwnd, HWNDTHEME *pTheme);

/*
 *:   SetWindowTheme
 *:   ָ
 *˭:   hwnd     ָھ
 *			  pTheme   趨
 *ֵ     :TRUE     趨ɹ
 *            FALSE    趨ʧ
 */
ZBOOL SetWindowTheme(HWND hwnd, HWNDTHEME Theme);

/*
 *:   GetActiveLayerID
 *:   õǰID
 *˭:
 *ֵ     : ID
 *             -1  ʧ
 */
ZSINT32 GetActiveLayerID(ZVOID);

/**************************************************************************
* ƣ GetWindowRotation
*  ȡڵת״̬
* ˵ (IN)
*            (OUT)
*   ֵ
* ˵ ѡ
**************************************************************************/
ZSINT32 GetWindowRotation(HWND hWnd);

/**************************************************************************
* ƣ ResizeWindowEx
*  ĻתʱԴڵĳߴе
* ˵ (IN)
*            hWnd :
*            x    :
*            y    :
*            width:
*            height:
*            rotation: µתǶ
*            (OUT)
*            
*   ֵ
* ˵ ѡ
**************************************************************************/
ZBOOL ResizeWindowEx(HWND hWnd,ZSINT32 x,ZSINT32 y, ZSINT32 width ,ZSINT32 height,ZSINT32 rotation);

/*******************************************************************************
* : IsAllMessageExceptTimerHandled
* : жд̵߳ϢϢǷִ(QS_TIMERϢ)
* ˵: 
* ֵ  : TRUE		Ϣ(QS_TIMER)Ϣ
*			FALSE		Ϣ(QS_TIMER)δ
* ˵: 
*******************************************************************************/
MG_EXPORT ZBOOL GUIAPI IsAllMessageExceptTimerHandled(ZVOID);

#endif//_ZCORE_WINDOW_H
