#ifndef _FW_AMS_H_
#define _FW_AMS_H_
#include "zcore_type.h"
#include "gdi.h"
#include "window.h"

#include "os_type.h"
#include "fw_pub.h"

#define CONST const

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */


/* Ӧó */
#define MAX_APP_NAME_LEN       32


/* ϵͳеӦó */
#define MAX_RUN_APPS_NUM       20


/* Ӧó */
typedef ZCHAR APP_NAME;

/* Ӧõȼ */
typedef enum
{
    APP_PRI_LOWEST = 0,
    APP_PRI_BELOW_NORMAL = 1,
    APP_PRI_NORMAL = 2,
    APP_PRI_ABOVE_NORMAL = 3,
    APP_PRI_HIGHEST = 4
    
} APP_PRIORITY_CLASS;

/* Ӧõ */
typedef enum
{
    TYPE_LOCAL = 0,
    TYPE_CS = 1,
    TYPE_PS = 2,
    TYPE_EXT = 3
    
} APP_TYPE;


/* ӦõСID */
/* CQNJ00216007 ӦIDͻǰ̨Ӧ */
#define APP_ID_MIN_VALUE              0x0001

/* ӦIDĻֵ */
#define APP_ID_LOCAL_BASE              APP_ID_MIN_VALUE
#define APP_ID_CS_BASE                 (APP_ID_LOCAL_BASE + 0x0100)
#define APP_ID_PS_BASE                 (APP_ID_CS_BASE + 0x0100)
#define APP_ID_EXT_BASE                (APP_ID_PS_BASE + 0x0100)


/* Ӧõ״̬ */
typedef enum
{
    RUN_FOREGND = 0,
    RUN_BACKGND = 1,
    RUN_READY   = 2,
    RUN_DEAD    = 3
} APP_RUN_STATE;

/* Ӧõͬ */
typedef enum
{
    RULE_WITHOUT_PRI = 0,
    RULE_WITH_PRI = 1
    
} APP_SYN_STRATEGY;


/* ӦõĲ */
typedef struct _APP_START_PARAM_
{
    HWND host;
    ZVOID* add_data;

} APP_START_PARAM, *PAPP_START_PARAM;


/* Ӧĺָ */
typedef SINT32 (*APP_START_FUNC_PTR)(APP_START_PARAM* param);

/* ֹͣӦõĲ */
typedef struct _APP_STOP_PARAM_
{
    ZVOID* add_data;

} APP_STOP_PARAM, *PAPP_STOP_PARAM;

/* ֹͣӦõĺָ */
typedef SINT32 (*APP_STOP_FUNC_PTR)(APP_STOP_PARAM* param);

/* ͣӦõĲ */
typedef struct _APP_PAUSE_PARAM_
{
    ZVOID* add_data;

} APP_PAUSE_PARAM, *PAPP_PAUSE_PARAM;

/* ͣӦõĺָ */
typedef SINT32 (*APP_PAUSE_FUNC_PTR)(APP_PAUSE_PARAM* param);

/* ظӦõĲ */
typedef struct _APP_RESUME_PARAM_
{
    ZVOID* add_data;

} APP_RESUME_PARAM, *PAPP_RESUME_PARAM;

/* ظӦõĺָ */
typedef SINT32 (*APP_RESUME_FUNC_PTR)(APP_RESUME_PARAM* param);

/* ӦõĿϢ */
typedef struct _START_APP_CTRL_INFO_
{
  APP_ID id;
  ZBOOL  thread_mode;
  ZVOID* add_data;
  //BOOL bNoHideActiveApp;/*ǷҪصǰӦ  TRUE صǰӦ  FALSE  صǰӦ*/
   
} START_APP_CTRL_INFO, *PSTART_APP_CTRL_INFO;

/* ֹͣӦõĿϢ */
typedef struct _STOP_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
   
} STOP_APP_CTRL_INFO, *PSTOP_APP_CTRL_INFO;

/* ͣӦõĿϢ */
typedef struct _PAUSE_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
  //BOOL bNoBack2RootApp;/*ǷҪ˻صӦ  TRUE ˻صӦãFALSE ˻ ӦһΪϵͳһӦ*/
} PAUSE_APP_CTRL_INFO, *PPAUSE_APP_CTRL_INFO;

/* ظӦõĿϢ */
typedef struct _RESUME_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
   
} RESUME_APP_CTRL_INFO, *PRESUME_APP_CTRL_INFO;

/* ӦõϢָ */
typedef SINT32 (*APP_MESSAGE_PROC_PTR)(UINT32 msg_id, ZVOID* param, UINT32 msg_size);

/* Ӧõľ̬洢Ϣ */
typedef struct _APP_STATIC_INFO_
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_START_FUNC_PTR app_start_func_ptr;
    APP_STOP_FUNC_PTR  app_stop_func_ptr;
    APP_PAUSE_FUNC_PTR app_pause_func_ptr;
    APP_RESUME_FUNC_PTR app_resume_func_ptr;
   // APP_MESSAGE_PROC_PTR app_msg_proc_ptr;
    
} APP_STATIC_INFO, *PAPP_STATIC_INFO;

/* ӦõĲѯ̬Ϣ */
typedef struct _APP_STATIC_OUT_INFO_
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    
} APP_STATIC_OUT_INFO, *PAPP_STATIC_OUT_INFO;

/* ӦʱϢ */
typedef struct _APP_RUN_INFO_
{
    APP_ID id;
    APP_RUN_STATE state;
    time_t start_time;  /* CQNJ00216061:Ԥչ*/
    UINT32 order;       /* Ԥչ*/
    ZBOOL thread_mode;
    time_t bkgnd_time;  /* CQNJ00216062:Ԥչ*/
    ZBOOL passive_bkgnd;    
    
} APP_RUN_INFO, *PAPP_RUN_INFO;

/* ϵͳӦõľ̬Ϣ */
typedef struct _SYS_STATISTIC_INFO_
{
    UINT32 total_count;
    UINT32 foregnd_count;
    APP_ID foregnd_apps[MAX_RUN_APPS_NUM];
    UINT32 backgnd_count;
    APP_ID backgnd_apps[MAX_RUN_APPS_NUM];

} SYS_STATISTIC_INFO, *PSYS_STATISTIC_INFO;

/* б */
enum AMS_ERR_CODE
{
    AMS_ERR_SUCCESS = 0, /* ȷ */
    AMS_ERR_FAILURE = -1, /*ʧ */
    AMS_ERR_NOT_INIT = -2, /* ģûгʼ */
    AMS_ERR_ALREADY_INIT = -3, /* ģѾʼ */
    AMS_ERR_MEMORY_ERROR = -4, /* ڴ */
    AMS_ERR_ALREADY_START = -5, /* ӦѾ */
    AMS_ERR_ALREADY_STOP = -6, /* ӦѾֹͣ */
    AMS_ERR_ALREADY_PAUSE = -7, /* ӦѾͣ */
    AMS_ERR_ALREADY_RESUME = -8, /* ӦѾָ */
    AMS_ERR_FORBID_START = -9, /* ֹӦ */
    AMS_ERR_FORBID_STOP = -10, /* ֹӦֹͣ */
    AMS_ERR_FORBID_PAUSE = -11, /* ֹӦͣ */
    AMS_ERR_FORBID_RESUME = -12, /* ֹӦûظ */
    AMS_ERR_NOT_START = -13, /* Ӧû */
    AMS_ERR_NOT_STOP = -14, /* Ӧûֹͣ */
    AMS_ERR_NOT_PAUSE = -15, /* Ӧûͣ */
    AMS_ERR_NOT_RESUME = -16, /* Ӧûлظ */
    AMS_ERR_PARAM_ERROR = -17, /*  */
    AMS_ERR_LIST_NULL = -18, /* бΪ */
    AMS_ERR_MAX_NUM = -19, /* Ŀﵽ */
    AMS_ERR_CHANNEL_FAILED = -20, /* ͨʧ */
    AMS_ERR_ID_ERROR = -21, /* ӦID */
    AMS_ERR_NAME_ERROR = -22, /* Ӧֳ */
    AMS_ERR_TYPE_ERROR = -23, /* Ӧͳ */
    AMS_ERR_PRIORITY_ERROR = -24, /* Ӧȼ */
	AMS_ERR_APP_HOSTWND_ERR = -25,/* йܴڴʧ */
	AMS_ERR_THREAD_CREATE_ERROR = -26, /* Ӧù̴߳ */ 
	AMS_ERR_SEMA_CREATE_ERROR = -27,  /* ź */
	AMS_ERR_NOT_REGISTERED = -28,    /* Ӧûע */
    AMS_ERR_ALREADY_REGISTERED = -29  /* ӦѾע */  
};

/* ʼӦùģ */
SINT32 tp_ams_init( ZVOID );

/* עӦùģ */
SINT32 tp_ams_release( ZVOID );

/* ӦĬ */
SINT32 tp_ams_default_app_start( APP_START_PARAM* param );

/* ӦĬֹͣ */
SINT32 tp_ams_default_app_stop( APP_STOP_PARAM* param );

/* ӦĬͣ */
SINT32 tp_ams_default_app_pause( APP_PAUSE_PARAM* param );

/* Ĭϻظ */
SINT32 tp_ams_default_app_resume( APP_RESUME_PARAM* param );

/* עĬͨϢ */
SINT32 tp_ams_register_message_proc( APP_ID id, APP_MESSAGE_PROC_PTR func_ptr );

/* Ӧõעắ */
SINT32 tp_ams_register_apps( CONST APP_STATIC_INFO* infos, UINT32 num );

/* Ӧõע */
SINT32 tp_ams_unregister_apps( CONST APP_ID* ids, UINT32 num );

/* ѯӦõľ̬Ϣ */
SINT32 tp_ams_query_app_static_info( APP_ID id, APP_STATIC_OUT_INFO* info );

/* ѯϵͳľ̬Ϣ */
SINT32 tp_ams_query_sys_statistic_info( SYS_STATISTIC_INFO* info );

/* ѯӦõϢ */
SINT32 tp_ams_query_app_run_info( APP_ID id, APP_RUN_INFO* info );

/* Ӧõв */
SINT32 tp_ams_set_syn_strategy( APP_SYN_STRATEGY type );

/* Ӧõ */
SINT32 tp_ams_start_app( START_APP_CTRL_INFO* ctrl_info );

/* Ӧõֹͣ */
SINT32 tp_ams_stop_app( STOP_APP_CTRL_INFO* ctrl_info );

/* Ӧõͣ */
SINT32 tp_ams_pause_app( PAUSE_APP_CTRL_INFO* ctrl_info );

/* ӦõĻظ */
SINT32 tp_ams_resume_app( RESUME_APP_CTRL_INFO* ctrl_info );

/* Ӧõйܴ */
HWND tp_ams_get_app_host_win_by_id(APP_ID appid);


/************    ¼ӽӿ   *********************/

/* ӦùϢIDֵ */
#define AMS_CHNL_MSG_ID_BASE            (MSG_ID_FW + 0x010)

/* Ӧõ/ֹͣ/ͣ/ظ ͨϢID */
#define AMS_START_APP              (AMS_CHNL_MSG_ID_BASE + 0x01)
#define AMS_STOP_APP               (AMS_CHNL_MSG_ID_BASE + 0x02)
#define AMS_PAUSE_APP              (AMS_CHNL_MSG_ID_BASE + 0x03)
#define AMS_RESUME_APP             (AMS_CHNL_MSG_ID_BASE + 0x04)
#define MSG_COMM  (AMS_CHNL_MSG_ID_BASE + 0x05)//whb

#define AMS_START_APP_WITH_PAUSE                0x00000001 /* ӦʱҪresumeһӦ */
#define AMS_START_APP_NO_PAUSE                  0x00000002 /*ӦʱҪreusmeһӦ */
#define AMS_PAUSE_APP_NO_RESUME                 0x00000004 /* ӦʱҪreusmeһӦ */
#define AMS_PAUSE_APP_WITH_RESUME               0x00000008 /* ӦʱҪresumeһӦ */
#define HAPP_INVALID                            0          /* ӦôϷ */

typedef UINT32 HAPP;    /* ӦõĴǾ */

/* ӦͨϢ */
typedef SINT32 (*APP_CHNL_MSG_PROC)(HAPP happ, UINT32 msg_id, ZVOID* msg_data, UINT32 msg_size);

/* 汾ʶϢ 2.0/3.0 */
typedef enum APP_VERSION_T
{
    APP_30 = 0,
    APP_20
}APP_VERSION;

/* Ӧʵģ */
typedef struct APP_TEMPLATE_T
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_VERSION version;
    HWND host;  /* Ӧõ߳УֵHWND_DESKTOPӦõйܴ */
    ZBOOL bStartBK;  /* Ӧų́ */
    APP_CHNL_MSG_PROC pMsgFunc; /* ͨ */
}APP_TEMPLATE;

/* ӦõⲿϢ */
typedef struct APP_OUT_INFO_T
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_VERSION version;

    APP_RUN_STATE state;
    time_t start_time;
    UINT32 order;
    time_t bkgnd_time;
    ZBOOL passive_bkgnd;

    ZBOOL thread_mode;   /* ߳УAMS߳ */
}APP_OUT_INFO;

/*  HWND_DESKTOPʧ*/
HAPP tp_ams_create_app(APP_TEMPLATE *templ);

/* AMS_ERR_SUCCESS, ɹʧ */
SINT32 tp_ams_destroy_app(HAPP happ);

/* HWND_INVALID ʧ*/
HWND tp_ams_get_rootwin(HAPP happ);

/* עͨϢ */
SINT32 tp_ams_reg_msg(HAPP happ, UINT32 msg_id);

/* עͨϢ */
SINT32 tp_ams_unreg_msg(HAPP happ, UINT32 msg_id);

/* ͨϢͬ*/
SINT32 tp_ams_post_msg(HAPP happ, UINT32 msg_id, ZVOID *msg_data, UINT32 msg_size);

/* ͨϢͬ*/
SINT32 tp_ams_send_msg(HAPP happ, UINT32 msg_id, ZVOID *msg_data, UINT32 msg_size);

/* AMS Ĭϴ */
SINT32 tp_ams_do_default(HAPP happ, UINT32 msg_id);

/* Ӧ0 ʾɹʧ */
SINT32 tp_ams_set_capacity(SINT32 capacity);

/* Ӧ*/
SINT32 tp_ams_get_capacity();

/* ӦõϢ */
SINT32 tp_ams_get_app_info(HAPP happ, APP_OUT_INFO* info);

/* õһӦôǾHAPP_INVALIDʧܻӦò */
HAPP tp_ams_get_first_app();

/* һӦô */
HAPP tp_ams_get_next_app(HAPP happ);

/* ôڵӦõĿֵС0ʧ */
SINT32 tp_ams_get_app_count();

ZBOOL tp_ams_set_app_run_attribute(APP_ID appId,ZSINT32 att);
ZSINT32 tp_ams_get_app_run_attribute(APP_ID appId);
HWND tp_ams_get_active_app_hostwnd(ZVOID);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif// _FW_AMS_H_

