#ifndef _MDL_RES_STRING_HASH_H_
#define _MDL_RES_STRING_HASH_H_

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#include <os_type.h>
#include <common.h>

  typedef unsigned int      HHASH;
  typedef void   (*FreeFun)  (void *val);

/*******************************************************
* FUNCTION
*      strcasecmp
* PARAM
*      str1
*      str2
* RETURN VALUE
*      
* COMMENT
*      strcasecmp
* *****************************************************
int strcasecmp(const char *str1,const char *str2);*/

/*******************************************************
* FUNCTION
*      StrHashTableCreate
* PARAM
*      hash_size:hash table size
*      free_val:free funcation
* RETURN VALUE
*      
* COMMENT
*      create hash table
* ******************************************************/
  HHASH StrHashTableCreate (unsigned int hash_size, FreeFun free_val);
  
/*******************************************************
* FUNCTION
*      StrHashTableDestroy
* PARAM
*      hHash:hash table handle
* RETURN VALUE
*      
* COMMENT
*      destroy hash table
* ******************************************************/  
  void  StrHashTableDestroy (HHASH hHash);
  
/*******************************************************
* FUNCTION
*      StrHashTableLookup
* PARAM
*      hHash:hash table handle
*      key:key
* RETURN VALUE
*      
* COMMENT
*      find value
* ******************************************************/    
  void  *StrHashTableLookup (HHASH hHash, const char *key);

/*******************************************************
* FUNCTION
*      StrHashTableInsert
* PARAM
*      hHash:hash table handle
*      key:key
*      val:
* RETURN VALUE
*      
* COMMENT
*      insert value
* ******************************************************/      
  BOOL  StrHashTableInsert (HHASH hHash, const char *key, void *val);

/*******************************************************
* FUNCTION
*      StrHashTableRemove
* PARAM
*      hHash:hash table handle
*      key:key
* RETURN VALUE
*      
* COMMENT
*      remove value
* ******************************************************/        
  BOOL  StrHashTableRemove (HHASH hHash, const char *key);

#ifdef __cplusplus
}
#endif

#endif/*_STRING_HASH_H_*/
