#ifndef MMI_GM_MAP_H
#define MMI_GM_MAP_H

#include "os_type.h"

#define USE_HASH_MAP
#define USE_RBT_MAP

#if defined(USE_HASH_MAP) || defined(USE_RBT_MAP)

#ifdef __cplusplus
extern "C"
{
#endif

typedef unsigned long   KeyType;
typedef unsigned long   ValueType;

typedef struct Pair
{
    KeyType         key;
    ValueType       value;
} T_Pair;

#ifndef NULL
#define NULL        ((void*)0)
#endif

#ifndef FALSE
#define FALSE       0
#endif

#ifndef TRUE
#define TRUE        (!FALSE)
#endif

#endif

/* map with hash table implementation */
#ifdef USE_HASH_MAP

#define RECOMMENDED_BUCKET_SIZE         128

typedef unsigned long (*HashFun)(KeyType);

typedef struct HashMap
{
    HashFun         fpHashFun;
    int             iBucketCnt;
    int             iBucketMask;
    T_Pair        **ppBuckets;
} T_HashMap;

unsigned long mmiGmHMHashFunUL(unsigned long);

#define mmiGmHMInit(pMap)       mmiGmHMInitEx(pMap, RECOMMENDED_BUCKET_SIZE, &mmiGmHMHashFunUL)

BOOL mmiGmHMInitEx(T_HashMap *pMap, int iBucketCnt, HashFun fpFun);
void mmiGmHMFree(T_HashMap *pMap);
BOOL mmiGmHMGet(T_HashMap *pMap, KeyType key, ValueType *pValue);
BOOL mmiGmHMSet(T_HashMap *pMap, KeyType key, ValueType value);
BOOL mmiGmHMRemove(T_HashMap *pMap, KeyType key, ValueType *pValue);

#endif

/* map with rb-tree implementation */
#ifdef USE_RBT_MAP

/* 'k1 == k2' is prepresented '!fpPred(k1, k2) && !fpPred(k2, k1)'.
   'fpPred' usually adopts '<'.
*/
typedef BOOL (*Predicator)(KeyType, KeyType);
typedef void (*Destructor)(ValueType);

struct TreeNode;

typedef struct Map
{
    Predicator          fpPred;
    struct TreeNode    *pTree;
} T_Map;

BOOL mmiGmMpLess(unsigned long, unsigned long);

#define mmiGmMpInit(pMap)       mmiGmMpInitEx(pMap, mmiGmMpLess)
BOOL mmiGmMpInitEx(T_Map *pMap, Predicator fpPred);

#define mmiGmMpFree(pMap)       mmiGmMpFreeEx(pMap, NULL)
void mmiGmMpFreeEx(T_Map *pMap, Destructor fpDestructor);

/* return tree node */
struct TreeNode* mmiGmMpGet(T_Map *pMap, KeyType key, ValueType *pValue);

#define mmiGmMpSet(pMap, key, value)    mmiGmMpSetEx(pMap, key, value, NULL)

/* It will be efficient if using return value of mmiGmMpGet
   as 'pNode' parameter, or set 'pNode' NULL is well.
*/
BOOL mmiGmMpSetEx(T_Map *pMap, KeyType key, ValueType value, struct TreeNode *pNode);
BOOL mmiGmMpRemove(T_Map *pMap, KeyType key, ValueType *pValue);

#endif


#ifdef __cplusplus
}
#endif

#endif
