#ifndef _BACKLIGHT_E_H
#define _BACKLIGHT_E_H

/*************************************************************************
  *                                  Include files                       *
  *************************************************************************/
#include "zcore_type.h"


/*************************************************************************
  *                                  Macro                               *
  *************************************************************************/


/**************************************************************************
 *                                  Types                                 *
 **************************************************************************/
typedef struct  MAN_KP_BACKLIGHT
{
    ZUINT32      light_time;
    ZUINT32      dim_time;
    ZUINT32      total_time;
} MAN_KP_BACKLIGHT;

typedef struct  MAN_BACKLIGHT_STATUS
{
    ZBOOL        is_opened;
    ZBOOL        is_working;
    MAN_KP_BACKLIGHT    setting;
    ZUINT16      brightness;
} MAN_KP_BACKLIGHT_STATUS;


/**************************************************************************
 *                           Global  Variable                             *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                          *
 **************************************************************************/
ZSINT32  tp_man_bl_kp_init(ZVOID);
ZSINT32  tp_man_bl_kp_release(ZVOID);
ZSINT32  tp_man_bl_kp_get_state(MAN_KP_BACKLIGHT_STATUS *state_ptr);
ZSINT32  tp_man_bl_kp_start(MAN_KP_BACKLIGHT *backlight_ptr);
ZSINT32  tp_man_bl_kp_end (ZVOID);
ZSINT32  tp_man_bl_kp_brightness (ZSINT32 brightness);

#endif /* _BACKLIGHT_E_H */

