#ifndef _KEYPAD_E_H
#define _KEYPAD_E_H

#include "zcore_type.h"
#include "plat_type_g.h"
typedef enum MAN_KBD_SCANCODE_
{
	    KEY_UP,
		KEY_DOWN,
		KEY_LEFT,
		KEY_RIGHT,
		KEY_LSK,
		KEY_RSK,
		KEY_SEND,
		KEY_SEND1,
		KEY_POWER,
		KEY_HANGUP,
		KEY_OK,//KEY_OK,
		KEY_CAMERA,
		KEY_BACK,
		KEY_SIDEKEYUP,
		KEY_SIDEKEYDOWN,
		KEY_1,
		KEY_2,
		KEY_3,
		KEY_4,
		KEY_5,
		KEY_6,
		KEY_7,
		KEY_8,
		KEY_9,
		KEY_0,
		KEY_ASTERISK, //'*'
		KEY_NUMBERSIGN, //'#'   
		KEY_CMMB,
		KEY_ONOFF,
		KP_KEY_MESSAGE,
		KP_KEY_12580,
		KP_KEY_HANDFREE,
		KEYUNKNOWN
}MAN_KBD_SCANCODE;

#define KE_KEYDOWN              0x0010
#define KE_KEYUP                0x0020

#define ME_MOVED                0x0000
#define ME_LEFTDOWN             0x0001
#define ME_LEFTUP               0x0002

#define    DD_TS_MSG_MOUSEOUT 0x0005
#define    DD_TS_MSG_MOUSEIN  0x0006
    
#define MAN_KP_INPUT  2
#define MAN_TS_INPUT  3

#define MAN_TSC_INPUT  3
#define MAN_TSC_PARAM_CALIBRATED 	1
#define MAN_TSC_PARAM_DEFAULT 		2
#define MAN_TSC_PARAM_NULL	 		(-1)
#ifdef WIN32
#ifndef ME_LDBCLICK
#define ME_LDBCLICK             0x0004
#endif
#endif
#define LWETYPE_KEY                     1
#define LWETYPE_MOUSE                   2


typedef struct  _MAN_KP_INFO_
{
    ZUINT8  scancode;   /* keypad scan code*/
    ZUINT8  status; /*key statusKE_KEYDOWNpressed; KE_KEYUPreleased */
    ZUINT8  times;  /* the time as key pressed, unit100ms*/
}MAN_KP_INFO;

typedef struct  _MAN_TS_INFO_
{
    ZUINT16 xvalue; /* ts x value*/
    ZUINT16 yvalue; /* ts x value*/
    ZUINT8  status; /*key statusME_LEFTDOWNpressed; ME_LEFTUPreleased, ME_MOVED:  move */
    ZUINT8  times;  /* the time as key pressed, unit100ms*/
    ZUINT16 rXVaule;     /* rx*/
    ZUINT16 rYVaule;     /* ry*/
}MAN_TS_INFO;




typedef enum _MAN_TSC_STATE_{
	#if  0
    TSC_PEN_NO_TOUCH,
    TSC_PEN_JUST_DOWN,
    TSC_PEN_KEEP_DOWN,
    TSC_PEN_JUST_UP    
    #endif
	TSC_PEN_NO_TOUCH,
	TSC_PEN_JUST_DOWN,
	TSC_PEN_JUST_UP,
	TSC_PEN_KEEP_DOWN
}MAN_TSC_STATE;

typedef struct  _MAN_TSC_INFO_
{
    UINT16	x;
    UINT16	y;
    MAN_TSC_STATE state;
}MAN_TSC_INFO;

typedef struct _MAN_TSC_POINT_{
    UINT16 x;
    UINT16 y;
}MAN_TSC_POINT;

SINT32 tp_man_kp_init(ZVOID);
SINT32 tp_man_kp_release(ZVOID);
SINT32  tp_man_wait_input(UINT32 timeout); /*Return: LWETYPE_KEY ¼LWETYPE_MOUSE ¼*/
SINT32  tp_man_kp_get_data(MAN_KP_INFO *kp_ptr);
SINT32  tp_man_ts_get_data(MAN_TS_INFO *ts_ptr);

#endif
