#ifndef IMGMGT_EH
#define IMGMGT_EH


/************************************************************************
 *                 ͷļ
 ************************************************************************/
#include "zcore_type.h"
#include "gui_g.h"
#include "gdi_e.h"
#include "DCMgt_e.h"
#include "zcore_bitmap_icon.h"


/*ͼƬ*/
typedef enum
{
    IT_INVALID,    /* δ֪ʽ */
    IT_JPEG,       /* JPEG */
    IT_GIF,        /* GIF */
    IT_GIF_ANIMATE,/* GIF  */
    IT_PNG,        /* PNG */
    IT_BMP,        /* BPM */
    IT_WBMP        /* WBPM */
} T_ImageType;

typedef struct
{
   /*OS ӿں */
    ZVOID*  (*memMalloc)(UINT32 dwSize);    /* ڴ */
    ZVOID   (*memFree)(ZVOID* p);            /* ڴͷ */
    FILE*  (* FileOpen)(const ZCHAR *filename,const ZCHAR *mode);
     size_t (*FileRead)(ZVOID *buffer1, size_t size, size_t count1, ZVOID *stream);
    //DWORD (*FileSeek )( FILE* fHandle, DWORD dwOffset, DWORD dwWhence );/*SEEKļ*/
    ZSINT32    (*FileSeek)(FILE *stream,ZLONG offset,ZSINT32 whence);
    ZSINT32    (*FileClose )(FILE* fp);        /*رļ*/
} T_IMGMGT_LoadPicOsParam;

typedef struct
{
    T_ImageType eType;  /* ļ */
    RGB atPal [256];           /* ͼĵɫ */
    MYBITMAP tBitmapInfo;      /* 豸޹λͼ */
} T_IMGMGT_LoadPicBitInfoParam;


/***************************************************************
 * λͼؽṹ
 **************************************************************/
#define IMAGE_NORMAL        0x1
#define IMAGE_COLORKEY      0x2
#define IMAGE_ALPHA_CHANNEL 0x4

typedef struct
{
    ZSINT32        iDelay;     /* in ms */
    ZVOID       *pFrame;
} T_GifFrame;

typedef struct
{
    /* ڴеݸЧ[in] */
    ZVOID        *pMem;
    ZSINT32         iMemSize;

    /* ûָɽͼߴ[in] */
    ZSINT32         iMaxWidth;
    ZSINT32         iMaxHeight;

    /* ڴӿ[in] */
    ZVOID* (*fpAlloc)(size_t size);
    ZVOID  (*fpFree)(ZVOID* p);

    /* ԭʼͼϢ[out] */
    T_ImageType eType;            /* ͼ */
    ZSINT32         iImageWidth;      /* ͼʵʿ */
    ZSINT32         iImageHeight;     /* ͼʵʸ߶ */

    /* ͼϢ[out] */
    ZSINT32         iWidth;           /* ݿ */
    ZSINT32         iHeight;          /* ݸ߶ */
    ZVOID        *pRgbData;        /* λͼ */

    /* GIFרϢ[out] */
    ZSINT32         iFrameCounter;    /* ֡ */
    T_GifFrame  *pAnimate;        /* ֡ */

    /* ͼ[out] */
    ZSINT32 transparent;/* ͼ͸ɫ */
    ZSINT32 nDepth;     /* λͼݵɫ */
    unsigned flags; /* ӱʶ */

    /* ʾ豸ʵɫ[in] */
    ZSINT32 physicalBpp;

    /* ݵֵ[in] */
    ZSINT32 iMaxSize;
} T_LoadImageParam;
/****************** End ***************************************/
#endif
