#ifndef WIDELINE_H
#define WIDELINE_H

#include "zcore_type.h"
typedef struct _Span
{
    ZSINT32 x, y;           /* start point */
    ZSINT32 width;          /* width of the span */
} Span;

typedef struct {
    ZSINT32   count;                /* number of spans                  */
    Span* points;               /* pointer to list of start points  */
} Spans;

typedef struct {
    ZSINT32                size;        /* Total number of *Spans allocated     */
    ZSINT32                count;       /* Number of *Spans actually in group   */
    Spans*  group;                  /* List of Spans                        */
    ZSINT32                ymin, ymax;  /* Min, max y values encountered        */
} SpanGroup;

typedef struct _SpanData {
    SpanGroup	fgGroup, bgGroup;
} SpanDataRec, *SpanDataPtr;

typedef struct _LineFace {
    ZDOUBLE  xa, ya;
    ZSINT32	    dx, dy;
    ZSINT32	    x, y;
    ZDOUBLE  k;
} LineFaceRec, *LineFacePtr;

typedef struct _PolyEdge {
    ZSINT32	    height;	/* number of scanlines to process */
    ZSINT32	    x;		/* starting x coordinate */
    ZSINT32	    stepx;	/* fixed integral dx */
    ZSINT32	    signdx;	/* variable dx sign */
    ZSINT32	    e;		/* initial error term */
    ZSINT32	    dy;
    ZSINT32	    dx;
} PolyEdgeRec, *PolyEdgePtr;


typedef struct _PolyVertex {
    ZDOUBLE  x, y;
} PolyVertexRec, *PolyVertexPtr;

typedef struct _PolySlope {
    ZSINT32	    dx, dy;
    ZDOUBLE  k;	    /* x0 * dy - y0 * dx */
} PolySlopeRec, *PolySlopePtr;

#define CLIPSTEPEDGE(edgey, edge, edgeleft) \
    if (baseY == edgey) \
    { \
        if (edgeleft) \
        { \
            if (edge->x > xcl) \
                xcl = edge->x; \
        } \
        else \
        { \
            if (edge->x < xcr) \
                xcr = edge->x; \
        } \
        edgey++; \
        edge->x += edge->stepx; \
        edge->e += edge->dx; \
        if (edge->e > 0) \
        { \
            edge->x += edge->signdx; \
            edge->e -= edge->dy; \
        } \
    }


ZVOID miWideLine (PT_DCMgt_DC pdc,  ZSINT32 npt,  POINT* pPts);
ZVOID miWideDash (PT_DCMgt_DC  pdc,  ZSINT32 npt,  POINT* pPts);


#endif
