#ifndef PIXOPS_H
#define PIXOPS_H
#include "zcore_type.h"
#include "os_type.h"

typedef ZUINT8   guchar;
typedef ZUINT32  guint32;
typedef ZUINT32  guint;
typedef ZSINT32  gboolean;

#define g_return_val_if_fail(a, b)  if (!(a)) return (b)
#define g_return_if_fail(a) if (!(a)) return

#define g_assert_not_reached()  printf("Not reached!\n")

#define g_new(a,b)  (a*)malloc((b)*sizeof(a))
#define g_malloc    malloc
#define g_free      free

#ifndef	FALSE
#define	FALSE	(0)
#endif

#ifndef	TRUE
#define	TRUE	(!FALSE)
#endif

#undef	MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))

#undef	MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))

#undef	ABS
#define ABS(a)	   (((a) < 0) ? -(a) : (a))

#undef	CLAMP
#define CLAMP(x, low, high)  (((x) > (high)) ? (high) : (((x) < (low)) ? (low) : (x)))

/* Interpolation modes; must match GdkInterpType */ 
typedef enum {
	PIXOPS_INTERP_NEAREST,
	PIXOPS_INTERP_TILES,
	PIXOPS_INTERP_BILINEAR,
	PIXOPS_INTERP_HYPER
} PixopsInterpType;

/* Scale src_buf from src_width / src_height by factors scale_x, scale_y
 * and composite the portion corresponding to
 * render_x, render_y, render_width, render_height in the new
 * coordinate system into dest_buf starting at 0, 0
 */
ZVOID pixops_scale    (guchar          *dest_buf,
                       ZSINT32              dest_width,
                       ZSINT32              dest_height,
                       ZSINT32              dest_rowstride,
                       ZSINT32              dest_channels,
                       ZSINT32              dest_has_alpha,
                       const guchar    *src_buf,
                       ZSINT32              src_width,
                       ZSINT32              src_height,
                       ZSINT32              src_rowstride,
                       ZSINT32              src_channels,
                       ZSINT32              src_has_alpha,
                       PixopsInterpType interp_type);
#endif
