#ifndef OS_QUEUE_H
#define OS_QUEUE_H

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/


/**************************************************************************
 *                                                             *
 **************************************************************************/
#define OS_QUEUE_INVALID_ID 0xFFFFFFFF


/**************************************************************************
 *                                                             *
 **************************************************************************/
typedef UINT32  OS_QUEUE_ID;

typedef struct _OS_QUEUE_INFO_ 
{ 
    OS_QUEUE_ID id;   
    CHAR        name[OS_MAX_NAME_LEN]; 
    UINT32      max_msg_num; 
    UINT32      used_count; 
} OS_QUEUE_INFO; 


/**************************************************************************
 *                        ԭ                                    *
 **************************************************************************/
OS_QUEUE_ID tp_os_queue_create( CHAR*name, UINT32 msg_size, UINT32 max_nums );
 
OS_STATUS   tp_os_queue_delete( OS_QUEUE_ID qid );

OS_STATUS   tp_os_queue_receive( OS_QUEUE_ID qid, VOID **msg_ptr, UINT32 timeout );

OS_STATUS   tp_os_queue_send( OS_QUEUE_ID qid, VOID *msg_ptr, UINT32 timeout );

OS_STATUS   tp_os_queue_info_get( OS_QUEUE_ID qid, OS_QUEUE_INFO *info_ptr );


#endif  /* OS_QUEUE_H */

