#ifndef _ZCORE_CTRL_LISTMODEL_H_
#define _ZCORE_CTRL_LISTMODEL_H_

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "zcore_type.h"
#include "ctrl/scrollview.h"
#include "ctrl/scrolled.h"
#include "list.h"


#ifdef __cplusplus
extern "C"
{
#endif
/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
 /** б״̬־
 CF_AUTOSORT:        Զ
 MGLIST_ST_FROZEN:   
*/
#define CF_AUTOSORT        0x00000001L  
#define MGLIST_ST_FROZEN   0x00000010L

/** б״̬־ 
CTST_NORMAL:     ͨ״̬
CTST_SELECTED:   ѡ״̬
*/
#define CTST_NORMAL     0x0000L    
#define CTST_SELECTED   0x0001L   

/** ȽϺ
MG_CMP_TYPE_NORMAL: ȽϺΪMGITEM_CMP
MG_CMP_TYPE_EX:ȽϺΪMGITEM_CMP_EX
*/
#define MG_CMP_TYPE_NORMAL      0
#define MG_CMP_TYPE_EX          1

/*б*/
#define mglist_for_each(pos, list) \
    list_for_each(pos, &((MgList *)list)->queue)

/*ȡбַ*/
#define mglist_entry(ptr) \
    list_entry(ptr, MgItem, list)

/*жбǷΪ*/
#define mglist_empty(mglst) \
    list_empty(&(mglst)->queue)

/*ȡһбĵַ*/
#define mglist_first_item(mglst) \
    list_entry((mglst)->queue.next, MgItem, list)
/**************************************************************************
 *                                                                *
 **************************************************************************/
/*б*/
typedef GHANDLE HITEM;

/*ȽϺ*/
typedef SVITEM_CMP MGITEM_CMP;

/*б*/
typedef struct _MgList MgList;

/*б*/
typedef struct _MgItem MgItem;

/*չб*/
typedef ZSINT32 (*MGITEM_CMP_EX) (MgList *mglst, HITEM hsvi1, HITEM hsvi2);

/*ȡָεĽӿ*/
typedef ZSINT32 (*MGITEM_GETRECT) (HWND hWnd, HITEM hitem, RECT *rcItem, ZBOOL bConv);

/*жλǷָڵĽӿ*/
typedef ZSINT32 (*MGITEM_ISIN)    (MgList *mglst, ZSINT32 mouseX, ZSINT32 mouseY, MgItem**pRet, ZSINT32 *item_y);

/*бӿ*/
typedef struct _mgitem_operations
{
    SVITEM_INITFUNC     initItem;          /*ʱ */
    SVITEM_DESTROYFUNC  destroyItem;       /*ʱ */
    SVITEM_DRAWFUNC     drawItem;          /*ʱ */
    SVITEM_DRAWFUNC     drawHintItem;      /*hintĿʱ new add for fold*/
    SVITEM_ADDHINTITEMFUNC addHintItem;    /*hintĿʱãnew add for fold*/
    MGITEM_GETRECT      getRect;           /* ȡľ*/
    MGITEM_ISIN         isInItem;          /*жλǷ*/
} MGITEMOPS;
typedef MGITEMOPS* PMGITEMOPS;

/* б */
struct _MgItem
{
    list_t  list;        /*бͷ*/
    list_t  sel_list;    /*ѡбͷ*/
    ZDWORD   flags;       /*б״̬־*/
    ZDWORD   addData;     /**/
};

/*б*/
struct _MgList
{
    ZSINT32        nItemNr;         /**/
    ZSINT32        nTotalItemH;     /*ߵĺ*/
    MgItem*    pItemHilighted;  /**/
    list_t     queue;           /*бͷ*/
    list_t     sel_queue;       /*ѡбͷ*/
    MGITEM_CMP itemCmp;         /*ȽϺ*/
    MGITEMOPS  iop;             /*ӿ*/
    HWND       hLst;            /*бھ*/
    ZDWORD      flags;           /*״̬־*/

};

/**************************************************************************
 *                         ȫֱ                                   *
 **************************************************************************/
 
/**************************************************************************
 *                        ȫֺԭ                                    *
 **************************************************************************/
 /**
 * ƣ DefaultItemViewProc
 *  бĬϢ
 * ˵ (IN) hWnd:    ؼ
 *			  (IN) message: ϢID
 *            (IN) wParam:  Ϣ
 *            (IN) lParam:  Ϣ
 *            (IN) pscrdata:
 *            (IN) mglst:   б 
 *   ֵϢ
 * ˵ 
 */
ZSINT32 DefaultItemViewProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam,
                         PSCRDATA pscrdata, MgList *mglst);

/**
 * ƣ mglist_init
 *  ʼб
 * ˵ (IN) mglst: б
 *			  (IN) hWnd:  ʹбĿؼ
 *   ֵ ɹ0
 * ˵ 
 */
ZSINT32 mglist_init (MgList *mglst, HWND hWnd);

/**
 * ƣ mglist_add_item
 *  б
 * ˵ (IN) mglst: б
 *			  (IN) ci: ӵ
 *			  (IN) hprev: ǰһ
 *			  (IN) hnext: ĺһ
 *			  (IN) nItem: ӵָλ
 *			  (OUT)  idx: ڷӵʵλ 
 *   ֵ ɹ0
 * ˵ б״̬ΪCF_AUTOSORTʱӵԶλã
 *            hprevhnextnItemЧ
 *            hprevhnextnItemֻõһȼϵΪ
 *            hprevhnextnItem
 *            hprevЧʱӵhprevhnextЧʱӵ
 *            hnext֮ǰnItemЧʱӵnItemָλá
 */
ZSINT32 mglist_add_item (MgList *mglst, MgItem* ci, MgItem* hprev, MgItem *hnext, 
                                       ZSINT32 nItem, ZSINT32 *idx);

/**
 * ƣ mglist_del_item
 *  бɾָ
 * ˵ (IN) mglst: б
 *			  (IN) hitem:  ɾ
 *   ֵ 0
 * ˵ 
 */
ZSINT32 mglist_del_item (MgList *mglst, MgItem* hitem);

/**
 * ƣ mglist_get_item_adddata
 *  ȡĸ
 * ˵ (IN) hitem: 
 *   ֵ 
 * ˵ 
 */
ZDWORD mglist_get_item_adddata (HITEM hitem);

/**
 * ƣ mglist_set_item_adddata
 *  ĸ
 * ˵ (IN) hitem: 
 *            (IN) adddata: 
 *   ֵ ԭеĸݣhitemΪNULL򷵻0
 * ˵ 
 */
ZDWORD mglist_set_item_adddata (HITEM hitem, ZDWORD adddata);

/**
 * ƣ mglist_hilight_item
 *  бָ
 * ˵ (IN) mglst: б
 *            (IN) hitem: 
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_hilight_item (MgList *mglst, MgItem* hitem);

/**
 * ƣ mglist_refresh_item_ex
 *  ˢָָˢ
 * ˵ (IN) mglst: б
 *            (IN) hitem: 
 *            (IN) rcInv: ָˢ
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_refresh_item_ex (MgList *mglst, HITEM hitem, const RECT *rcInv);

/**
 * ƣ mglist_refresh_item
 *  ˢָ
 * ˵ (IN) mglst: б
 *            (IN) hitem: 
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_refresh_item (MgList *mglst, HITEM hitem);

/**
 * ƣ mglist_set_itemdraw
 *  бĻбĺ
 * ˵ (IN) mglst:     б
 *			  (IN) draw_func: ƺ
 *   ֵ ɵĻƺ
 * ˵ 
 */
SVITEM_DRAWFUNC mglist_set_itemdraw (MgList *mglst, SVITEM_DRAWFUNC draw_func);

/**
 * ƣ mglist_set_itemops
 *  бĽӿ
 * ˵ (IN) mglst: б
 *            (IN) iop: ӿ
 *   ֵ 
 * ˵ ӿڲΪղãΪԭкӿ
 */

SVITEM_DRAWFUNC mglist_set_hintitemdraw (MgList *mglst, SVITEM_DRAWFUNC draw_func);
/**
 * ƣ mglist_set_hintitemdraw
 *  бĻбĺ
 * ˵ (IN) mglst:     б
 *			  (IN) draw_func: ƺ
 *   ֵ ɵĻƺ
 * ˵ 
 */



SVITEM_ADDHINTITEMFUNC mglist_set_hintitemadd (MgList *mglst, SVITEM_ADDHINTITEMFUNC draw_func);
/**
 * ƣ mglist_set_hintitemadd
 *  бhintбĺ
 * ˵ (IN) mglst:     б
 *			  (IN) draw_func: ƺ
 *   ֵ ɵhint
 * ˵ 
 */

ZVOID mglist_set_itemops (MgList *mglst, PMGITEMOPS iop);

/**
 * ƣ mglist_get_item_by_index
 *  ȡбָλõ
 * ˵ (IN) mglst: б
 *            (IN) nItem: беλ
 *   ֵ ָָ룬ʱNULL
 * ˵ 
 */
MgItem* mglist_get_item_by_index (MgList *mglst, ZSINT32 nItem);

/**
 * ƣ mglist_get_next_item
 *  ȡбָһ
 * ˵ (IN) mglst: б
 *            (IN) hitem: ָ
 *   ֵ hitemһhitemΪһNULL
 * ˵ 
 */
MgItem* mglist_get_next_item (MgList *mglst, MgItem* hitem);

/**
 * ƣ mglist_get_prev_item
 *  ȡбָǰһ
 * ˵ (IN) mglst: б
 *            (IN) hitem: ָ
 *   ֵ hitemǰһhitemΪһNULL
 * ˵ 
 */
MgItem* mglist_get_prev_item (MgList *mglst, MgItem* hitem);

/**
 * ƣ mglist_move_item
 *  ƶָpreitemڣpciƵpreitem֮󣬷
              pciƵб
 * ˵ (IN) mglst: б
 *            (IN) pci: ָ
 *            (IN) preitem: Ŀλõǰһ
 *   ֵ 0
 * ˵ 
 */
ZSINT32 mglist_move_item (MgList *mglst, MgItem* pci, MgItem* preitem);

/**
 * ƣ mglist_getitem_byindex
 *  ȡָ
 * ˵ (IN) mglst: б
 *            (IN) index: 
 *   ֵ ָ룬ΧʱNULL
 * ˵ 
 */
MgItem* mglist_getitem_byindex (MgList *mglst, ZSINT32 index);

/**
 * ƣ mglist_get_item_index
 *  ȡָбе
 * ˵ (IN) mglst: б
 *            (IN) item: ָ
 *   ֵ itemmglstitemmglstﷵ-1
 * ˵ 
 */
ZSINT32 mglist_get_item_index (MgList *mglst, MgItem *item);

/**
 * ƣ mglist_sort_items
 *  бе
 * ˵ (IN) mglst: б
 *            (IN) pfn: ʹõıȽϺ
 *            (IN) fn_type: ȽϺͣ
 *                          MG_CMP_TYPE_NORMAL: ȽϺΪMGITEM_CMP
 *                          MG_CMP_TYPE_EX:ȽϺΪMGITEM_CMP_EX
 *   ֵ ɹ0pfnΪNULLfn_typeΪָ֮
 *            -1
 * ˵ ʱб
 */
ZSINT32 mglist_sort_items (MgList *mglst, ZVOID* pfn, ZSINT32 fn_type);

/**
 * ƣ mglist_make_item_visible
 *  ʹָɼ
 * ˵ (IN) mglst: б
 *            (IN) pscrdata: ؼĹ
 *            (IN) hitem: ɼ
 *   ֵ ɹ0pfnΪNULLfn_typeΪָ֮
 *            -1
 * ˵ 
 */
ZBOOL mglist_make_item_visible (MgList *mglst, PSCRDATA pscrdata, HITEM hitem);

/**
 * ƣ mglist_freeze
 *  б
 * ˵ (IN) hWnd: ؼ
 *            (IN) mglst: б
 *            (IN) lock: TRUEʾᡢFALSEⶳ
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_freeze (HWND hWnd, MgList *mglst, ZBOOL lock);

/**
 * ƣ mglist_adjust_items_height
 *  бĸ߶
 * ˵ (IN) hWnd: ؼ
 *            (IN) mglst: б
 *            (IN) pscrdata: 
 *            (IN) diff: ֵ
 *   ֵ 0
 * ˵ бʱ
 */
ZSINT32 mglist_adjust_items_height (HWND hWnd, MgList *mglst, PSCRDATA pscrdata, ZSINT32 diff);

/**
 * ƣ mglist_redraw_item
 *  ػָ
 * ˵ (IN) mglst: б
 *            (IN) hivi: ػ
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_redraw_item (MgList *mglst, HITEM hivi);

/**
 * ƣ mglist_cancelhilight_item
 *  ȡ
 * ˵ (IN) mglst: б
 *   ֵ 
 * ˵ 
 */
ZVOID mglist_cancelhilight_item (MgList *mglst);  

/**
 * ƣ mglist_is_item_hilight
 *  ָǷ
 * ˵ (IN) mglst: б
 *            (IN) hitem: ָ
 *   ֵ hitemǸTRUE򷵻FALSE
 * ˵ 
 */
static ZBOOL mglist_is_item_hilight (MgList *mglst, MgItem* hitem)
{
    return mglst->pItemHilighted == hitem;
}   

/**
 * ƣ mglist_is_item_selected
 *  ָǷѡ
 * ˵ (IN) pci: 
 *   ֵ pciѡTRUE򷵻FALSE
 * ˵ 
 */
static ZBOOL mglist_is_item_selected (MgItem* pi)
{   
    return pi->flags & CTST_SELECTED;
}   

/**
 * ƣ mglist_get_hilighted_item
 *  ȡбĸ
 * ˵ (IN) mglst: б
 *   ֵ ָ룬޸ΪNULL
 * ˵ 
 */    
static MgItem* mglist_get_hilighted_item (MgList *mglst)
{
    return mglst->pItemHilighted;
}

/**
 * ƣ mglist_set_hilighted_item
 *  бĸΪָ
 * ˵ (IN) mglst: б
 *            (IN) item: ָ
 *   ֵ ԭиָ
 * ˵ 
 */
static MgItem* mglist_set_hilighted_item (MgList *mglst, MgItem *item)
{   
    MgItem *old;

    old = mglst->pItemHilighted;
    mglst->pItemHilighted = item;
    return old;
}   

/**
 * ƣ mglist_select_item
 *  ָѡ״̬
 * ˵ (IN) mglst: б
 *            (IN) pci: ָ
 *            (IN) bSel: Ƿѡ
 *   ֵ 
 * ˵ 
 */
static ZVOID mglist_select_item (MgList *mglst, MgItem* pi, ZBOOL bSel)
{
    if (bSel) 
    {
        if (!(pi->flags & CTST_SELECTED))
        {
            pi->flags |= CTST_SELECTED;
            list_add_tail (&pi->sel_list, &mglst->sel_queue);
        }
    }
    else 
    {
        if (NULL != pi && pi->flags & CTST_SELECTED)
        {
            pi->flags &= ~CTST_SELECTED;
            list_del (&pi->sel_list);
        }
    }
}

/**
 * ƣ mglist_unselect_all
 *  ȡбѡ״̬
 * ˵ (IN) mglst: б
 *   ֵ 
 * ˵ 
 */
static ZVOID mglist_unselect_all (MgList *mglst)
{
    MgItem* pi;

    while (!list_empty (&mglst->sel_queue)) 
    {
        pi = list_entry (mglst->sel_queue.next, MgItem, sel_list);
        if (pi->flags & CTST_SELECTED)
        {
            pi->flags &= ~CTST_SELECTED;
            list_del (mglst->sel_queue.next);
        }
    }
}

/**
 * ƣ mglist_select_one_item
 *  ȡбѡѡָ
 * ˵ (IN) mglst: б
 *            (IN) hitem: ѡ
 *   ֵ 
 * ˵ 
 */
static ZVOID mglist_select_one_item (MgList *mglst, MgItem* hitem)
{
    MgItem* pi = (MgItem*)hitem;

    if (!pi) return;

    mglist_unselect_all (mglst);
    mglist_select_item (mglst, pi, TRUE);
}

/**
 * ƣ mglist_select_all
 *  ѡб
 * ˵ (IN) mglst: б
 *   ֵ 
 * ˵ 
 */
static ZVOID mglist_select_all (MgList *mglst)
{
    MgItem* pi;
    list_t *me;

    list_for_each (me, &mglst->queue) 
    {
        pi = list_entry (me, MgItem, list);
        mglist_select_item (mglst, pi, TRUE);
    }
}

/**
 * ƣ mglist_get_item_count
 *  ȡб
 * ˵ (IN) mglst: б
 *   ֵ 
 * ˵ 
 */
static ZSINT32 mglist_get_item_count (MgList *mglst)
{
    return mglst->nItemNr;
}

/**
 * ƣ mglist_set_autosort
 *  бΪԶ
 * ˵ (IN) mglst: б
 *   ֵ 
 * ˵ 
 */
static ZVOID mglist_set_autosort (MgList *mglst)
{
    mglst->flags |= CF_AUTOSORT;
}

/**
 * ƣ mglist_is_frozen
 *  жбǷ񱻶
 * ˵ (IN) mglst: б
 *   ֵ ᷵TRUE򷵻FALSE
 * ˵ 
 */
static ZBOOL mglist_is_frozen (MgList *mglst)
{
    return mglst->flags & MGLIST_ST_FROZEN;
}

/**
 * ƣ mglist_get_total_item_height
 *  ȡб
 * ˵ (IN) mglst: б
 *   ֵ бĸ߶
 * ˵ 
 */
static ZSINT32 mglist_get_total_item_height (MgList *mglst)
{
    return mglst->nTotalItemH;
}

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _ZCORE_CTRL_LISTMODEL_H_ */

