#ifndef _ENGINE_MEM_H
#define _ENGINE_MEM_H

#include "zcore_type.h"
#ifdef __cplusplus
extern "C"
{
#endif

#ifndef NULL
#define NULL (ZVOID *)0
#endif

extern ZVOID* ENGINE_MALLOC(ZUINT32 size);
extern ZVOID  ENGINE_MEMCPY(ZVOID *pDest,const ZVOID *pSrc,ZUINT32 len);
extern ZVOID  ENGINE_MEMSET(ZVOID *pDest,ZUINT8 value,ZUINT32 len); 
extern ZVOID  ENGINE_FREE(ZVOID *pDest);   

#ifndef FREEIF
#define FREEIF(p) if(NULL != p) {ENGINE_FREE(p); p = NULL;}
#endif

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
