#ifndef _ZCORE_GUICOMMON_H_
#define _ZCORE_GUICOMMON_H_

#include "zcore_type.h"
#include "common.h"
/**************************************************************************
 *                         ṹͶ                                    *
 **************************************************************************/

/**
 * \var typedef unsigned char Uint8
 * \brief A type definition for an 8-bit unsigned character.
 */
#ifndef ZUINT8 
typedef ZUINT8   Uint8;
#endif
/**
 * \var typedef signed char Sint8
 * \brief A type definition for an 8-bit signed character.
 */
#ifndef Sint8
typedef ZSINT8     Sint8;
#endif
/**
 * \var typedef unsigned short Uint16
 * \brief A type definition for a 16-bit unsigned integer.
 */
#ifndef Uint16
typedef ZUINT16  Uint16;
#endif
/**
 * \var typedef signed short Sint16
 * \brief A type definition for a 16-bit signed integer.
 */
#ifndef Sint16
typedef ZSINT16    Sint16;
#endif
/**
 * \var typedef unsigned int Uint32
 * \brief A type definition for a 32-bit unsigned integer.
 */
#ifndef _HAVE_TYPE_Uint32
#define _HAVE_TYPE_Uint32
typedef ZUINT32    Uint32;
#endif
/**
 * \var typedef signed int ZSINT32
 * \brief A type definition for a 32-bit signed integer.
 */
#ifndef _HAVE_TYPE_Sint32
#define _HAVE_TYPE_Sint32
typedef ZSINT32      Sint32;
#endif


#ifndef _HAVE_TYPE_BYTE
#define _HAVE_TYPE_BYTE
//typedef unsigned char   BYTE;
#endif
typedef ZUINT8 ZBYTE;
//typedef ZBYTE *       ZPUINT8;

typedef ZUINT16  ZWORD;
typedef ZWORD *       PWORD;

//typedef ZSINT16  SWORD;
//typedef SWORD *       PSWORD;

//typedef ZSLONG   SDWORD;
//typedef SDWORD *      PSDWORD;

typedef	ZULONG 	 zuint32; //UINT32 UInt32
/***
typedef ZUINT8       ZUINT8;
typedef ZUINT16      ZUINT16;
***/
typedef zuint32 ZCORE_OS_THREAD_ID;
typedef zuint32 ZCORE_OS_SEMA_ID ;
typedef ZVOID (* ZCORE_OS_THREAD_ENTRY)(ZVOID *param );
typedef ZVOID (* ZCORE_OS_FUNC_ENTRY)(ZVOID *param );

#define ZCORE_OS_AUTO_LOAD 0x0002
#define ZCORE_OS_AUTO_ACTIVATE 0x0001
#define ZCORE_OS_THREAD_INVALID_ID 0xFFFFFFFF

/***
#ifndef ZBOOL
typedef ZSINT32  ZBOOL;
#endif
***/

#ifndef TRUE
    #define TRUE        1
#endif

#ifndef FALSE
    #define FALSE       0
#endif

#ifndef NULL
#define NULL        ((ZVOID *)0)
#endif

#define GUIAPI

 /**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#ifndef TYPE_MG_EXPORT
#define TYPE_MG_EXPORT
#define MG_EXPORT extern
#endif

#ifndef MG_IMPORT
#define MG_IMPORT
#endif

#ifndef ZVOID
#define ZVOID        ZVOID
#endif

#define ZCORE_WAIT_FOREVER 0XFFFFFFFF
#define ZCORE_NO_WAIT  0X00000000

#define ZCORE_OS_FAILURE 0xffffffff
#define ZCORE_OS_SUCCESS  0x00000000
/**
 * Returns the low ZBYTE of the ZWORD \a w.
 */
#define LOBYTE(w)           ((ZBYTE)(w))
/**
 * \brief Returns the high ZBYTE of the ZWORD \a w.
 */
#define HIBYTE(w)           ((ZBYTE)(((ZWORD)(w) >> 8) & 0xFF))

/**
 *  Makes a ZWORD from \a low ZBYTE and \a high ZBYTE.
 */
#define MAKEWORD(low, high) ((ZWORD)(((ZBYTE)(low)) | (((ZWORD)((ZBYTE)(high))) << 8)))

/**
 *Returns the low ZWORD of the ZDWORD \a l
 */
#define LOWORD(l)           ((ZWORD)(ZDWORD)(l))

/**
 * Returns the high ZWORD of the ZDWORD \a l
 */
#define HIWORD(l)           ((ZWORD)((((ZDWORD)(l)) >> 16) & 0xFFFF))

/**
 * Returns the low signed ZWORD of the ZDWORD \a l
 */
#define LOSWORD(l)          ((SWORD)(ZDWORD)(l))
/**
 *  Returns the high signed ZWORD of the ZDWORD \a l
 */
#define HISWORD(l)          ((SWORD)((((ZDWORD)(l)) >> 16) & 0xFFFF))

/**
 * Makes a ZDWORD from \a low ZWORD and \a high ZWORD.
 */
#define MAKELONG(low, high) ((ZDWORD)(((ZWORD)(low)) | (((ZDWORD)((ZWORD)(high))) << 16)))

/*ȡֵ*/
#ifndef MAX
#define MAX(x, y)           ((x > y)?x:y)
#endif
/*ȡСֵ*/
#ifndef MIN
#define MIN(x, y)           ((x < y)?x:y)
#endif
/*ȡֵ*/
#ifndef ABS
#define ABS(x)              (((x)<0) ? -(x) : (x))
#endif

/**
 *  General handle.
 */
typedef ZUINT32 GHANDLE;

/**
 * Handle to main window or control.
 */
#ifndef HWND
typedef ZUINT32 HWND;
#endif
/**
 * Handle to device context.
 */
typedef ZUINT32 HDC;

/**
 *  Handle to cursor.
 */
typedef ZUINT32 HCURSOR;

/**
 * Handle to icon.
 */
typedef ZUINT32 HICON;

/**
 * Handle to menu.
 */
typedef ZUINT32 HMENU;

/**
 * Handle to accelarator.
 */
typedef ZUINT32 HACCEL;

/**
 *  Handle to dialog box, same as HWND.
 */
typedef ZUINT32 HDLG;

/**
 * \brief Handle to keyboard or mouse event hook.
 */
typedef ZUINT32 HHOOK;

/**
 * type definition for the first message paramter.
 */
#ifndef _TYPE_WPARAM
#define _TYPE_WPARAM
typedef ZUINT32 WPARAM;
#endif

/**
 * type definition for the second message paramter.
 */
//typedef unsigned long LPARAM;
#ifndef _TYPE_LPARAM
#define _TYPE_LPARAM
typedef ZULONG LPARAM;
#endif

#ifndef _HAVE_TYPE_ZUINT
#define _HAVE_TYPE_ZUINT
typedef ZUINT32    ZUINT;
#endif

typedef ZLONG fixed;
typedef ZULONG ZDWORD;
typedef ZDWORD *       PDWORD;

typedef ZUINT32 gal_pixel;

typedef struct _RECT
{
    ZSINT32 left;	/*Ͻǵx*/
    ZSINT32 top;	/*Ͻǵy*/
    ZSINT32 right;	/*½ǵx*/
    ZSINT32 bottom;/*½ǵy*/
} RECT;

typedef RECT* PRECT;


typedef struct _POINT
{
    ZSINT32 x; /*x*/
    ZSINT32 y; /*y*/
} POINT;

typedef POINT*	PPOINT;


typedef struct _SIZE
{
    /*
     * the extent in x coordinate of a 2D object.
     */
    ZSINT32 cx;
    /*
     * the extent in y coordinate of a 2D object.
     */
    ZSINT32 cy;
} SIZE;

typedef SIZE* PSIZE;

/*
 * RGB triple structure.
 */
typedef struct _RGB
{
    /*
     * the red component of a RGB triple.
     */
    ZBYTE r;
    /*
     * the green component of a RGB triple.
     */
    ZBYTE g;
    /*
     * the blue component of a RGB triple.
     */
    ZBYTE b;
    /*
     * Reserved for alignment, maybe used for the alpha component of a RGB triple.
     */
    ZBYTE a;
} RGB;
typedef RGB* PRGB;

#endif //end _ZCORE_GUICOMMON_H_
