#ifndef _ZCORE_SCROLLBAR_H
#define _ZCORE_SCROLLBAR_H
#include "zcore_type.h"

/*scrollbar_fns Scroll bar operations */
#define SB_HORZ     1
#define SB_VERT     2

//Retrives or sets the range of the scroll bar.
#define SIF_RANGE           	(1<<0)//0x0001
//Retrives or sets the page size of the scroll bar.
#define SIF_PAGE            	(1<<1)//0x0002
//Retrives or sets the position of the scroll bar.
#define SIF_POS             	(1<<2)//0x0004
//Hides the scroll when disabled, not implemented so far.
#define SIF_DISABLENOSCROLL 	(1<<3)//0x0008
#define SIF_ALL             (SIF_RANGE | SIF_PAGE | SIF_POS)

typedef struct _SCROLLINFO
{
    ZUINT    cbSize;
    /*SIF_RANGE/SIF_PAGE/SIF_POS/SIF_DISABLENOSCROLL/ */
    ZUINT    fMask;
    ZSINT32     nMin;
    ZSINT32     nMax;
    ZUINT    nPage;
    ZSINT32     nPos;
} SCROLLINFO, *PSCROLLINFO;

/*shows or hides the specified scroll bar.*/
ZBOOL ShowScrollBar (HWND hWnd, ZSINT32 iSBar, ZBOOL bShow);

#endif
