#ifndef _FW_PUB_H_
#define _FW_PUB_H_

#include "zcore_type.h"
#include "os_type.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/*
** define application id 
*/
typedef UINT32 APP_ID;

/*
** define user-defined GUI window messages 
** id base value of FW and APP
*/
#define USER_MSG_ID_FWKER_BASE         0x1800 /* (MSG_USER + 0x1000) */  /* 0x1800~ */
#define USER_MSG_ID_FWEXT_BASE         (USER_MSG_ID_FWKER_BASE + 0x0400) /* 0x1c00~ */
#define USER_MSG_ID_APP_BASE           (USER_MSG_ID_FWEXT_BASE + 0x0400) /* 0x2000~ */


/* 
** define framework error code list
*/
enum FW_ERR_CODE 
{
   FW_ERR_SUCCESS = 0,   /* generally success error code */
   FW_ERR_FAILURE = -1,  /* generally failure error code */
   FW_ERR_ALREADY_INIT = -2,  /* moude has been already inited */
   FW_ERR_NOT_INIT = -3,  /* moude hasn't been inited yet */
   FW_ERR_MEMORY_ERROR = -4,  /* memory error */
   FW_ERR_SUBMOD_ERROR = -5,  /* sub-module error */
};   


/*
** initialize fw_kernel module
*/
SINT32 tp_fw_kernel_init( ZVOID );

/*
** terminate fw_kernel module
*/
SINT32 tp_fw_kernel_term( ZVOID );

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif/* _FW_PUB_H_ */



