#ifndef MMI_GM_UTILITIES_H
#define MMI_GM_UTILITIES_H

#include <minigui/common.h>
#include <minigui/gdi.h>
#include <minigui/window.h>
#include <minigui/control.h>
#include <os_type.h>
//typedef unsigned int  UINT32;
//typedef unsigned char UINT8;
char* mmiGmStrNCat(char *strDest, const char *strSource, unsigned int count);

/* base list */
struct GmBaseList;

typedef struct GmListNode
{
    struct GmBaseList  *pList;
    struct GmListNode  *pPrev;
    struct GmListNode  *pNext;
} T_GmListNode;

typedef struct GmBaseList
{
    T_GmListNode       *pHead;
    T_GmListNode       *pTail;
    UINT32              uiSize;
    void (*DestructUserData)(void*);
} T_GmBaseList;

void mmiGmBaseListInit(T_GmBaseList *pList, void (*fpDestructorUserData)(void*));
void mmiGmBaseListFree(T_GmBaseList *pList);
T_GmListNode* mmiGmBaseListPushFront(T_GmBaseList *pList, UINT32 uiDataSize);
T_GmListNode* mmiGmBaseListPushBack(T_GmBaseList *pList, UINT32 uiDataSize);
void mmiGmBaseListPopFront(T_GmBaseList *pList);
void mmiGmBaseListPopBack(T_GmBaseList *pList);
T_GmListNode* mmiGmBaseListInsertFrontOf(T_GmListNode *pNode, UINT32 uiDataSize);
T_GmListNode* mmiGmBaseListInsertBackOf(T_GmListNode *pNode, UINT32 uiDataSize);
void mmiGmBaseListRemoveNode(T_GmListNode *pNode);

/* base array */
typedef struct GmBaseArray
{
    UINT8      *pBuffer;
    UINT32      uiUnitSize;
    UINT32      uiSize;
    UINT32      uiCapacity;
    void (*DestructUserData)(void*);
} T_GmBaseArray;

int mmiGmBaseArrayInit(T_GmBaseArray *pArray, UINT32 uiUnitSize, void (*fpDestructUserData)(void*));
void mmiGmBaseArrayFree(T_GmBaseArray *pArray);
void mmiGmBaseArrayClear(T_GmBaseArray *pArray);
int mmiGmBaseArrayClone(T_GmBaseArray *pDest, T_GmBaseArray *pSrc, int bFreeDest);
int mmiGmBaseArrayGrow(T_GmBaseArray *pArray);
void mmiGmBaseArrayTidy(T_GmBaseArray *pArray);
int mmiGmBaseArrayPushFront(T_GmBaseArray *pArray);
int mmiGmBaseArrayPushBack(T_GmBaseArray *pArray);
int mmiGmBaseArrayPushBackN(T_GmBaseArray *pArray, UINT32 uiSize);
int mmiGmBaseArrayInsertAt(T_GmBaseArray *pArray, UINT32 idx);
int mmiGmBaseArrayInsert(T_GmBaseArray *pArray, UINT32 idx, UINT32 nCount);
void mmiGmBaseArrayRemoveAt(T_GmBaseArray *pArray, UINT32 idx);
void mmiGmBaseArrayRemove(T_GmBaseArray *pArray, UINT32 uiFrom, UINT32 uiTo);
#define mmiGmBaseArrayPopFront(arr)        mmiGmBaseArrayRemoveAt((arr), 0)
#define mmiGmBaseArrayPopBack(arr)        mmiGmBaseArrayRemoveAt((arr), (arr)->uiSize - 1)

/* int set */
typedef struct
{
    UINT32          uiStart;
    UINT32          uiEnd;
} T_GmIntRange;

typedef struct
{
    T_GmBaseArray   tContainer;
} T_GmIntSet;

int mmiGmIntSetLowerBound(T_GmIntSet *pSet, UINT32 uiNum);
int mmiGmIntSetUpperBound(T_GmIntSet *pSet, UINT32 uiNum);
int mmiGmIntSetInit(T_GmIntSet *pSet);
void mmiGmIntSetFree(T_GmIntSet *pSet);
void mmiGmIntSetTidy(T_GmIntSet *pSet);
int mmiGmIntSetClone(T_GmIntSet *pDest, T_GmIntSet *pSrc, int bFreeDest);
int mmiGmIntSetEqual(T_GmIntSet *pLeft, T_GmIntSet *pRight);
void mmiGmIntSetSet(T_GmIntSet *pSet, UINT32 uiNum);
void mmiGmIntSetSetRange(T_GmIntSet *pSet, UINT32 uiStart, UINT32 uiEnd);
void mmiGmIntSetClear(T_GmIntSet *pSet, UINT32 uiNum);
void mmiGmIntSetClearAll(T_GmIntSet *pSet);
int mmiGmIntSetInSet(T_GmIntSet *pSet, UINT32 uiNum);

#endif
