#ifndef KEYPAD_H
#define KEYPAD_H
#include "zcore_type.h"
/* the keypad input event flag */
#define MAN_KP_INPUT  2
#define MAN_TS_INPUT  3


typedef enum  MAN_KBD_TYPE_
{
   KE_KEYUP = 0, 
   KE_KEYDOWN = 1,
}MAN_KBD_TYPE;

typedef enum  MAN_ME_TYPE_
{
    ME_LEFTDOWN = 1,
    ME_LEFTUP   = 2,
    ME_MOVED    = 3,   
    ME_LDBCLICK = 4,
    DD_TS_MSG_MOUSEOUT = 5,
    DD_TS_MSG_MOUSEIN = 6 
}MAN_ME_TYPE;   

//#define KEYPAD_RIDGE_B_SWITCH
#define KEYPAD_A2KPLUS_SWITCH

/*-------------------------- extern variable declaration-----------------------*/

/*------------------ constants and data type declaration ----------------------*/
/* scancode of MAN_KP_INFO struct*/
#ifdef	KEYPAD_DATANG_EVB_SWITCH
typedef enum  MAN_KBD_SCANCODE_
{
   KP_KEY_LEFT       = 12,
   KP_KEY_UP         = 2,
   KP_KEY_DOWN       = 3,
   KP_KEY_RIGHT      = 13,

   KP_KEY_1         = 21,
   KP_KEY_2         = 22,
   KP_KEY_3         = 23,
   KP_KEY_4         = 31,

   KP_KEY_5       = 32,
   KP_KEY_6       = 33,
   KP_KEY_7       = 41,
   KP_KEY_8       = 42,

   KP_KEY_9       = 43,
   KP_KEY_0       = 30,
   KP_KEY_STAR    = 20,
   KP_KEY_HASH    = 40,

   KP_KEY_SELECT       = 0,
   KP_KEY_BACK         = 10,
   KP_KEY_YES          = 1,
   KP_KEY_NO           = 11,
   KP_KEY_PWR          =88,

   KP_ANY_KEY        = 99,       /* Eg. Wait for any key pressed */
   KP_NO_KEY         = 100       /* Eg. No key is pressed */
}MAN_KBD_SCANCODE;

#elif defined(KEYPAD_RIDGE_B_SWITCH)
typedef enum  MAN_KBD_SCANCODE_
{
   KP_KEY_SELECT       = 40,
   KP_KEY_BACK         = 41,

   KP_KEY_UP         = 1,
   KP_KEY_DOWN       = 2,
   KP_KEY_LEFT       = 0,
   KP_KEY_RIGHT      = 3,

   KP_KEY_YES          = 42,
   KP_KEY_NO           = 88,
/*   KP_KEY_PWR          =88,   */

   KP_KEY_1         = 30,
   KP_KEY_2         = 31,
   KP_KEY_3         = 32,

   KP_KEY_4         = 33,
   KP_KEY_5         = 20,
   KP_KEY_6         = 21,

   KP_KEY_7       = 22,
   KP_KEY_8       = 23,
   KP_KEY_9       = 10,

   KP_KEY_0       = 11,
   KP_KEY_STAR    = 12,
   KP_KEY_HASH    = 13,


   KP_ANY_KEY        = 99,       /* Eg. Wait for any key pressed */
   KP_NO_KEY         = 100       /* Eg. No key is pressed */
}MAN_KBD_SCANCODE;

#elif defined(KEYPAD_THIRD_PARTY_SWITCH)

typedef enum  MAN_KBD_SCANCODE_
{
   KP_KEY_LEFT     = 12,
   KP_KEY_DOWN     = 22,
   KP_KEY_UP       = 23,
   KP_KEY_RIGHT    = 32,
   KP_KEY_1        = 2,
   KP_KEY_2        = 1,
   KP_KEY_3        = 0,
   KP_KEY_4        = 10,

   KP_KEY_5       = 20,
   KP_KEY_6       = 30,
   KP_KEY_7       = 40,
   KP_KEY_8       = 41,

   KP_KEY_9       = 42,
   KP_KEY_0       = 21,
   KP_KEY_STAR    = 11,
   KP_KEY_HASH    = 31,

   KP_KEY_SELECT  = 13,
   KP_KEY_BACK    = 33,
   KP_KEY_YES     = 3,
   KP_KEY_NO      = 88,
/*   KP_KEY_PWR          ,  */

   KP_ANY_KEY        = 99,       /* Eg. Wait for any key pressed */
   KP_NO_KEY         = 100       /* Eg. No key is pressed */
}MAN_KBD_SCANCODE;

#elif defined(KEYPAD_A2KPLUS_SWITCH)
typedef enum  MAN_KBD_SCANCODE_
{
   #if  0
   KP_KEY_SELECT       = 40,
   KP_KEY_BACK         = 41,
   KP_KEY_SK4	       = 44,	//new

   KP_KEY_UP         = 1,
   KP_KEY_DOWN       = 2,
   KP_KEY_LEFT       = 0,
   KP_KEY_RIGHT      = 3,
   KP_KEY_PTT	     = 4,	//new

   KP_KEY_YES          = 42,	//OK
   KP_KEY_SEND        = 43,	//new
   KP_KEY_NO		= 88,
   /*KP_KEY_PWR         = 88,*/

   KP_KEY_1         = 30,
   KP_KEY_2         = 31,
   KP_KEY_3         = 32,

   KP_KEY_4         = 33,
   KP_KEY_SK3	    = 34,	//new
   KP_KEY_5         = 20,
   KP_KEY_6         = 21,

   KP_KEY_7       = 22,
   KP_KEY_8       = 23,
   KP_KEY_SK2	  = 24,		//new
   KP_KEY_9       = 10,

   KP_KEY_0       = 11,
   KP_KEY_STAR    = 12,
   KP_KEY_HASH    = 13,
   KP_KEY_SK1	  = 14,		//new
   #endif
  #if	(defined (ZTE_P956A1_GPIO_CONFIG))
   KP_KEY_SELECT       = 11,
   KP_KEY_BACK         = 42,
   KP_KEY_CLEAR	       = 31,

   KP_KEY_UP         = 24,
   KP_KEY_DOWN       = 13,
   KP_KEY_LEFT       = 12,
   KP_KEY_RIGHT      = 44,


   KP_KEY_YES          = 30,	//OK
   KP_KEY_SEND        = 0,	//new
   KP_KEY_NO		= 32,
   KP_KEY_PWR         = 88,

   KP_KEY_1         = 2,
   KP_KEY_2         = 14,
   KP_KEY_3         = 32,

   KP_KEY_4         = 3,
   KP_KEY_5         = 20,
   KP_KEY_6         = 34,

   KP_KEY_7       = 4,
   KP_KEY_8       = 21,
   KP_KEY_9       = 41,

   KP_KEY_STAR       = 10,
   KP_KEY_0       = 22,
   KP_KEY_HASH       = 40,

  /***/
   //KP_KEY_SK1	  = 23,   //poc
   KP_KEY_SK1	  = 80,   //poc   
   KP_KEY_SK2	  = 33,  //add
   //KP_KEY_SK3	  = 43,  //dec
   KP_KEY_SK3	  = 23,  //dec   
   KP_KEY_CAMERA = 43,
   KP_ANY_KEY        = 99,       /* Eg. Wait for any key pressed */
   #elif (defined (ZTE_PRJ_P950A1))
   KP_KEY_SELECT       = 42,
   KP_KEY_BACK         = 41,
   KP_KEY_CLEAR	       = 30,

   KP_KEY_UP         = 34,
   KP_KEY_DOWN       = 24,
   KP_KEY_LEFT       = 4,
   KP_KEY_RIGHT      = 44,


   KP_KEY_YES          = 14,    //OK
   KP_KEY_SEND        = 40, //new
   KP_KEY_NO            = 32,
   KP_KEY_PWR         = 88,

   KP_KEY_1         = 0,
   KP_KEY_2         = 10,
   KP_KEY_3         = 20,

   KP_KEY_4         = 01,
   KP_KEY_5         = 11,
   KP_KEY_6         = 21,

   KP_KEY_7       = 3,//   2,
   KP_KEY_8       = 13,//12,
   KP_KEY_9       = 31,//22,

   KP_KEY_STAR       = 2,// 3,
   KP_KEY_0       = 12,//13,
   KP_KEY_HASH       = 22,//31,

   KP_KEY_SK1 = 23,
   KP_KEY_SK2 = 33,
   KP_KEY_SK3 = 43,
   KP_ANY_KEY        = 99,       /* Eg. Wait for any key pressed */
  #endif
   KP_NO_KEY         = 100       /* Eg. No key is pressed */

}MAN_KBD_SCANCODE;
#endif
/* the keypad info */
typedef struct  _MAN_KP_INFO_
{
    ZUINT8  scancode;/* keypad scan code*/
    ZUINT8  status;/*key status1pressed; 0released */
    ZUINT32  times;/* the time as key pressed, unit100ms*/
}MAN_KP_INFO;

typedef struct  _MAN_TS_INFO_
{
    ZUINT16 xpos;       /* ts x value */
    ZUINT16 ypos;       /* ts x value */
    ZUINT8  status;     /* key status :1,LbuttonDown; 2,LbuttonUp;3,MouseMove; 4,LbuttonDbClick*/
    ZUINT32  times;      /* the time as key pressed, unit100ms */
    ZUINT16 rXVaule;        /* rx*/
    ZUINT16 rYVaule;        /* ry*/
}MAN_TS_INFO;
/*--------------------------- variable declaration ----------------------------*/

/*------------------------------ function prototype ---------------------------*/
ZSINT32 tp_man_kp_init(ZVOID);
ZSINT32 tp_man_kp_release(ZVOID);
ZSINT32 tp_man_kp_get_data(MAN_KP_INFO *kp_ptr);
ZSINT32  tp_man_ts_get_data(MAN_TS_INFO *ts_ptr);

ZSINT32 tp_man_wait_input(ZUINT32  timeout);

#endif /*KEYPAD_H*/

