#ifndef _LCD_E_H
#define _LCD_E_H

#include "zcore_type.h"
#include "plat_type_g.h"

typedef enum _MAN_PIXEL_FORMAT_
{
	    PIX_FMT_RGB565 = 1,      /* RGB565 color format for 16 bpp */
		PIX_FMT_RGB332 ,         /* RGB332 color format for 8 bpp*/
		PIX_FMT_RGB666 ,         /* RGB666 color format for 18 bpp, 260k colors*/
		PIX_FMT_RGB555,          /* always stored in cpu endianness, most significant bit to 1 */
		PIX_FMT_YUV420P,         /* Planar YUV 4:2:0 (1 Cr & Cb sample per 2x2 Y samples)*/
		PIX_FMT_YUV422,    
		PIX_FMT_RGB24,           /* Packed pixel, 3 bytes per pixel, RGBRGB...*/
		PIX_FMT_BGR24,           /*  Packed pixel, 3 bytes per pixel, BGRBGR...*/
		PIX_FMT_YUV422P,         /*  Planar YUV 4:2:2 (1 Cr & Cb sample per 2x1 Y samples)*/
		PIX_FMT_YUV444P,         /*  Planar YUV 4:4:4 (1 Cr & Cb sample per 1x1 Y samples)*/
		PIX_FMT_RGBA32,          /*  Packed pixel, 4 bytes per pixel, BGRABGRA..., stored in cpu endianness*/
		PIX_FMT_YUV410P,         /*  Planar YUV 4:1:0 (1 Cr & Cb sample per 4x4 Y samples)*/
		PIX_FMT_YUV411P,         /*  Planar YUV 4:1:1 (1 Cr & Cb sample per 4x1 Y samples)*/
		PIX_FMT_GRAY8,
		PIX_FMT_MONOWHITE,       /*  0 is white */
		PIX_FMT_MONOBLACK,       /*  0 is black */
		PIX_FMT_PAL8,            /*  8 bit with RGBA palette */
		PIX_FMT_YUVJ420P,        /*  Planar YUV 4:2:0 full scale (jpeg)*/
		PIX_FMT_YUVJ422P,        /*  Planar YUV 4:2:2 full scale (jpeg)*/
		PIX_FMT_YUVJ444P,        /*  Planar YUV 4:4:4 full scale (jpeg)*/
		PIX_FMT_XVMC_MPEG2_MC,   /*  XVideo Motion Acceleration via common packet passing*/
		PIX_FMT_XVMC_MPEG2_IDCT,
		PIX_FMT_NB              /*  the undefined pixel format*/
} MAN_PIXEL_FORMAT;

typedef struct _MAN_LCD_SCREEN_
{
	ZUINT16              width;      /*LCD width*/
	ZUINT16              height;     /*LCD height*/
	MAN_PIXEL_FORMAT    type;       /*LCD pixel format*/
	ZUINT16              bpp;        /*LCD color depth(bits/pixel) */
	ZUINT16              rlen;       /*LCD Length of one raster line in bytes*/
	ZCHAR                *fb_ptr;    /*LCD frame buffer ptr*/
}MAN_LCD_SCREEN;


typedef struct  _MAN_LCD_REFRESH_
{    
	ZUINT16	    startX;
	ZUINT16	    startY;
	ZUINT16	    width;
	ZUINT16	    height;
}MAN_LCD_REFRESH;

/*
****  tp_man_lcd_init()
* 0:  init success
* -1: init fail
*/
SINT32 zte_tp_man_lcd_init(ZVOID);

/*
*  tp_man_lcd_get_info()
*  0: success
*  -1: fail
*/
SINT32 zte_tp_man_lcd_get_info(MAN_LCD_SCREEN* ptScreenInfo);

/*  tp_man_lcd_refresh():
 *If the function succeeds, the return value is 0.
  If the function fails, the return value is -1.
*/
SINT32 zte_tp_man_lcd_refresh(MAN_LCD_REFRESH *area_ptr);

#endif
