#ifndef _Z_LAYER_TYPE_H
#define _Z_LAYER_TYPE_H

#ifdef __cplusplus
extern "C" {
#endif

/* Ԥͼflagʶ */
#define LAYER_FLAG_COLORKEY  0x0001
#define LAYER_FLAG_OPACITY   0x0002
#define LAYER_FLAG_MASK      0x0004
#define LAYER_FLAG_CLIPRECT  0x0008
#define LAYER_FLAG_DOUBLEBUF 0x0010

/* 
 * ͼظʽ:
 * LPF = Layer Pixel Format 
*/
typedef enum
{
    LPF_UNKNOWN  = 0x00000000,  // unknown format
    LPF_RGB15    = 0x00020F01,  // 15bit RGB (2 bytes, red 5@10, green 5@5, blue 5@0)
    LPF_RGB16    = 0x00021002,  // 16bit RGB (2 bytes, red 5@11, green 6@5, blue 5@0)
    LPF_RGB18    = 0x00031203,  // 18bit RGB (3 bytes, red 6@12, green 6@6, blue 6@0)
    LPF_RGB24    = 0x00031804,  // 24bit RGB (3 bytes, red 8@16, green 8@8, blue 8@0)
    LPF_RGB32    = 0x00041805,  // 24bit RGB (4 bytes, nothing@24,red 8@16, green 8@8, blue 8@0)
    LPF_ARGB     = 0x00042006,  // 32bit ARGB(4 bytes, alpha 8@24,red 8@16, green 8@8, blue 8@0)
    LPF_A8       = 0x00010807,  // 8bit  Alpha(1 byte, alpha 8@0 )
    LPF_YUY2     = 0x00021008,  // YUV   Format
    LPF_RGB4     = 0x00010409,  // 4Bits Format
}LAYERPIXELFORMAT;

/* ڴ LAYERPIXELFORMAT ȡϢ궨 */
#define BYTES_OF_LAYER(format)    (((format) & 0xFF0000) >> 16)
#define BITS_OF_LAYER(format)     (((format) & 0x00FF00) >>  8)
#define PIXELFORMAT_INDEX(format) (((format) & 0x0000FF) - 1)

typedef struct _LAYERINFO
{
    ZUINT32 ID;            //ͼID
    ZUINT32 pixType;       //ͼظʽ
    ZSINT32 offsetX;       //ͼ X ƫ
    ZSINT32 offsetY;       //ͼ Y ƫ
    ZUINT32 width;         //ͼ
    ZUINT32 height;        //ͼ߶
    ZUINT32 bitsPerPixel;  //ͼÿռõı
    ZUINT32 bytesPerPixel; //ͼÿռõֽ
    ZUINT32 colorkey;      //ͼ͸ɫ(ؼɫ)
    ZUINT32 opacity;       //ͼ͸(ȫ͸ֵ)
    ZCHAR*  pMask;         //ͼģ(͸ȱ)
    ZUINT32 rotation;      //ͼתǶ
    ZCHAR*  pFrontBuf;     //ͼǰַ
    ZCHAR*  pBackBuf;      //ͼ󻺴ַ
    ZUINT32 uPitch;        //ͼ㻺ÿռõֽ
    RECT    clipRect;      //ͼü

    ZUINT32 isUsed;        //ͼǷʹ
    ZUINT32 enabled;       //ͼǷʹ
    ZUINT32 flag;          //ͼڲ˽бʶ
}LAYERINFO;


typedef struct _LAYERUPDATEINFO
{
    ZBOOL bUpdate;
    LAYERINFO* pLayer;
}LAYERUPDATEINFO;

/* ͼʼָ붨 */
typedef struct _LayerAdapter LAYERADAPTER;
typedef ZSINT32 (*INIT_LAYER_ADAPTER)(LAYERADAPTER* pAdapter);

typedef struct _LCDINFO
{
    ZUINT32 isInit;        //LCDʼʶ
    ZUINT32 flag;          //LCDڲ˽бʶ
    ZUINT32 pixType;       //LCDظʽ
    ZUINT32 width;         //LCD
    ZUINT32 height;        //LCD߶
    ZUINT32 bitsPerPixel;  //LCDÿռñ
    ZUINT32 bytesPerPixel; //LCDÿռֽ
    ZUINT32 uPitch;        //LCDÿռõֽ
    ZCHAR*  pLcdMem;       //LCDԴַ

    ZUINT32 isHWLayer;     //Ƿ֧Ӳͼ
    ZUINT32 layerNums;     //ֵ֧ͼ
    ZUINT32 multiLayerEnabled;//Ƿ򿪶ͼ㹦
    ZUINT32 layerPixelType;//ͼʹõظʽ
    INIT_LAYER_ADAPTER init_adapter_ptr;//ͼʼӿ
}LCDINFO;

struct _LayerAdapter
{
    ZSINT32 (*Drv_GetLCDInfo)(LCDINFO* lcdInfo);
    ZSINT32 (*Drv_GetLayerInfo)(HLAYER hLayer, LAYERINFO* layerInfo, ZUINT32 attr);
    ZSINT32 (*Drv_SetLayerInfo)(HLAYER hLayer, LAYERINFO* layerInfo, ZUINT32 attr);

    ZSINT32 (*Drv_BlendLayers)(HLAYER *hLayer, ZSINT32 layerSize, RECT *rct);
    ZSINT32 (*Drv_BlendLayersToBuf)(HLAYER *hLayer, ZSINT32 layerSize, LAYERBLENDINFO *dst);
};

#ifdef __cplusplus
}
#endif

#endif /* End of  #define _Z_LAYER_TYPE_H */
