#ifndef _ZCORE_ADAPTOR_MEM_H_
#define _ZCORE_ADAPTOR_MEM_H_

#include "zcore_type.h"
#include "os_type.h"
#include "GuiTool_mem.h" 
#include"gui_common.h"

/**************************************************************************
* ƣzcore_mem_malloc
* ڴӿ
**************************************************************************/
ZVOID* zcore_mem_malloc(zuint32 bytes);
/**************************************************************************
* ƣzcore_mem_free
* ڴͷӿ
**************************************************************************/
ZVOID zcore_mem_free(ZVOID *mem);
 /**************************************************************************
* ƣzcore_mem_cpy
* ڴ濽ӿ
**************************************************************************/         
ZVOID zcore_mem_cpy(ZVOID *dest_ptr, ZVOID *src_ptr,zuint32 copy_len); 
/**************************************************************************
* ƣzcore_mem_set
* ڴ渳ֵӿ
**************************************************************************/		 
ZVOID zcore_mem_set(ZVOID *dest_ptr, ZUINT8 value,zuint32 len);
/**************************************************************************
* ƣzcore_mem_calloc
* ڴ䲢ʼӿ
**************************************************************************/
ZVOID *zcore_mem_calloc(zuint32 nelem,zuint32 elsize);
/**************************************************************************
* ƣzcore_mem_realloc
* ڴ·ӿ
**************************************************************************/
ZVOID *zcore_mem_realloc(ZVOID *pMem, zuint32 new_size);
/**************************************************************************
* ƣzcore_mem_strdup
* ַӿ
**************************************************************************/
ZCHAR *zcore_mem_strdup(const ZCHAR *string);


/** 
 * ·װZcoreصڴӿ 
 **/ 
#if __GUI_DEBUG__== 0

  #define GUI_MALLOC(bytes)\
          zcore_mem_malloc((zuint32)bytes)

  #define GUI_FREE(mem)\
          zcore_mem_free(mem)                          
          
  #define GUI_MEM_CPY(dest_ptr,src_ptr,copy_len)\
          zcore_mem_cpy((ZVOID *)dest_ptr,(ZVOID *)src_ptr,(zuint32)copy_len) 

  #define GUI_MEM_SET(dest_ptr,value,len)\
          zcore_mem_set((ZVOID *)dest_ptr,(ZUINT8)value,(zuint32)len)

  #define GUI_CALLOC(count,bytes)\
          zcore_mem_calloc((zuint32)count,(zuint32)bytes)

  #define GUI_REALLOC(mem,bytes)\
          zcore_mem_realloc((ZVOID *)mem,(zuint32)bytes)

#endif


/** 
 * Ժ
 **/ 
#ifdef _ZCORE_DEBUG_
#define ZCORE_ASSERT(condition) do {\
                                     if(!(condition)){\
                                        while(1);\
                                     }\
                                   } while(0); 
#else
#define ZCORE_ASSERT(condition) {}

#endif
#endif

