#ifndef BMP_MODULE_H
#define BMP_MODULE_H

#include "zcore_type.h"
#include "imgmgt_e.h"
#include "zcore_mem.h"
#include "zcore_fileop.h"
/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#ifndef INT_MAX
#define INT_MAX 65536
#endif

#define JCONFIG_INCLUDED

#ifdef HAVE_BOOLEAN
#undef HAVE_BOOLEAN
#endif

#ifndef HAVE_UNSIGNED_CHAR
#define HAVE_UNSIGNED_CHAR
#endif

#ifndef HAVE_UNSIGNED_SHORT
#define HAVE_UNSIGNED_SHORT
#endif

/* rgb888 to rgb565 */
#define RGB565MASK_R  0xf800
#define RGB565MASK_G  0x07e0
#define RGB565MASK_B  0x001f
/* ˴Ҫݾƽ̨Ӧ޸ */
#define PIC_FILE_Open      zcore_fopen
#define PIC_FILE_Close     zcore_fclose
#define PIC_FILE_Read      zcore_fread
#define PIC_FILE_Length    zcore_flength
#define PIC_FILE_Seek      zcore_fseek

extern ZSINT32 GUI_PIXEL_BYTES;

static __inline ZVOID guiRGB2PX_X(ZUINT8* p,ZSINT32 offset,ZUINT8 r,ZUINT8 g,ZUINT8 b)
{
    switch(GUI_PIXEL_BYTES)
    {
    case 2:
        {
            ((ZUINT16*)(p))[offset] = (((ZUINT16)(r) << 8) & RGB565MASK_R)|
                                             (((ZUINT16)(g) << 3) & RGB565MASK_G)|
                                             (((ZUINT16)(b) >> 3) & RGB565MASK_B);
        }
        return;
        
    case 3:
    case 4:
        {
            p[offset*GUI_PIXEL_BYTES]   = b;
            p[offset*GUI_PIXEL_BYTES + 1] = g;
            p[offset*GUI_PIXEL_BYTES + 2] = r;
        }
        return;
        
    default:
        return;
    }
}
static __inline ZVOID guiRGB2PX(ZUINT8* p,ZUINT8 r,ZUINT8 g,ZUINT8 b)
{
    switch(GUI_PIXEL_BYTES)
    {
    case 2:
        {
            *(ZUINT16*)(p) = (((ZUINT16)(r) << 8) & RGB565MASK_R)|
                                    (((ZUINT16)(g) << 3) & RGB565MASK_G)|
                                    (((ZUINT16)(b) >> 3) & RGB565MASK_B);
        }
        return;
        
    case 3:
    case 4:
        {
            *p++ = b;
            *p++ = g;
            *p++ = r;
        }
        return;
        
    default:
        return;
    }
}


/**************************************************************************
 *                                                                *
 **************************************************************************/
typedef struct
{
    /* in */
    ZULONG   uiWidth;
    ZULONG   uiHeight;
    ZULONG   uiMaxWidth;
    ZULONG   uiMaxHeight;

    /* out */
    ZULONG   uiNewWidth;
    ZULONG   uiNewHeight;
    ZDOUBLE          dStepX;
    ZDOUBLE          dStepY;
} T_ImageSizeInfo;


typedef struct
{
    ZUINT8  *pMem;
    ZSINT32             iSize;
    ZSINT32             iCur;
} T_MemHandle;

ZVOID* guiLoadImageMalloc(size_t size);
ZVOID guiLoadImageFree(ZVOID *p);

ZSINT32  guiIsKeyX(T_LoadImageParam *pInfo, ZSINT32 *px, ZSINT32 *pCoords);
ZSINT32  guiIsKeyY(T_LoadImageParam *pInfo, ZSINT32 *py, ZSINT32 *pCoords);
ZSINT32* guiInitCoords(T_ImageSizeInfo *pInfo, ZSINT32 bWithX);

FILE* guiImageOpenFile(const ZCHAR *szFile, T_LoadImageParam *pInfo);
ZVOID  guiImageCloseFile(FILE *fp, T_LoadImageParam *pInfo);
ZSINT32   guiLoadImage(const ZCHAR *szFile, T_LoadImageParam *pInfo);
ZSINT32   guiCalculateSize(T_ImageSizeInfo *pInfo);

#endif/* BMP_MODULE_H */
