#ifndef _GIF_H
#define _GIF_H

/**************************************************************************
*                        ͷļ                                      *
**************************************************************************/
#include "zcore_type.h"
#include "imgmgt_e.h"
#include "animation.h"
/**************************************************************************
*                                                                    *
**************************************************************************/

/**************************************************************************
*                         궨                                         *
**************************************************************************/

#define MAXCOLORMAPSIZE                 256
#define MAX_LWZ_BITS                    12
#define INTERLACE                       0x40
#define LOCALCOLORMAP                   0x80

#define CM_RED                          0
#define CM_GREEN                        1
#define CM_BLUE                         2

#define TYPE_FILE                       0xFE
#define TYPE_MEM                        0xFF

#define BitSet(byte, bit)              (((byte) & (bit)) == (bit))
#define NewReadOk(src,buffer,len)      (src)->getDataFun(src, buffer, len, 1)
#define LM_to_uint(a,b)                (((b)<<8)|(a))

#define GIF_TERMIN_FLAG                ';'
#define GIF_EXTEND_FLAG                '!'
#define GIF_FRAMSTART_FLAG             ','
#define GIF_87_FLAG                    "GIF87a"
#define GIF_89_FLAG                    "GIF89a"

#define GIF_TEXT_EXTFLAG               0x01           
#define GIF_COMM_EXTFLAG               0xfe
#define GIF_GRAPH_EXTFLAG              0xf9
#define GIF_APP_EXTFLAG                0xff

#ifdef _DEBUG_MODE
#define GUI_ASSERT(i)                  while((i) == 0)
#else
#define GUI_ASSERT(i)
#endif

/**************************************************************************
*                         Ͷ                                    *
**************************************************************************/
typedef struct 
{
    ZSINT32 transparent;
    ZSINT32 delayTime;
    ZSINT32 inputFlag;
    ZSINT32 disposal;
} Gif89Info;

 typedef struct 
{
    ZUINT32 Width;
    ZUINT32 Height;
    ZCHAR GlobalColorMap[3][MAXCOLORMAPSIZE];
    ZUINT32 BitPixel;
    ZUINT32 ColorResolution;
    ZUINT32 Background;
    ZUINT32 AspectRatio;
    ZSINT32 GrayScale;
} 
gifScreenInfo;


typedef struct _GifFrameScreenInfo
{
    ZSINT32 xoffset;
    ZSINT32 yoffset;
    ZSINT32 frameWidth;
    ZSINT32 frameHeight;
    ZSINT32 interlace;
    ZCHAR localColorMap[3][MAXCOLORMAPSIZE];
    ZSINT32 localcolorMapsize;
    ZBOOL hasFrameMap;
    Gif89Info gif89;
}
GifFrameScreenInfo;

typedef struct _GifContext
{
    gifScreenInfo screenInfo;
    ZUINT32 frames;

    GifFrameScreenInfo GifFrameScreen;

    ZSINT32 lzw_fresh;
    ZSINT32 lzw_code_size;
    ZUINT8  lzw_set_code_size;
    ZSINT32 lzw_max_code;
    ZSINT32 lzw_max_code_size;
    ZSINT32 lzw_firstcode;
    ZSINT32 lzw_oldcode;
    ZSINT32 lzw_clear_code;
    ZSINT32 lzw_end_code;
    ZSINT32 *lzw_sp;

    ZUINT8 buf[280];
    ZSINT32 code_curbit;
    ZSINT32 code_lastbit;
    ZSINT32 code_done;
    ZSINT32 code_last_byte;

    ZSINT32 lzw_table[2][(1 << MAX_LWZ_BITS)];
    ZSINT32 lzw_stack[(1 << (MAX_LWZ_BITS)) * 2 + 1];
	T_IMGMGT_LoadPicBitInfoParam picinfo;
}GifContext;

typedef	FILE*  (* FILEOPEN)(const ZCHAR * filehandle, const ZCHAR * rdmode);
typedef size_t (*FILEREAD) (ZVOID *buffer1, size_t size, size_t count1, ZVOID *stream);
typedef ZSINT32    (*FILESEEK) (FILE *stream,ZLONG foffset,ZSINT32 whence);
typedef ZSINT32    (*FILECLOSE)(FILE* fp);
typedef struct _T_Gif_OsParam 
{
    ZSINT32 type ;
    ZSINT32 (*getDataFun)(struct _T_Gif_OsParam * pGifOp, ZUINT8 * buf, ZSINT32 len, ZSINT32 size);
    ZCHAR * pMemEndAddr;
    
    union

    {
        ZCHAR ** pMem;
        FILE * fileptr;

    } dataOp;
}
T_Gif_OsParam;

/**************************************************************************
 *                        ԭ                                     *
 **************************************************************************/
extern ZVOID Gif_Destroy(ANIMATION* anim);
#endif

