/***************************************************************************/
/*                                                                         */
/*  ftstdlib.h                                                             */
/*                                                                         */
/*    ANSI-specific library and header configuration file (specification   */
/*    only).                                                               */
/*                                                                         */
/*  Copyright 2002, 2003, 2004, 2005, 2006, 2007, 2009 by                  */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/


/*************************************************************************/
/*                                                                       */
/* This file is used to group all #includes to the ANSI C library that   */
/* FreeType normally requires.  It also defines macros to rename the     */
/* standard functions within the FreeType source code.                   */
/*                                                                       */
/* Load a file which defines __FTSTDLIB_H__ before this one to override  */
/* it.                                                                   */
/*                                                                       */
/*************************************************************************/


#ifndef __FTSTDLIB_H__
#define __FTSTDLIB_H__


#include <stddef.h>

#define ft_ptrdiff_t  ptrdiff_t


/**********************************************************************/
/*                                                                    */
/*                           integer limits                           */
/*                                                                    */
/* UINT_MAX and ULONG_MAX are used to automatically compute the size  */
/* of `int' and `long' in bytes at compile-time.  So far, this works  */
/* for all platforms the library has been tested on.                  */
/*                                                                    */
/* Note that on the extremely rare platforms that do not provide      */
/* integer types that are _exactly_ 16 and 32 bits wide (e.g. some    */
/* old Crays where `int' is 36 bits), we do not make any guarantee    */
/* about the correct behaviour of FT2 with all fonts.                 */
/*                                                                    */
/* In these case, `ftconfig.h' will refuse to compile anyway with a   */
/* message like `couldn't find 32-bit type' or something similar.     */
/*                                                                    */
/**********************************************************************/


#include <limits.h>

#define FT_CHAR_BIT   CHAR_BIT
#define FT_INT_MAX    INT_MAX
#define FT_INT_MIN    INT_MIN
#define FT_UINT_MAX   UINT_MAX
#define FT_ULONG_MAX  ULONG_MAX


/**********************************************************************/
/*                                                                    */
/*                 character and string processing                    */
/*                                                                    */
/**********************************************************************/


#include <string.h>

#define ft_memchr   memchr
#define ft_memcmp   memcmp
#define ft_memcpy   memcpy
#define ft_memmove  memmove
#define ft_memset   memset
#define ft_strcat   strcat
#define ft_strcmp   strcmp
#define ft_strcpy   strcpy
#define ft_strlen   strlen
#define ft_strncmp  strncmp
#define ft_strncpy  strncpy
#define ft_strrchr  strrchr
#define ft_strstr   strstr


/**********************************************************************/
/*                                                                    */
/*                           file handling                            */
/*                                                                    */
/**********************************************************************/


#include <stdio.h>

#if (defined(ET_spreadtrum_sc6600) || defined(ET_spreadtrum_sc6600_nostack) || \
     defined(ET_spreadtrum_sc6600_rvct) || defined(ET_spreadtrum_sc6800) || \
     defined(ET_spreadtrum_sc6530_rvct) || defined(ET_spreadtrum_sc8800_rvct) || \
     defined(ET_spreadtrum_sc8800) || defined(ET_spreadtrum_sc8800_nostack) || \
     defined(ET_mtk_rvct31_arm79) || defined(ET_mtk_rvct31_arm11) || \
     defined(ET_leadcore_ads12) || defined(ET_cvte_aeon) )
#define FT_FILE             void
#define ft_fclose(a)
#define ft_fopen(a,b)       0
#define ft_fread(a,b,c,d)   0
#define ft_fseek(a,b,c)
#define ft_ftell(a)         0
#define ft_sprintf(a,b,c)
#else
#define FT_FILE     FILE
#define ft_fclose   fclose
#define ft_fopen    fopen
#define ft_fread    fread
#define ft_fseek    fseek
#define ft_ftell    ftell
#define ft_sprintf  sprintf
#endif

/**********************************************************************/
/*                                                                    */
/*                             sorting                                */
/*                                                                    */
/**********************************************************************/


#include <stdlib.h>

#define ft_qsort  qsort


/**********************************************************************/
/*                                                                    */
/*                        memory allocation                           */
/*                                                                    */
/**********************************************************************/

#define ft_scalloc   calloc
#define ft_sfree     free
#define ft_smalloc   malloc
#define ft_srealloc  realloc


/**********************************************************************/
/*                                                                    */
/*                          miscellaneous                             */
/*                                                                    */
/**********************************************************************/


#define ft_atol   atol
#define ft_labs   labs


/**********************************************************************/
/*                                                                    */
/*                         execution control                          */
/*                                                                    */
/**********************************************************************/


#include <setjmp.h>

#define ft_jmp_buf     jmp_buf  /* note: this cannot be a typedef since */
/*       jmp_buf is defined as a macro  */
/*       on certain platforms           */

#if (defined(ET_spreadtrum_sc6600) || defined(ET_spreadtrum_sc6600_nostack) || \
	defined(ET_spreadtrum_sc6600_rvct) || defined(ET_spreadtrum_sc6800) || \
	defined(ET_spreadtrum_sc6530_rvct) || defined(ET_spreadtrum_sc8800_rvct) || \
	defined(ET_spreadtrum_sc8800) || defined(ET_spreadtrum_sc8800_nostack))
#define ft_longjmp( a, b )
#define ft_setjmp( b )     0
#else
#define ft_longjmp     longjmp
#define ft_setjmp( b ) setjmp( *(jmp_buf*) &(b) )    /* same thing here */
#endif


/* the following is only used for debugging purposes, i.e., if */
/* FT_DEBUG_LEVEL_ERROR or FT_DEBUG_LEVEL_TRACE are defined    */

#include <stdarg.h>


#endif /* __FTSTDLIB_H__ */


/* END */
