#ifndef IMGMGT_IH
#define IMGMGT_IH

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zcore_type.h"
#include "imgmgt_e.h"


/***********************************************************************
*                        ݽṹ
************************************************************************/
typedef struct tagRGBTRIPLE
{
    ZBYTE    rgbtBlue;
    ZBYTE    rgbtGreen;
    ZBYTE    rgbtRed;
} RGBTRIPLE;
typedef RGBTRIPLE* PRGBTRIPLE;


#define SIZEOF_RGBQUAD  4

#define SIZEOF_BMFH     14
#define SIZEOF_BMIH     40

#define OS2INFOHEADERSIZE  12
#define WININFOHEADERSIZE  40

#define BI_RGB          0
#define BI_RLE8         1
#define BI_RLE4         2
#define BI_BITFIELDS    3

typedef struct BITMAPFILEHEADER
{
    ZUINT16 bfType;
    ZULONG  bfSize;
    ZUINT16 bfReserved1;
    ZUINT16 bfReserved2;
    ZULONG  bfOffBits;
} BITMAPFILEHEADER;

typedef struct BITMAPINFOHEADER
{
    ZULONG  biWidth;
    ZULONG  biHeight;
    ZUINT16 biBitCount;
    ZULONG  biCompression;
} BITMAPINFOHEADER;

typedef struct tagRGBQUAD
{
    ZBYTE    rgbBlue;
    ZBYTE    rgbGreen;
    ZBYTE    rgbRed;
    ZBYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD* PRGBQUAD;


typedef struct WINBMPINFOHEADER  /* size: 40 */
{
    ZULONG  biSize;
    ZULONG  biWidth;
    ZULONG  biHeight;
    ZUINT16 biPlanes;
    ZUINT16 biBitCount;
    ZULONG  biCompression;
    ZULONG  biSizeImage;
    ZULONG  biXPelsPerMeter;
    ZULONG  biYPelsPerMeter;
    ZULONG  biClrUsed;
    ZULONG  biClrImportant;
} WINBMPINFOHEADER;


typedef struct OS2BMPINFOHEADER  /* size: 12 */
{
    ZULONG  biSize;
    ZUINT16 biWidth;
    ZUINT16 biHeight;
    ZUINT16 biPlanes;
    ZUINT16 biBitCount;
} OS2BMPINFOHEADER;

typedef struct _rgba
{
    /*
    * the red component of a RGBA quarter.
    */
    ZBYTE r;
    /*
    * the green component of a RGBA quarter.
    */
    ZBYTE g;
    /*
    * the blue component of a RGBA quarter.
    */
    ZBYTE b;
    /*
    * the alpha component of a RGBA quarter.
    */
    ZBYTE a;
} RGBA;


/***********************************************************************
*                     ȫֺ
***********************************************************************/
ZBOOL  txtmgtScaleBitmap(PBITMAP pbDstBitmap, const PBITMAP pbSrcBitmap);

ZVOID  imgmgtExpandMonoBitmap(HDC hdc, ZSINT32 w, ZSINT32 h, const ZPUINT8 pbMyBits,ZSINT32 iMyiPitch, ZSINT32 iBitsFlow,
                             ZPUINT8 pbBitmap, ZSINT32 iPitch, ZSINT32 iBackGround, ZSINT32 iForeGround);

ZVOID  imgmgtExpand16CBitmap (HDC hdc, ZSINT32 w, ZSINT32 h, const ZPUINT8 pbMybits, ZSINT32 iMyPitch, 
                             ZSINT32 iBitsFlow,ZPUINT8 pbBitmap, ZSINT32 iPitch, const PRGB ptPalette);

ZVOID  imgmgtExpand256CBitmap(HDC hdc, ZSINT32 w, ZSINT32 h, const ZPUINT8 pbMybits, ZSINT32 iMyPitch, 
                             ZSINT32 iBitsFlow,ZPUINT8 pbBitmap, ZSINT32 iPitch, const PRGB ptPalette);

ZVOID  imgmgtCompileRGBBitmap(HDC hdc, ZSINT32 w, ZSINT32 h, const ZPUINT8 pbMybits, ZSINT32 iMyPitch, 
                             ZSINT32 iBitsFlow,ZPUINT8 pbBitmap, ZSINT32 iPitch, ZSINT32 rgb_order);

ZSINT32 GUIAPI LoadBitmapFromPNGMem(BITMAP * pBmp, ZUINT8 * mem, ZSINT32 length);

#endif
