/*******************************************************************************
 * Copyright (C) 2016, ZXIC Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v1.0
 * Author:        zhouqi
 * Date:          2013-8-21
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _FLASH_H_
#define _FLASH_H_

#include <linux/types.h>
#include "pub_flags.h"

#define 	NOR_BOOT		0x0
#define 	NAND_BOOT		0x1
#define 	SPI_NAND_BOOT	0x2
#define 	OTHER_BOOT		0xff

struct flash_type{
	uint8_t flash_type;
    uint8_t manuf_id;             
    uint8_t device_id;            
	uint16_t page_size;
    uint16_t page_size_shift;      
    uint16_t oob_size;                    
    uint16_t block_size_shift;
    uint16_t block_num;          
	uint32_t block_size;
	int32_t	(*read_page_raw)(uint32_t buf, uint32_t offset);
	int32_t	(*read)(uint32_t from, uint32_t len, uint32_t to);
	void (*read_oob)(uint8_t *buf, uint32_t offset, uint32_t len);
};

typedef struct
{
	unsigned int magic_start;  /* Чħ */
	
    T_BOOT_FOTA_FLAG 	boot_fota_flag;
    T_BOOT_ENV 			boot_env;
	T_UBIFS_STATUS		ubifs_status;
	unsigned int        nvro_flag;
	unsigned int		crc32;
	T_BOOT_TARGET		ota_system; /* ʱϵͳAϵͳB */
	T_AA_PARTITION_INFO ota_partiton_info[OTA_PARTITION_NUM_MAX]; /* 15imageС */
	char reserve[52];
	unsigned int magic_end;  /* Чħ */
} T_FLAGS;

extern struct flash_type flash;

char get_boot_mode(void);
int board_flash_init(void);


#endif/*_FLASH_H_*/


