#!/bin/bash

WORKDIR=$PWD
export PATH=$WORKDIR/bin:$PATH

UBI_ARGS="-m 0x1000 -p 0x40000 -s 0x1000 -Q 1024"
MKSQUASHFS_ARGS="-nopad -noappend -root-owned -comp xz -Xpreset 9 -Xe -Xlc 0 -Xlp 2 -Xpb 2  -b 256k -processors 1"
PRIVATE_KEY="$WORKDIR/SignTool/key/RSA_2048/private.k"
if [ $# -lt 5 ]; then
  echo "[error] $0 parameter to less"
  echo "$0 out_name dir_name vol_name selinux_file dm_verity"
  echo "selinux_file: selinux context file"
  echo "dm_verity: 0 for disable dm-verity, 1 for enable dm-verity"
  exit -1
fi
OUT_NAME=$1
DIR_NAME=$2
VOL_NAME=$3
selinux_file=$4
dm_verity=$5

echo "out_name: $OUT_NAME"
echo "dir_name: $DIR_NAME"
echo "vol_name: $VOL_NAME"
echo "ubi_args: $UBI_ARGS"

rm -rf $OUT_NAME  verity   ${VOL_NAME}.out
mkdir -p $DIR_NAME

if [ -f $selinux_file ]; then
  setfiles -m -r $DIR_NAME  $selinux_file $DIR_NAME
  if [ $? -eq 0 ]; then
    echo "selinux set success"
  else
    echo "selinux set fail"
    exit -1
  fi
else
  echo "selinux_file NOT exist and disable selinux"
fi

$WORKDIR/bin/mksquashfs4 $DIR_NAME  ${VOL_NAME}.out ${MKSQUASHFS_ARGS} -p '/dev d 755 0 0' -p '/dev/console c 600 0 0 5 1'
if [ $? -ne 0 ]; then
    echo "mksquashfs error"
    exit -1
fi

if [ "$dm_verity" == "1" ]; then
  ./squashfs_dm-verity.sh  ${VOL_NAME}.out  ./  ${VOL_NAME}.dm  $PRIVATE_KEY $WORKDIR/SignTool/SignImage
  if [ $? -eq 0 ]; then
    echo "dm-verity sucess"
  else
     echo "dm-verity fail"
     exit -1
  fi
  mv ${VOL_NAME}.dm  ${VOL_NAME}.out
else
  echo "disable dm-verity"
fi

./ubinize-static.sh  $VOL_NAME $OUT_NAME ${VOL_NAME}.out  "$UBI_ARGS"
