#!/bin/bash

IN_FILE=$1
WORK_DIR=$2
OUT_FILE=$3
PRIV_KEY=$4
SignImage=$5

VERITY_DIR=$WORK_DIR/verity

rm -rf $VERITY_DIR  $OUT_FILE  $OUT_FILE.pad
mkdir -p  $VERITY_DIR

# 1.pad
let size="$(stat -c%s $IN_FILE)" pad="128*1024" offset="0"  pad="(pad - ((size + offset) % pad)) % pad"  newsize='size + pad'
echo $size $newsize
dd  if=$IN_FILE   of=$OUT_FILE  bs=$newsize count=1  conv=sync
#cp -v $OUT_FILE   $OUT_FILE.pad

# 2. gen raw_table and hash_tree
veritysetup format $OUT_FILE $VERITY_DIR/hash_tree > $VERITY_DIR/raw_table
if [ $? -ne 0 ]; then
	echo "generate squashfs dm-verity veritysetup format error!"
	exit 1
fi

# 3. gen signature of raw_table
#openssl dgst -sha256 -binary -sign $PRIV_KEY $VERITY_DIR/raw_table > $VERITY_DIR/sign
$SignImage -i  $VERITY_DIR/raw_table -o $VERITY_DIR/raw_table.signed  -k $PRIV_KEY
if [ $? -ne 0 ]; then
	echo "generate squashfs dm-verity sign error!"
	exit 1
fi
dd if=$VERITY_DIR/raw_table.signed  of=$VERITY_DIR/sign bs=640 count=1 status=none

# 4. padding sign, raw_table and hash_tree to input file
zxic_generate_squashfs_verity $OUT_FILE $VERITY_DIR/sign $VERITY_DIR/raw_table $VERITY_DIR/hash_tree
if [ $? -ne 0 ]; then
	echo "generate squashfs dm-verity error!"
	exit 1
fi
