#!/bin/bash

if [ x"$PAGESIZE" = x"" ]; then
  PAGESIZE=0x800
fi

if [ x"$ERASEBLOCK" = x"" ]; then
  ERASEBLOCK=0x20000
fi

mkfs.jffs2 --pagesize=$PAGESIZE --eraseblock=$ERASEBLOCK --little-endian --no-cleanmarkers --squash -d $1 -o $2
if [ $? -ne 0 ]; then
  echo "mkfs.jffs2 error"
  exit -1
else
  echo "mkfs.jffs2 ok"
fi

exit 0
