#!/bin/bash

CROSS_DIR=v3t_build_env_mini_vehicle

LIB_SET="libdemo zlib"
APP_SET="appdemo"
PRJ_NAME=prj_vehicle

if [ ! -d build/compiler ]; then
  echo "[ERROR] CAN not found build/compiler and run in directory containing ap and build."
  exit -1
fi

RSYNC_OPT="rsync -aq --delete --exclude=.svn --exclude=.git"

rm -fr $CROSS_DIR
rm -fv $CROSS_DIR.tar.gz
mkdir -p $CROSS_DIR

#
mkdir -p $CROSS_DIR/build/compiler/gcc-4.9.4_thumb_linux_glibc/
mkdir -p $CROSS_DIR/build/utils/
$RSYNC_OPT  ./build/compiler/gcc-4.9.4_thumb_linux_glibc/  $CROSS_DIR/build/compiler/gcc-4.9.4_thumb_linux_glibc/
$RSYNC_OPT  ./build/utils/  $CROSS_DIR/build/utils/

#libc
mkdir -p $CROSS_DIR/ap/staging/
$RSYNC_OPT  ./ap/staging/  $CROSS_DIR/ap/staging/

#ap/build
mkdir -p $CROSS_DIR/ap/build/
$RSYNC_OPT  ./ap2/build/   $CROSS_DIR/ap/build/

#prj
mkdir -p $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME
$RSYNC_OPT  ./ap2/project/zx297520v3/$PRJ_NAME/ $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/
cp -v ./ap2/project/pubconf.mk   $CROSS_DIR/ap/project/
cp -v ./ap2/project/zx297520v3/chip_pubconf.mk  $CROSS_DIR/ap/project/zx297520v3/

#demo lib
mkdir -p $CROSS_DIR/ap/lib/
for item in $LIB_SET;do
  mkdir -p $CROSS_DIR/ap/lib/$item/
  $RSYNC_OPT  ./ap2/lib/$item/ $CROSS_DIR/ap/lib/$item/
done
cp -v ./ap2/lib/Makefile $CROSS_DIR/ap/lib/

#demo app
mkdir -p $CROSS_DIR/ap/app/
for item in $APP_SET;do
  mkdir -p $CROSS_DIR/ap/app/$item/
  $RSYNC_OPT  ./ap2/app/$item/ $CROSS_DIR/ap/app/$item/
done
cp -v ./ap2/app/Makefile $CROSS_DIR/ap/app/
#mkdir -p $CROSS_DIR/ap/app/include/
#$RSYNC_OPT  ./ap/app/include/  $CROSS_DIR/ap/app/include/

rm  -fr $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/*
echo "zte_lib := $LIB_SET" > $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_lib.mk
echo "zte_app := $APP_SET" > $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_app.mk
cp -v $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_lib.mk  $CROSS_DIR/ap/lib/
cp -v $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_app.mk  $CROSS_DIR/ap/app/


cp -v ./ap2/build/scripts/build_env_mini/Makefile  $CROSS_DIR/ap/
cp -v ./ap2/build/scripts/build_env_mini/readme.txt  $CROSS_DIR/

#clean 
rm -fr $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/normal/rootfs/*
mkdir -p $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/normal/rootfs/etc
mkdir -p $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/normal/rootfs/etc_ro
touch $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/normal/rootfs/etc/rc
rm -fr $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/recovery
rm -fr $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/recovery
rm -fr $CROSS_DIR/ap/build/scripts
rm -fr $CROSS_DIR/ap/build/uClibc

echo "compress files to ${CROSS_DIR}.tar.gz"
tar -czf  ${CROSS_DIR}.tar.gz  $CROSS_DIR/
echo "all done"
