@echo off

if "%~1" equ "" (
    echo "Usage: %0 private_key work_dir [device]"
    exit /b -1
)

if "%~2" equ "" (
    echo "Usage: %0 private_key work_dir [device]"
    exit /b -1
)

set PRIVATE_KEY=%1
set WORK_DIR=%2

set DEVICE=%3
set HASH_STR="sha256"

echo Private Key: %PRIVATE_KEY%
echo Work Dir: %WORK_DIR%
if exist %WORK_DIR%\ap_cpucap.bin (
    move %WORK_DIR%\ap_cpucap.bin %WORK_DIR%\inter_ap_cpucap.bin
)
:: vehicle device zloader.bin structure
:: ---------------------------------------------------------------
:: |      8 KB         |        24 KB       |         8KB        |
:: ---------------------------------------------------------------
:: |   bootrom1.bin    |   bootrom2.bin     |   zloader3.bin     | 
:: ---------------------------------------------------------------
for %%a in (%WORK_DIR%\zloader.bin) do set size=%%~za
echo %WORK_DIR%\zloader.bin %size% Bytes
if "%DEVICE%" equ "v3t" (
    set HASH_STR="md5"
    if %size%  gtr  32768 (
        fileread  "%WORK_DIR%\zloader.bin"      0     8192  "%WORK_DIR%\bootrom1.bin" || EXIT /B 1
        fileread  "%WORK_DIR%\zloader.bin"   8192    24576  "%WORK_DIR%\bootrom2.bin" || EXIT /B 1
        fileread  "%WORK_DIR%\zloader.bin"  32768        0  "%WORK_DIR%\zloader3.bin" || EXIT /B 1
        SignImage -z -i "%WORK_DIR%\bootrom1.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
        SignImage -z -i "%WORK_DIR%\bootrom2.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
        SignImage -z -i "%WORK_DIR%\zloader3.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
        copy /b "%WORK_DIR%\bootrom1.bin"+"%WORK_DIR%\bootrom2.bin"+"%WORK_DIR%\zloader3.bin" "%WORK_DIR%\zloader.bin" || EXIT /B 1
        del /f /q "%WORK_DIR%\bootrom1.bin" "%WORK_DIR%\bootrom2.bin" "%WORK_DIR%\zloader3.bin"
    ) else (
       SignImage -z -i "%WORK_DIR%\zloader.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
    )
    SignImage -z -i "%WORK_DIR%\tloader.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
)
echo "HASH_STR:" %HASH_STR%
SignImage -r -i "%WORK_DIR%\uboot.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1

:: ap_rootfs.img ap_cpuap.bin
:: ---------------------------------------------------------------------------------------------------------------
:: |     640 Bytes         |        640 Bytes       |      64 Bytes                |    64 Bytes                 |
:: ---------------------------------------------------------------------------------------------------------------
:: | ap_cpuap.bin signdata | ap_rootfs.img signdata | ap_rootfs.img mkimage header | ap_cpuap.bin mkimage header |
:: ---------------------------------------------------------------------------------------------------------------
fileread  "%WORK_DIR%\ap_cpuap.bin"  1280 64 "%WORK_DIR%\rootfs_mkimage_header.img" || EXIT /B 1
copy /b "%WORK_DIR%\rootfs_mkimage_header.img"+"%WORK_DIR%\ap_rootfs.img" "%WORK_DIR%\ap_rootfs.u" || EXIT /B 1
SignImage -i "%WORK_DIR%\ap_rootfs.u"  -o "%WORK_DIR%\ap_rootfs.signed"  -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
fileread  "%WORK_DIR%\ap_rootfs.signed" 0 704 "%WORK_DIR%\ap_rootfs.sign" || EXIT /B 1
filewrite "%WORK_DIR%\ap_cpuap.bin" 640 "%WORK_DIR%\ap_rootfs.sign"  "%WORK_DIR%\ap_cpuap.bin" || EXIT /B 1
SignImage -r -i  "%WORK_DIR%\ap_cpuap.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1

SignImage -r -i "%WORK_DIR%\evb_cpurpm.img" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
SignImage -r -i "%WORK_DIR%\evb_cpuphy.bin" -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
SignImage -r -i "%WORK_DIR%\inter_ap_cpucap.bin"  -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1

if exist "%WORK_DIR%\ap_caprootfs.img.dm" (
    echo "ap_caprootfs.img resign start"
    if exist "%WORK_DIR%\verity"  rmdir /s /q "%WORK_DIR%\verity"
    mkdir "%WORK_DIR%\verity"
    zxic_parse_squashfs_verity "%WORK_DIR%\ap_caprootfs.img.dm"  "%WORK_DIR%\verity\sign" "%WORK_DIR%\verity\raw_table" "%WORK_DIR%\verity\hash_tree_offset" || EXIT /B 1
    SignImage -d -i  "%WORK_DIR%\verity\raw_table" -o "%WORK_DIR%\verity\raw_table.signed"  -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
    fileseek "%WORK_DIR%\ap_caprootfs.img" "%WORK_DIR%\verity\sign" > "%WORK_DIR%\verity\sign_offset"
    if %ERRORLEVEL% NEQ 0  EXIT /B 1
    filewrite "%WORK_DIR%\ap_caprootfs.img" "%WORK_DIR%\verity\sign_offset" %WORK_DIR%\verity\raw_table.signed "%WORK_DIR%\ap_caprootfs.img" || EXIT /B 1
    del /f /q "%WORK_DIR%\verity\sign_offset"

    ::fix ap_caprootfs.img.dm
    fileseek "%WORK_DIR%\ap_caprootfs.img.dm" "%WORK_DIR%\verity\sign" > "%WORK_DIR%\verity\sign_offset2"
    if %ERRORLEVEL% NEQ 0  EXIT /B 1
    filewrite "%WORK_DIR%\ap_caprootfs.img.dm" "%WORK_DIR%\verity\sign_offset2"  %WORK_DIR%\verity\raw_table.signed "%WORK_DIR%\ap_caprootfs.img.dm" || EXIT /B 1
    del /f /q "%WORK_DIR%\verity\sign_offset2"
    echo "ap_caprootfs.img resign success"
)

if exist "%WORK_DIR%\cap_oem.img.dm" (
    echo "cap_oem.img resign start"
    if exist "%WORK_DIR%\verity" rmdir /s /q "%WORK_DIR%\verity"
    mkdir "%WORK_DIR%\verity"
    zxic_parse_squashfs_verity "%WORK_DIR%\cap_oem.img.dm"  "%WORK_DIR%\verity\sign" "%WORK_DIR%\verity\raw_table" "%WORK_DIR%\verity\hash_tree_offset" || EXIT /B 1
    SignImage -d -i  "%WORK_DIR%\verity\raw_table" -o "%WORK_DIR%\verity\raw_table.signed"  -k %PRIVATE_KEY% -t %HASH_STR% || EXIT /B 1
    fileseek "%WORK_DIR%\cap_oem.img" "%WORK_DIR%\verity\sign" > "%WORK_DIR%\verity\sign_offset3"
    if %ERRORLEVEL% NEQ 0  EXIT /B 1
    filewrite "%WORK_DIR%\cap_oem.img" "%WORK_DIR%\verity\sign_offset3"  %WORK_DIR%\verity\raw_table.signed "%WORK_DIR%\cap_oem.img" || EXIT /B 1
    del /f /q "%WORK_DIR%\verity\sign_offset3"

    ::fix cap_oem.img.dm
    fileseek "%WORK_DIR%\cap_oem.img.dm" "%WORK_DIR%\verity\sign" > "%WORK_DIR%\verity\sign_offset4"
    if %ERRORLEVEL% NEQ 0  EXIT /B 1
    filewrite "%WORK_DIR%\cap_oem.img.dm" "%WORK_DIR%\verity\sign_offset4" %WORK_DIR%\verity\raw_table.signed "%WORK_DIR%\cap_oem.img.dm" || EXIT /B 1
    del /f /q "%WORK_DIR%\verity\sign_offset4"
    echo "cap_oem.img resign success"
)

move %WORK_DIR%\inter_ap_cpucap.bin %WORK_DIR%\ap_cpucap.bin

del /f /q "%WORK_DIR%\ap_rootfs.u"
del /f /q "%WORK_DIR%\ap_rootfs.sign"
del /f /q "%WORK_DIR%\rootfs_mkimage_header.img"
del /f /q "%WORK_DIR%\ap_rootfs.signed"
del /f /q "%WORK_DIR%\ap_imagefs.img"
rmdir /s /q "%WORK_DIR%\verity"
