DESCRIPTION = "ab-bootinfo"
#nv依赖libnvram库
DEPENDS     = "libflags libmtd"
SECTION     = "ab-bootinfo"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://ab_bootinfo \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

# 引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"

#编译
do_compile() {
	make -C ab_bootinfo
}

#库文件的安装，封库的宏MK_SDK_VERSION
do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/ab_bootinfo/ab_bootinfo ${D}${bindir}/
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/ab_bootinfo/ab_bootinfo ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/ab_bootinfo
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    "
SYSTEMD_SERVICE_${PN}     = "ab_bootinfo.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"
