DESCRIPTION = "adb"
#adb依赖libnvram库
DEPENDS     = "libnvram"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
#xf.li@20240315 add for ZXW-252 start
SRC_URI = " \
    file://adb \
    ${@bb.utils.contains("DISTRO_FEATURES", "adb_login", "file://adb_shell","", d)}  \
    ${@bb.utils.contains("DISTRO_FEATURES", "adb_login", "file://adb_login","", d)}  \
    ${@bb.utils.contains("DISTRO_FEATURES", "adb_login", "file://adb_profile","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "adb_login", "file://0001-adb-login.patch","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd",     "file://adb.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd",   "file://adb.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit",  "file://adb.sysvinit","", d)} \
    "
#xf.li@20240315 modify for ZXW-252 end
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}/adb"
B = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C adb
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -d ${D}${base_bindir}/
	install -d ${D}${sysconfdir}/
	
	install -m 0755 ${S}/adbd     ${D}${bindir}/
#xf.li@20240315 modify for ZXW-252 start
	if ${@bb.utils.contains('DISTRO_FEATURES','adb_login','true','false',d)}; then
		if [ "${MOBILETEK_ADB_LOGIN}" = "YES" ]; then
			install -m 0755 ${WORKDIR}/adb_login    ${D}${base_bindir}/adb_shell
		else
			install -m 0755 ${WORKDIR}/adb_shell    ${D}${base_bindir}/adb_shell
		fi
	fi
#xf.li@20240315 modify for ZXW-252 end
	if ${@bb.utils.contains('DISTRO_FEATURES','adb_login','true','false',d)}; then
		install -m 0755 ${WORKDIR}/adb_profile  ${D}${sysconfdir}/
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/adb.init ${D}${sysconfdir}/init.d/adbd
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/adb.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/adb.sysvinit ${D}${sysconfdir}/init.d/adbd
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/adbd ${D}${sysconfdir}/rcS.d/S17adbd
		ln -s ../init.d/adbd ${D}${sysconfdir}/rcS.d/K83adbd
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/adbd ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/adbd
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
	${base_bindir}/  \
	${bindir}/       \
	${sysconfdir}/   \
    "
SYSTEMD_SERVICE_${PN}     = "adb.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"
