DESCRIPTION = "librtp"
DEPENDS     = "libnvram libsoftap libsofttimer"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-PATH}:"
SRC_URI = " \          
		  ${@bb.utils.contains("MK_SDK_VERSION", "yes", "", "file://librtp", d)} \
          "

S       = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append    = "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app_open/sdk/libnvram"

#CFLAGS_append    = "-I ${BSPDIR}/zxic_code/zxic_source/linux-5.10/include/linux"

CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"

do_compile () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		make -C librtp
	fi
}

do_install () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		install -d ${RELEASE-PATH}/lib
		install -d ${RELEASE-PATH}/include/rtp
		
		install -m 0755 ${S}/librtp/librtp.so 	${RELEASE-PATH}/lib				
		install -m 0755 ${S}/librtp/librtp.a 	${RELEASE-PATH}/lib
		install -m 0644 ${S}/librtp/include/*.h     	${RELEASE-PATH}/include/rtp
		
		#install elfs
		install -d ${ELFS-PATH}/
		install -m 0755 ${S}/librtp/librtp.so ${ELFS-PATH}/		
	fi	
	
	install -d ${D}${libdir}/
	install -d ${D}/usr/include

	install -m 0755 ${RELEASE-PATH}/lib/librtp.so      	${D}${libdir}/
	install -m 0755 ${RELEASE-PATH}/lib/librtp.a      	${D}${libdir}/
	install -m 0644 ${RELEASE-PATH}/include/rtp/*.h 	${D}/usr/include/
}

#清库

do_cleanlibs () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		rm -fr ${RELEASE-PATH}/lib/librtp.so
		rm -fr ${RELEASE-PATH}/lib/librtp.a
		rm -fr ${RELEASE-PATH}/include/rtp/*.h
		
		rm -fr ${ELFS-PATH}/librtp.so		
	fi
}

FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"

RDEPENDS_${PN} = "libnvram libsoftap libsofttimer"
