DESCRIPTION = "libupi_ab"
DEPENDS     = "libnvram libsoftap libsofttimer libatutils openssl libflags lzma"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-PATH}:"
SRC_URI = " \          
		  ${@bb.utils.contains("MK_SDK_VERSION", "yes", "", "file://libupi_ab", d)} \
          "

S       = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"

do_compile () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		make -C libupi_ab
	fi
}

do_install () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		install -d ${RELEASE-PATH}/lib
		install -d ${RELEASE-PATH}/include/upi_ab
		
		install -m 0755 ${S}/libupi_ab/libupi_ab.so 	${RELEASE-PATH}/lib				
		install -m 0755 ${S}/libupi_ab/libupi_ab.a 	${RELEASE-PATH}/lib
		install -m 0644 ${S}/libupi_ab/inc/zxic_fota_ab_upgrade.h     	${RELEASE-PATH}/include/upi_ab
		
		#install elfs
		install -d ${ELFS-PATH}/
		install -m 0755 ${S}/libupi_ab/libupi_ab.so ${ELFS-PATH}/		
	fi	
	
	install -d ${D}${libdir}/
	install -d ${D}/usr/include

	install -m 0755 ${RELEASE-PATH}/lib/libupi_ab.so      	${D}${libdir}/
	install -m 0755 ${RELEASE-PATH}/lib/libupi_ab.a      	${D}${libdir}/
	install -m 0644 ${RELEASE-PATH}/include/upi_ab/*.h 	${D}/usr/include/
}

#清库

do_cleanlibs () {
	if [ ${MK_SDK_VERSION} = "no" ];	then
		rm -fr ${RELEASE-PATH}/lib/libupi_ab.so
		rm -fr ${RELEASE-PATH}/lib/libupi_ab.a
		rm -fr ${RELEASE-PATH}/include/upi_ab/*.h
		
		rm -fr ${ELFS-PATH}/libupi_ab.so		
	fi
}

FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"

RDEPENDS_${PN} = "libnvram libsoftap libsofttimer libatutils libflags lzma"
