DESCRIPTION = "tel_svr"
DEPENDS     = "libsoftap libsofttimer libnvram libatutils libscipc libtelsvr libtinyalsa libvoice libmedia"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://telecom_svr \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://tel_svr.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://tel_svr.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://tel_svr.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C telecom_svr
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/telecom_svr/tel_svr ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/tel_svr.init ${D}${sysconfdir}/init.d/tel_svr
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/tel_svr.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/tel_svr.sysvinit ${D}${sysconfdir}/init.d/tel_svr
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/tel_svr ${D}${sysconfdir}/rcS.d/S30tel_svr
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/telecom_svr/tel_svr ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/tel_svr
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "tel_svr.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libsoftap libsofttimer libnvram libatutils libscipc libtinyalsa libvoice libmedia"