SUMMARY = "nl80211 based CLI configuration utility for wireless devices"
DESCRIPTION = "iw is a new nl80211 based CLI configuration utility for \
wireless devices. It supports almost all new drivers that have been added \
to the kernel recently. "
HOMEPAGE = "https://wireless.wiki.kernel.org/en/users/documentation/iw"
SECTION = "base"
LICENSE = "BSD-2-Clause"
LIC_FILES_CHKSUM = "file://COPYING;md5=878618a5c4af25e9b93ef0be1a93f774"

DEPENDS = "libnl"

SRC_URI = "git://git.kernel.org/pub/scm/linux/kernel/git/jberg/iw.git;protocol=https \
           file://001-nl80211_h_sync.patch \
           file://120-antenna_gain.patch \
           file://130-survey-bss-rx-time.patch \
           file://200-reduce_size.patch \
"
#v21.02.1
SRCREV = "8fab0c9ee9db217587a58efcc37421c86edcb638"

S = "${WORKDIR}/git"

inherit pkgconfig

EXTRA_OEMAKE = "\
    -f '${S}/Makefile' \
    \
    'PREFIX=${prefix}' \
    'SBINDIR=${sbindir}' \
    'MANDIR=${mandir}' \
"

do_install() {
    oe_runmake 'DESTDIR=${D}' install
}

FILES_${PN} += "${bindir}/ \
"
