DESCRIPTION = "LZMA is a general compression method. LZMA provides high compression ratio and very fast decompression."
HOMEPAGE = "http://www.7-zip.org/"
SECTION     = "lib"
LICENSE = "LGPL-2.0"
LIC_FILES_CHKSUM = "file://lzma.txt;md5=01d443c4b646b15cfa6b7908cb6f3b50"

FILESEXTRAPATHS_prepend := "${THISDIR}/lzma:"

SRC_URI = "http://downloads.sourceforge.net/sevenzip/lzma${@d.getVar('PV',1).replace('.','')}.tar.bz2;subdir=${BPN}-${PV} \
           file://0001-zxic-makefile.patch \
           file://0002-modify-include-lzma-to-zxiclzma.patch \
 "

EXTRA_OEMAKE = "-f Makefile"
INC_PR = "r7"

PR = "${INC_PR}.1"

SRC_URI[md5sum] = "f16a8a3b3bc82941f8bbad88ddb8f9c8"
SRC_URI[sha256sum] = "8ac221acdca8b6f6dd110120763af42b3707363752fc04e63c7bbff76774a445"

do_compile () {
	oe_runmake -C C
}

do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include
	install -d ${D}/usr/include/zxiclzma
	install -m 0755 ${S}/C/liblzma.so  ${D}${libdir}/libzxiclzma.so
	install -m 0755 ${S}/C/liblzma.a   ${D}${libdir}/libzxiclzma.a
	
	install -m 0644 ${S}/C/*.h ${D}/usr/include/zxiclzma

}
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
