DESCRIPTION = "sntp"
#sntp依赖libnvram库
DEPENDS     = "libdebug-info libnvram libsoftap libsofttimer"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://sntp \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://sntp.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://sntp.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://sntp.sysvinit","", d)} \
          "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append += "${ZXIC_EXTRA_CFLAGS}"
#编译
do_compile() {
	make -C sntp
}

#库文件的安装，封库的宏MK_SDK_VERSION
do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/sntp/sntp ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/sntp.init ${D}${sysconfdir}/init.d/sntp
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/sntp.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/sntp.sysvinit ${D}${sysconfdir}/init.d/sntp
		install -d ${D}${sysconfdir}/rcS.d
		#xy.he@20250211 bug-view-378 add for disable sntp autostart start
		#ln -s ../init.d/sntp ${D}${sysconfdir}/rcS.d/S22sntp
		#xy.he@20250211 bug-view-378 add for disable sntp autostart end
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/sntp/sntp ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/sntp
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/sntp","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "sntp.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libdebug-info libnvram libsoftap libsofttimer"
