SUMMARY = "OP-TEE Client API"
DESCRIPTION = "Open Portable Trusted Execution Environment - Normal World Client side of the TEE"
HOMEPAGE = "https://www.op-tee.org/"

LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://${S}/LICENSE;md5=69663ab153298557a59c67a60a743e5b"

#PV = "3.8.0+git${SRCPV}"

require optee.inc

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"

inherit python3native ${CLASS_COM}

#SRCREV = "be4fa2e36f717f03ca46e574aa66f697a897d090"
#SRC_URI = " \
#    git://github.com/OP-TEE/optee_client.git \
#    file://tee-supplicant.service \
#"

#S = "${WORKDIR}/git"

FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk/optee:"
SRC_URI = " \
    file://optee-client \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://tee-supplicant.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://tee-supplicant.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://tee-supplicant.sysvinit","", d)} \
    "
S = "${WORKDIR}/optee-client"

SYSTEMD_SERVICE_${PN} = "tee-supplicant.service"

do_install() {
    oe_runmake install
    install -D -p -m0755 ${S}/out/export/usr/sbin/tee-supplicant ${D}${sbindir}/tee-supplicant
    install -D -p -m0644 ${S}/out/export/usr/lib/libteec.so.1.0 ${D}${libdir}/libteec.so.1.0
    ln -sf libteec.so.1.0 ${D}${libdir}/libteec.so
    ln -sf libteec.so.1.0 ${D}${libdir}/libteec.so.1
    install -d ${D}${includedir}
    install -p -m0644 ${S}/out/export/usr/include/*.h ${D}${includedir}

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/tee-supplicant.init ${D}${sysconfdir}/init.d/tee-supplicant
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
	    sed -i -e s:/etc:${sysconfdir}:g \
            -e s:/usr/bin:${bindir}:g \
              ${WORKDIR}/tee-supplicant.service
        install -D -p -m0644 ${WORKDIR}/tee-supplicant.service ${D}${systemd_system_unitdir}/tee-supplicant.service
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/tee-supplicant.sysvinit ${D}${sysconfdir}/init.d/tee-supplicant
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/tee-supplicant ${D}${sysconfdir}/rcS.d/S21tee-supplicant
		ln -s ../init.d/tee-supplicant ${D}${sysconfdir}/rcS.d/K79tee-supplicant
	fi
	#install elfs
	
	install -d ${ELFS-PATH}/
	install -m 0755 ${D}${libdir}/*    ${ELFS-PATH}/
	install -m 0755 ${D}${sbindir}/tee-supplicant  ${ELFS-PATH}/
}
FILES_${PN}-dev += "/usr/lib/libteec.so"
FILES_${PN} += "${libdir}/ \
				${bindir}/ \
				${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/","", d)} \
				${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
				"