/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <string>
#include <memory>
#include <iostream>
#include <vector>
using namespace std;
#include "CdmaSmsAddress.h"
#include "UserData.h"
#include "HexDump.h"

const char CdmaSmsAddress::numericCharsDialable[] = { '0', '1', '2', '3', '4',
    '5', '6', '7', '8', '9', '*', '#' };
const char CdmaSmsAddress::numericCharsSugar[] = { '(', ')', ' ', '-', '+', '.',
    '/', '\\' };
std::map<char, bool> CdmaSmsAddress::numericCharDialableMap(
    CdmaSmsAddress::init());

CdmaSmsAddress::CdmaSmsAddress() {
  // TODO Auto-generated constructor stub

}

CdmaSmsAddress::~CdmaSmsAddress() {
  // TODO Auto-generated destructor stub
}

//free memory
std::vector<uint8_t> CdmaSmsAddress::parseToDtmf(string address) {
  int digits = address.length();
  std::vector<uint8_t> result;
  for (int i = 0; i < digits; i++) {
    char c = address[i];
    uint8_t val = 0;
    if ((c >= '1') && (c <= '9'))
      val = c - '0';
    else if (c == '0')
      val = 10;
    else if (c == '*')
      val = 11;
    else if (c == '#')
      val = 12;
    else
      return result;

    result.push_back((uint8_t) val);
  }
  return result;
}

std::map<char, bool> CdmaSmsAddress::init() {
  std::map<char, bool> tmp;
  int disable_length = sizeof(numericCharsDialable) / sizeof(char);
  int suger_length = sizeof(numericCharsSugar) / sizeof(char);
  for (int i = 0; i < disable_length; i++) {
    tmp.insert(pair<char, bool>(numericCharsDialable[i], true));
  }
  for (int i = 0; i < suger_length; i++) {
    tmp.insert(pair<char, bool>(numericCharsSugar[i], false));
  }
  return tmp;
}

std::string CdmaSmsAddress::filterNumericSugar(std::string address) {
  string builder;
  int len = address.length();
  for (int i = 0; i < len; i++) {
    char c = address[i];
    std::map<char, bool>::iterator it = numericCharDialableMap.find(c);
    if (it == numericCharDialableMap.end())
      return nullptr;
    if (!numericCharDialableMap.at(c))
      continue;
    builder.push_back(c);
  }
  return builder;
}

std::string CdmaSmsAddress::filterWhitespace(std::string address) {
  string builder = nullptr;
  int len = address.length();
  for (int i = 0; i < len; i++) {
    char c = address[i];
    if ((c == ' ') || (c == '\r') || (c == '\n') || (c == '\t'))
      continue;
    builder.push_back(c);
  }
  return builder;
}

std::shared_ptr<CdmaSmsAddress> CdmaSmsAddress::parse(char* adr) {
  shared_ptr<CdmaSmsAddress> addr = make_shared<CdmaSmsAddress>();
  string address(adr);
  addr->address = address;
  addr->ton = TON_UNKNOWN;
  addr->digitMode = DIGIT_MODE_4BIT_DTMF;
  addr->numberPlan = NUMBERING_PLAN_UNKNOWN;
  addr->numberMode = NUMBER_MODE_NOT_DATA_NETWORK;

  //uint8_t* origBytes = nullptr;
  //int origBytes_len = 0;
  std::vector<uint8_t> origBytes;
  string filteredAddr = filterNumericSugar(address);
  if ((address.find("+") != string::npos) || filteredAddr.empty()) {
    // 3GPP2 C.S0015-B section 3.4.3.3 Address Parameters
    // NUMBER_MODE should set to 1 for network address and email address.
    addr->digitMode = DIGIT_MODE_8BIT_CHAR;
    addr->numberMode = NUMBER_MODE_DATA_NETWORK;
    filteredAddr = filterWhitespace(address);

    if (address.find("@") != string::npos) {
      // This is an email address
      addr->ton = TON_NATIONAL_OR_EMAIL;
    } else if ((address.find("+") != string::npos)
        && (!(filterNumericSugar(address)).empty())) {
      // This is an international number
      // 3GPP2 C.S0015-B section 3.4.3.3 Address Parameters
      // digit mode is set to 1 and number mode is set to 0, type of number should set
      // to the value correspond to the value in 3GPP2 C.S005-D, table2.7.1.3.2.4-2
      addr->ton = TON_INTERNATIONAL_OR_IP;
      addr->numberPlan = NUMBERING_PLAN_ISDN_TELEPHONY;
      addr->numberMode = NUMBER_MODE_NOT_DATA_NETWORK;
      filteredAddr = filterNumericSugar(address);
    }

    origBytes = UserData::stringToAscii(filteredAddr);
  } else {
    // The address is not an international number and it only contains digit and *#
    origBytes = parseToDtmf(filteredAddr);
    //std::cout << "sms address: " << origBytes.size() << std::endl;
    string str1 = HexDump::toHexString(origBytes);
    //std::cout << "sms address: " << str1 << endl;
  }

  if (origBytes.empty()) {
    return nullptr;
  }

  addr->origBytes = origBytes;
  addr->numberOfDigits = origBytes.size();
  return addr;
}

std::string CdmaSmsAddress::toString() {
  string builder;
  builder.append("CdmaSmsAddress ");
  builder.append("{ digitMode=");
  builder.append(std::to_string(digitMode));
  builder.append(", numberMode=");
  builder.append(std::to_string(numberMode));
  builder.append(", numberPlan=");
  builder.append(std::to_string(numberPlan));
  builder.append(", numberOfDigits=");
  builder.append(std::to_string(numberOfDigits));
  builder.append(", ton=");
  builder.append(std::to_string(ton));
  builder.append(", address=\"" + address + string("\""));
  std::cout << "[EVENT][MT_CDMA_SMS]PDU decode: phone number: " << address << " ";
  builder.append(", origBytes=" + HexDump::toHexString(origBytes));
  builder.append(" }");
  return builder;
}
