/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "stateManager/stateManager.h"

#include <string>
#include <string.h>
#include <alloca.h>
#include <stdlib.h>
#include <vector>
#include <arpa/inet.h>
#include <string.h>

#include "../util/AtLine.h"
#include "powerManager.h"
#include "util/utils.h"
#include <cutils/jstring.h>
#include <liblog/lynq_deflog.h>
#undef LOG_TAG
#define LOG_TAG "DEMO_MANAGER"

lynqCallStatus s_callStatus = LYNQ_CALL_OFF;

//static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
//RIL_REQUEST_DEVICE_IDENTITY
int getDeviceIdentity(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
//  RIL_REQUEST_GET_IMEI
int getIMEI(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_GET_IMEISV
int getIMEISV(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_BASEBAND_VERSION
int getBasebandVersion(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_RESET_RADIO
int resetRadio(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_SCREEN_STATE
int getScreenState(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_SET_TRM
int setTRM(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
//  android::Parcel p;

//  pRI->pCI->dispatchFunction(p, pRI);
    free(pRI);
    return 0;
}
//RIL_REQUEST_SET_IMS_ENABLE
int setIMSEnable(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
//RIL_REQUEST_OEM_HOOK_RAW
int sendATCMD(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    char *cmd = (char *)argv[1];
    size_t pos = p.dataPosition();
    if (cmd == NULL){
        RLOGD("sendATCMD:cmd is null\n");
        free(pRI);
        return -1;
    }
    int len = strlen(cmd);
    p.writeInt32(len);
    p.write((const void*)cmd,len);
    RLOGD("sendATCMD: %s %d",cmd,strlen(cmd));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
#ifdef KEEP_ALIVE
//RIL_REQUEST_START_KEEPALIVE_PRO
void tranferToNetByteOrder(int type, char* addr, std::vector<uint8_t> & dest) {
    RLOGD("type is %d, addr: %s", type ,addr);
    int ret;
    int len = 0;
    int domain;
    if(type == static_cast<int>(RIL_PacketType::IPV4_TCP) || type == static_cast<int>(RIL_PacketType::IPV4_UDP)) {
        len = sizeof(struct in_addr);
        domain = AF_INET;
    } else if(type == static_cast<int>(RIL_PacketType::IPV6_TCP) || type == static_cast<int>(RIL_PacketType::IPV6_UDP)) {
        int len = sizeof(struct in6_addr);
        domain = AF_INET6;
    }
    if (len > 0) {
        unsigned char buf[len];
        ret = inet_pton(domain, addr, &buf);
        if (ret <= 0) {
            if (ret == 0)
                RLOGE("Not in presentation format");
            else
                RLOGE("inet_pton");
            return;
        }
        for (int i = 0 ; i < len; i++ ) {
            dest.push_back(buf[i]);
            RLOGD("tranferToNetByteOrder[%d]: %d", i,buf[i]);
        }
    }

}

int startKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 10){
        RLOGD("startKeepAlivePro parameters  number isn't enough");
        free(pRI);
        return -1;
    }
    RLOGD("startKeepAlivePro");
    std::vector<uint8_t> sourceAddress;
    std::vector<uint8_t> destinationAddress;
    int type = atoi(argv[1]);
    tranferToNetByteOrder(type, argv[2], sourceAddress);
    int sourcePort = atoi(argv[3]);
    tranferToNetByteOrder(type, argv[4], destinationAddress);
    int destinationPort = atoi(argv[5]);
    int netif_id = atoi(argv[6]);
    int keepIdleTime = atoi(argv[7]);
    int keepIntervalTime = atoi(argv[8]);
    int retryCount = atoi(argv[9]);

    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(type);
    p.writeByteVector(sourceAddress);
    p.writeInt32(sourcePort);
    p.writeByteVector(destinationAddress);
    p.writeInt32(destinationPort);
    p.writeInt32(netif_id);
    p.writeInt32(keepIdleTime);
    p.writeInt32(keepIntervalTime);
    p.writeInt32(retryCount);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_STOP_KEEPALIVE_PRO
int stopKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 2){
        RLOGD("stopKeepAlivePro parameters  number isn't enough");
        free(pRI);
        return -1;
    }
    RLOGD("stopKeepAlivePro");
    android::Parcel p;
    uint32_t id = atoi(argv[1]);
    RLOGD("stopKeepAlivePro sesssion id:%d", id);
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(id);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

void composeMsg(int request,const void* data, size_t datalen) {
    int* p_int = (int*) (data);
    int numInts = datalen / sizeof(int);
    if (numInts < 2) {
        RLOGD("%s error.", android::requestToString(request));
        std::string fail(android::requestToString(request));
        fail.append(",fail");
        sendKeepAlive(fail.c_str());
        return;
    }
    std::string msg(android::requestToString(request));
    if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
        msg.append(",ok");
    }
    int sessionHandle = p_int[0];
    int code = p_int[1];
    msg.append(",");
    msg.append(std::to_string(sessionHandle));
    msg.append(",");
    msg.append(std::to_string(code));
    RLOGD("%s response(%s)", android::requestToString(request),msg.c_str());
    sendKeepAlive(msg.c_str());
}

void handleKeepAliveResponse(int request, const void* data, size_t datalen, RIL_SOCKET_ID soc_id, bool is_error) {
    RLOGD("handleKeepAliveResponse(%s) is_error: %d", android::requestToString(request),is_error);
    if(is_error) {
        if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_START_KEEPALIVE_PRO,fail");
        } else if(request == RIL_REQUEST_STOP_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_STOP_KEEPALIVE_PRO,fail");
        }
    } else {
        if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
            composeMsg(request, data, datalen);
        } else if(request == RIL_REQUEST_STOP_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_STOP_KEEPALIVE_PRO,ok");
        } else if (request == RIL_UNSOL_KEEPALIVE_STATUS_PRO) {
            composeMsg(request, data, datalen);
        }
    }
}
#endif /*KEEP_ALIVE*/

void parseAtCmd(const char* line) {
    if (strstr(line, "+ETHERMAL") != NULL) {
        RLOGD("parse at command: ETHERMAL");
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("this is not a valid response string");
            return;
        }
        int rat = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse rat fail");
            return;
        }
        int temperature = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse temperature fail");
            return;
        }
        int tx_power = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse tx_power fail");
            return;
        }
        RLOGD("[tx_power]rat: %d, temperature: %d, tx_power: %d", rat, temperature, tx_power);
        printf("[tx_power]rat: %d, temperature: %d, tx_power: %d\n", rat, temperature, tx_power);
        delete atLine;
    } else if (strstr(line, "+ECAL") != NULL) {
        RLOGD("parse at command: ECAL");
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("this is not a valid response string");
            return;
        }
        int cal = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse rat fail");
            return;
        }
        RLOGD("calibration data is %s", cal == 1 ? "download" : "not download");
        if (cal == 0) {
            printf(
                    "************************************************\n*** NOTICE: calibration data is not download ***\n************************************************\n");
        }
        delete atLine;
    }
}

//RIL_REQUEST_SET_IMSCFG
int setIMSCfg(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(6);
    p.writeInt32(atoi(argv[1]));
    p.writeInt32(atoi(argv[2]));
    p.writeInt32(atoi(argv[3]));
    p.writeInt32(atoi(argv[4]));
    p.writeInt32(atoi(argv[5]));
    p.writeInt32(atoi(argv[6]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
/*****mobiletek-add****/
lynq_call_list **pCallList=NULL;
//lynq_call_list *CallList=NULL;
//callInfoLink * callInfoLinkhead = (callInfoLink *)malloc(sizeof(callInfoLink));
//memset(callInfoLinkhead,0,sizeof(callInfoLink));
int calllistNum=0;
int flag=0;
callInfoLink * create_callInfoLink()
{
    callInfoLink * head = (callInfoLink *)malloc(sizeof(callInfoLink));
    if(head==NULL)
    {
         return NULL;
    }
    memset(head,0,sizeof(callInfoLink));
    head->next=NULL;
    head->calllist_tok=NULL;
    //head->parcel=NULL;
    return head;
}
lynqQueue * createLynqQueue()
{
    lynqQueue *head = (lynqQueue *)malloc(sizeof(lynqQueue));
    if(head==NULL)
    {
         return NULL;
    }
    memset(head,0,sizeof(lynqQueue));
    head->next=NULL;
    return head;
}
lynqQueue * searchRequestinQueue(int32_t request,lynqQueue *head)
{
    lynqQueue *p;
    p=head;
    if(p!=NULL)
    {
       do
       {
           if(p->request == request)
           {
              return p;
           }
            
           p = p->next;
       } while (p != NULL);
    }
    RLOGD("search  request %d failure from lynq queue",request);
    return NULL;
}
lynqQueue * searchTokeninQueue(int32_t token,lynqQueue *head)
{
    lynqQueue *p;
    p=head;
    if(p!=NULL)
    {
       do
       {
           if(p->token == token)
           {
              return p;
           }
           p = p->next;
       } while (p != NULL);
    }
    LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
    return NULL;
}
int lynqApiInit()
{
    LynqQueueHead=createLynqQueue();
    LYDBGLOG("[%s] init head is %p\n",__FUNCTION__,LynqQueueHead);
    if(LynqQueueHead==NULL)
    {
        LYERRLOG("[%s] init call  lynq queue head fail,maybe malloc fail!",__FUNCTION__);
        return -1;
    }
    return 0;
}
int getCallStatus(void)
{
    return s_callStatus;
}
int setCallStatus(lynqCallStatus callStatus)
{
    s_callStatus = callStatus;
    return 0;
}

simInfoLink *createSimInfoLink()
{
    simInfoLink * head = (simInfoLink *)malloc(sizeof(simInfoLink));
    if(head==NULL)
    {
         RLOGD("create sim info queue fail");
         return NULL;
    }
    memset(head,0,sizeof(simInfoLink));
    head->next=NULL;
    return head;
}
int callListToParcel(void *response,size_t responselen,Parcel &p);
static int updateCallStatus(void *response,size_t responselen);
int imsiToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int simInfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int lastCallFailCauseToParce(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int dataCalllistToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int currentOperatorInfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int queryNetSelectModeToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
static int stringsToParecl(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
static int stringToParecl(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
static int intToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
static int updateErrnoToQueue(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int cellinfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int neighboringCellToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int solicitedSignalStrengthToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
int smsResponseToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
 int updateE_status(int32_t token,RIL_Errno respe)
{
    lynqQueue *node =NULL;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node)
    {
        node->t_Errno = respe;
        node->E_status = 1;
    }
    return 0;
}
void LYNQ_DispatchResponse(int request,int32_t token,RIL_Errno respe,lynq_call_list**nodeCallList,void *response,size_t respLen)
{

    switch (request) {
        case RIL_REQUEST_DIAL:
        case RIL_REQUEST_ANSWER:
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND:
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND:
        case RIL_REQUEST_SEPARATE_CONNECTION:
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE:
        case RIL_REQUEST_CONFERENCE:
        case RIL_REQUEST_HANGUP:
        case RIL_REQUEST_UDUB:
        case RIL_REQUEST_DTMF:
        {
            /*
            lynqQueue *node =NULL;
            node = searchTokeninQueue(token,LynqQueueHead);
            if(node)
            {
                node->t_Errno = respe;
                node->E_status = 1;
            }
            */
            updateE_status(token,respe);
            break;
        }
        case RIL_REQUEST_GET_IMSI:
        {
            updateE_status(token,respe);
            imsiToParcel(request,token,response,respLen,respe);
            //addImsiInfo(request,respe,token,simInfoLinkHead,response,respLen);
            break;
        }
        case RIL_REQUEST_GET_SIM_STATUS:
        {
            updateE_status(token,respe);
            simInfoToParcel(request,token,response,respLen,respe);
            break;
        }
        /*add by lei*/
        case RIL_REQUEST_QUERY_ICCID:
        {
            updateE_status(token,respe);
            imsiToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_OEM_HOOK_RAW:
        {
            updateE_status(token,respe);
            imsiToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_LAST_CALL_FAIL_CAUSE:
        {
            /*
            lynqQueue *node =NULL;
            node = searchTokeninQueue(token,LynqQueueHead);
            if(node)
            {
                node->t_Errno = respe;
                node->E_status = 1;
            }
            */
            updateE_status(token,respe);
            lastCallFailCauseToParce(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_DATA_CALL_LIST:
        {
            dataCalllistToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_OPERATOR:
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS:
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        {
            //currentOperatorInfoToParcel(request,token,response,respLen,respe);
            updateE_status(token,respe);
            stringsToParecl(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE:
        case RIL_REQUEST_IMS_REGISTRATION_STATE:
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
        case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE:
        case RIL_REQUEST_VOICE_RADIO_TECH:
        /*add by lei*/
        case RIL_REQUEST_SET_FACILITY_LOCK:
        case RIL_REQUEST_QUERY_FACILITY_LOCK:
        case RIL_REQUEST_ENTER_SIM_PIN:
        case RIL_REQUEST_ENTER_SIM_PUK:
        case RIL_REQUEST_CHANGE_SIM_PIN:
        case RIL_REQUEST_WRITE_SMS_TO_SIM:
        {
            intToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC:
        case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL:
        case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE:
        case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE:
        case RIL_REQUEST_SET_BAND_MODE:
        case RIL_REQUEST_RADIO_POWER:
        case RIL_REQUEST_MODEM_POWERON:
        case RIL_REQUEST_MODEM_POWEROFF:
        case RIL_REQUEST_DELETE_SMS_ON_SIM:
        case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS:
        case RIL_REQUEST_SET_SMSC_ADDRESS:
        {
            updateErrnoToQueue(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_GET_CELL_INFO_LIST:
        {
            cellinfoToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS:
        {
            neighboringCellToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_SIGNAL_STRENGTH:
        {
            solicitedSignalStrengthToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_SEND_SMS:
        case RIL_REQUEST_IMS_SEND_SMS:
        {
            smsResponseToParcel(request,token,response,respLen,respe);
            break;
        }
        case RIL_REQUEST_GET_SMSC_ADDRESS:
        {
            stringToParecl(request,token,response,respLen,respe);
            break;
        }
        default:
            break;
        }
}
callInfoLink* addCallInfo(int32_t tok,int request,RIL_Errno respe,callInfoLink* head,lynq_call_list**nodeCallList)
{
    if (head == NULL)
    {
         flag= 0;
         RLOGD("callInfoLink is null,set flag to 0!");
        return NULL;
    }
    if (flag == 0) 
    {
        head->token = tok;
        head->Error_tok = respe;
        head->request=request;
        if(nodeCallList!=NULL)
        {
            head->calllist_tok=nodeCallList;
        }
        head->next = NULL;
        flag=1;
    }
    else
    {
        if (head->token != tok)
        {
            callInfoLink* Node = (callInfoLink*)malloc(sizeof(callInfoLink));
            memset(Node,0,sizeof(callInfoLink));
            if (Node)
            {
                printf("new node p is %p\n", Node);
                Node->token = tok;
                Node->Error_tok = respe;
                Node->request=request;
                if(nodeCallList!=NULL)
                {
                    Node->calllist_tok=nodeCallList;
                }
                Node->next = head;
                head = Node;
            }
            else 
            {
                RLOGD("malloc Node failed!\n");
                flag = 0;
                return NULL;
            }
        }
        else
        {
            //head->token = tok;
            //head->Error_tok = respe;
            head->calllist_tok=nodeCallList;
        }

    }
    return head;
}
void updateLinkCallInfo(callInfoLink * callInfoLinkhead,lynq_call_list**nodeCallList)
{
    callInfoLink *p;
    p=callInfoLinkhead;
    if(p!=NULL)
    {
       do
       {
           p->calllist_tok=nodeCallList;
           p = p->next;
       } while (p != NULL);
    }
}
static int dispatchEvent(lynqQueue *node,void * response, size_t responselen, Parcel & p)
{
    //printf("request is %d\n",node->request);
    switch(node->request)
    {
        case RIL_REQUEST_DIAL:
        case RIL_REQUEST_ANSWER:
        //case RIL_REQUEST_HANGUP:
        //case RIL_REQUEST_UDUB:
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND:
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND:
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE:
        case RIL_REQUEST_CONFERENCE:
        //case RIL_REQUEST_SEPARATE_CONNECTION:
        //case RIL_REQUEST_DTMF:
        {
            //printf("request is %d\n",node->request);
            callListToParcel(response, responselen, p);
            break;
        }
        /*
        case RIL_REQUEST_HANGUP:
        {
            break;
        }
        */
        default:
            //printf("other test\n");
            //updateCallStatus(response,responselen);
            break;
    }
     return 0;
}
void updateAsyncData(RIL_Token t, RIL_Errno e,void * response, size_t responselen,lynqQueue* head)
{
    lynqQueue *p;
    p=head;
    if(p!=NULL)
    {
       do
       {
           dispatchEvent(p, response,responselen, p->parcel);
           p = p->next;
       } while (p != NULL);
    }
    updateCallStatus(response,responselen);
    return;
}
void printlist(callInfoLink * callInfoLinkhead)
{
    callInfoLink* p;
    p = callInfoLinkhead;
    if (p != NULL)
    {
        do
        {
            LYDBGLOG("[%s] token=%x Error_tok=%d,request =%d",__FUNCTION__,p->token, p->Error_tok,p->request);
            p = p->next;
        } while (p != NULL);
    }
    return ;
}
void setCallList_old(int token,RIL_Call **pCallLists,size_t respLen,RIL_Errno error)
{
    /*
    if(pCallLists!=NULL)
    {
        printf("DEMO_MANAGER:resplen is %d\n",respLen);
        for(int i=0;i<respLen;i++)
        {
            RIL_Call* p_cur = pCallLists[i];
            printf("state is %d\n",p_cur->state);
            RLOGD("state is %d\n",p_cur->state);
            printf("callid is %d\n",p_cur->index);
            RLOGD("callid is %d\n",p_cur->index);
            printf("toa is %d\n",p_cur->toa);
            RLOGD("toa is %d\n",p_cur->toa);
            printf("addr is %s\n",p_cur->number);
            RLOGD("addr is %s\n",p_cur->number);
        }
    }
    */
    if(calllistNum!=0)
    {
        printf("calllistNum!=0\n");
        RLOGD("calllistNum!=0\n");
        if(calllistNum!=respLen)
        {
            if (pCallList != NULL)
            {
                for (int index = 0; index < calllistNum; index++ ) 
                {
                    if (pCallList[index] != NULL) 
                    {
                        free(pCallList[index]->addr);
                        pCallList[index]->addr=NULL;
                        free(pCallList[index]);
                    }
                }
            free(pCallList);
            pCallList=NULL;
            RLOGD("free pCalllist\n");
          }
        if(respLen==0)
        {
           RLOGD("the call list is NULL,the pCalllist is NULL");
           return;
        }
        if(!(pCallList=(lynq_call_list **)malloc(sizeof(lynq_call_list *)*respLen)))
        {
            RLOGD("malloc pCallList failed");
            printf("malloc pCallList failed");
            return;
        }
        
        for(int index=0;index<respLen;index++)
        {
            if((pCallList[index]=(lynq_call_list *)malloc(sizeof(lynq_call_list)))==NULL)
            {    
                RLOGD("malloc CallList failed");
                printf("malloc CallList failed");
                for(int i=0;i<index;i++)
                {
                    free(pCallList[i]->addr);
                    pCallList[i]->addr=NULL;
                    free(pCallList[i]);
                }
                free(pCallList);
                pCallList=NULL;
                return;
            }
            pCallList[index]->addr=(char *)malloc(sizeof(char)*(sizeof(pCallLists[index]->number)+1));
            memcpy(pCallList[index]->addr, pCallLists[index]->number, strlen(pCallLists[index]->number)+1);
            pCallList[index]->token=token;
            //pCallList[index]->addr=pCallLists[index]->number;
            pCallList[index]->callid=pCallLists[index]->index;
            pCallList[index]->callState=pCallLists[index]->state;
            pCallList[index]->toa= pCallLists[index]->toa;
            pCallList[index]->lynq_error=error;
            pCallList[index]->selflen=respLen;
            
        }
        calllistNum=respLen;
      }
      else
      {
        for(int index=0;index<respLen;index++)
        {
            pCallList[index]->addr=(char *)malloc(sizeof(char)*(sizeof(pCallLists[index]->number)+1));
            memcpy(pCallList[index]->addr, pCallLists[index]->number, strlen(pCallLists[index]->number)+1);
            pCallList[index]->token=token;
            //pCallList[index]->addr=pCallLists[index]->number;
            pCallList[index]->callid=pCallLists[index]->index;
            pCallList[index]->callState=pCallLists[index]->state;
            pCallList[index]->toa= pCallLists[index]->toa;
            pCallList[index]->lynq_error=error;
            pCallList[index]->selflen=respLen;
        }
      }
      printf("retrun more than once\n");
      ///pthread_mutex_unlock(&s_startupMutex);
    }
    else
    {
        RLOGD("calllistNum==0\n");
        if((pCallList=(lynq_call_list **)malloc(sizeof(lynq_call_list *)*respLen))==NULL)
        {
            RLOGD("malloc pCallList failed");
            printf("malloc pCallList failed");
            return;
        }
        printf("pCalllist %p\n",pCallList);
        for(int index=0;index<respLen;index++)
        {
            if((pCallList[index]=(lynq_call_list *)malloc(sizeof(lynq_call_list)))==NULL)
            {    
                RLOGD("malloc CallList failed");
                printf("malloc CallList failed");
                for(int i=0;i<index;i++)
                {
                    free(pCallList[i]->addr);
                    pCallList[i]->addr=NULL;
                    free(pCallList[i]);
                }
                free(pCallList);
                pCallList=NULL;
                return;
            }
            pCallList[index]->addr=(char *)malloc(sizeof(char)*(sizeof(pCallLists[index]->number)+1));
            memcpy(pCallList[index]->addr, pCallLists[index]->number, strlen(pCallLists[index]->number)+1);
            pCallList[index]->token=token;
            //pCallList[index]->addr=pCallLists[index]->number;
            pCallList[index]->callid=pCallLists[index]->index;
            pCallList[index]->callState=pCallLists[index]->state;
            pCallList[index]->toa= pCallLists[index]->toa;
            pCallList[index]->lynq_error=error;
            pCallList[index]->selflen=respLen;
            
        }
        calllistNum=respLen;
        printf("retrun first\n");
        //pthread_mutex_unlock(&s_startupMutex);
    }
}
static void StringWriteToParcel(Parcel &p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p.writeString16(s16, s16_len);
    free(s16);
}
char * lynqStrdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}
void setCallList(int token,RIL_Call **pCallLists,size_t respLen,RIL_Errno error)
{
    if(respLen==0)
    {
          LYDBGLOG("[%s] the call list is NULL",__FUNCTION__);
          return;
     }
    if((pCallList=(lynq_call_list **)malloc(sizeof(lynq_call_list *)*respLen))==NULL)
    {
        LYDBGLOG("[%s] malloc pCallList failed",__FUNCTION__);
        return;
    }
    //printf("pCalllist %p\n",pCallList);
    for(int index=0;index<respLen;index++)
    {
        if((pCallList[index]=(lynq_call_list *)malloc(sizeof(lynq_call_list)))==NULL)
        {    
            LYDBGLOG("[%s]malloc CallList failed",__FUNCTION__);
            for(int i=0;i<index;i++)
            {
                free(pCallList[i]->addr);
                pCallList[i]->addr=NULL;
                free(pCallList[i]);
            }
            free(pCallList);
            pCallList=NULL;
            return;
        }
        pCallList[index]->addr=(char *)malloc(sizeof(char)*(sizeof(pCallLists[index]->number)+1));
        memcpy(pCallList[index]->addr, pCallLists[index]->number, strlen(pCallLists[index]->number)+1);
        pCallList[index]->token=token;
        pCallList[index]->callid=pCallLists[index]->index;
        pCallList[index]->callState=pCallLists[index]->state;
        pCallList[index]->toa= pCallLists[index]->toa;
        pCallList[index]->lynq_error=error;
        pCallList[index]->isMT = pCallLists[index]->isMT;
        pCallList[index]->selflen=respLen;
   }
}
void freeCallList(int respLen)
{
    if(respLen!=0)
    {    
        LYDBGLOG("call on going");
        return;
    }
    if (pCallList != NULL)
    {
       if (pCallList[0]==NULL)
       {
           LYDBGLOG("pCalllist pCallList[0]");
           return;
       }
        int length=pCallList[0]->selflen;
        for (int index = 0; index < length; index++ ) 
        {
            if (pCallList[index] != NULL) 
            {
                free(pCallList[index]->addr);
                pCallList[index]->addr=NULL;
                free(pCallList[index]);
            }
        }
    free(pCallList);
    pCallList=NULL;
    LYDBGLOG("free pCalllist");
    }
    return ;
    
}
void updateSimStatus(void *response,size_t respLen,simInfoLink *msg)
{
    if(response!=NULL)
    {
        //printf("RIL_CardStatus_v6 length is %d\n",sizeof (RIL_CardStatus_v6));
        if (respLen == sizeof (RIL_CardStatus_v6)) 
        {
            RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) response);
            msg->card_status=p_cur->card_state;
            for(int i=0;i<p_cur->num_applications;i++)
            {
                msg->card_type=p_cur->applications[i].app_type;
                msg->pin_state=p_cur->applications[i].pin1;
            }
        }
    }
return;
}
void addSimInfo(int request,RIL_Errno respe,int32_t token,simInfoLink *head,void *response,size_t respLen)
{
    if(head==NULL)
    {
        LYDBGLOG("[%s] the head is NULL!\n",__FUNCTION__);
        return;
    }
    LYDBGLOG("addSimInfo respLen is %d\n",respLen);
    if(response==NULL)
    {
        LYDBGLOG("the get sim status response is NULL!\n");
        return;
    }
    simInfoLink * temp=head;
    do
    {
        if(temp->token==token)
        {
            temp->Error_tok=respe;
            updateSimStatus(response,respLen,temp);
            temp->simInfoLen=respLen/sizeof(RIL_CardStatus_v6);
            break;
        }
        temp=temp->next;
    }while(temp!=NULL);
    return;
}
simInfoLink * inSimQueue(int request,int32_t token,simInfoLink *head)
{
    simInfoLink* Node = (simInfoLink*)malloc(sizeof(simInfoLink));
    memset(Node,0,sizeof(simInfoLink));
    if (Node)
    {
        Node->token = token;
        Node->request=request;
        Node->next = head;
        head = Node;
    }
    else 
    {
        LYDBGLOG("[%s] malloc Node failed!\n",__FUNCTION__);
        return NULL;
    }
    return head;

}
static lynqQueue * lynqInQueue(int request,int32_t token,lynqQueue *head)
{
    lynqQueue* Node = (lynqQueue*)malloc(sizeof(lynqQueue));
    memset(Node,0,sizeof(lynqQueue));
    if (Node)
    {
        Node->token = token;
        Node->request=request;
        Node->next = head;
        head = Node;
        LYDBGLOG("[%s] node->token is %x,request is %d\n",__FUNCTION__,Node->token,Node->request);
    }
    else 
    {
        LYDBGLOG("[%s] malloc Node failed!\n",__FUNCTION__);
        return head;
    }
    return head;

}
simInfoLink * deSimQueue(simInfoLink *head,int32_t token)
{
    simInfoLink *p,*temp;
    p = head;
    if((head ==NULL)||(head->next==NULL))
    {
        LYDBGLOG("deSimQueue head is NULL\n");
        return head;
    }
    //delete head note
    if(p->token == token)
    {
        temp=head->next;
        free(head);
        head =NULL;
        head = temp;
        return head;
    }
    //delete intermediate node
    do
    {
        temp = p;
        p=p->next;
        if(p->token==token)
        {
            temp->next=p->next;
            free(p);
            p=NULL;
            return head;
        }
    }while(p->next->next!=NULL);
    return head;
}
void lynqDeQueue(int32_t token)
{
    lynqQueue *p,*temp;
    p = LynqQueueHead;
    if((p ==NULL)||(p->next==NULL))
    {
        LYDBGLOG("[%s] lynqDeQueue head is NULL\n",__FUNCTION__);
        return 0;
        //return head;
    }
    //delete head note
    if(p->token == token)
    {
        temp=p->next;
        free(p);
        p =NULL;
        LynqQueueHead = temp;
        LYDBGLOG("[%s] delete head note!!\n",__FUNCTION__);
        return 0;
        //return head;
    }
    //delete intermediate node
    do
    {
        temp = p;
        p=p->next;
        if(p->token==token)
        {
            temp->next=p->next;
            free(p);
            p=NULL;
            LYDBGLOG("[%s] delete intermediate node!!\n",__FUNCTION__);
            //return head;
            return 0;
        }
    }while(p->next->next!=NULL);
    LYDBGLOG("[%s] Not find this token,token is %d!!\n",__FUNCTION__,token);
    return 0;
}
void LYNQ_DispatchRequest(int32_t request,int32_t token)
{
    switch(request)
    {
    //SIM CONTROLLER
        case RIL_REQUEST_GET_SIM_STATUS:
        case RIL_REQUEST_GET_IMSI:
        /*add by lei*/
        case RIL_REQUEST_QUERY_ICCID:
        case RIL_REQUEST_SET_FACILITY_LOCK:
        case RIL_REQUEST_QUERY_FACILITY_LOCK:
        case RIL_REQUEST_ENTER_SIM_PIN:
        case RIL_REQUEST_CHANGE_SIM_PIN:
        case RIL_REQUEST_ENTER_SIM_PUK:
        case RIL_REQUEST_OEM_HOOK_RAW:
    //CC CONTROLLER
        case RIL_REQUEST_DIAL:
        case RIL_REQUEST_ANSWER:
        case RIL_REQUEST_LAST_CALL_FAIL_CAUSE:
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND:
        case RIL_REQUEST_HANGUP:
        case RIL_REQUEST_UDUB:
        case RIL_REQUEST_DTMF:
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND:
        case RIL_REQUEST_SEPARATE_CONNECTION:
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE:
        case RIL_REQUEST_CONFERENCE:
    //DATA CONTROLLER
        //case RIL_REQUEST_SETUP_DATA_CALL:
        case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE:
        case RIL_REQUEST_DATA_CALL_LIST:
    //NETWORK CONTROLLER
        case RIL_REQUEST_OPERATOR:
        case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE:
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC:
        case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL:
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS:
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        case RIL_REQUEST_IMS_REGISTRATION_STATE:
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
        case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE:
        case RIL_REQUEST_GET_CELL_INFO_LIST:
        case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE:
        case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS:
        case RIL_REQUEST_SET_BAND_MODE:
        case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE:
        case RIL_REQUEST_RADIO_POWER:
        case RIL_REQUEST_VOICE_RADIO_TECH:
        case RIL_REQUEST_SIGNAL_STRENGTH:
        case RIL_REQUEST_MODEM_POWEROFF:
        case RIL_REQUEST_MODEM_POWERON:
    //SMS CONTROLLER
        case RIL_REQUEST_SEND_SMS:
        case RIL_REQUEST_IMS_SEND_SMS:
        case RIL_REQUEST_WRITE_SMS_TO_SIM:
        case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS:
        case RIL_REQUEST_DELETE_SMS_ON_SIM:
        case RIL_REQUEST_GET_SMSC_ADDRESS:
        case RIL_REQUEST_SET_SMSC_ADDRESS:
        {
            //simInfoLinkHead=inSimQueue(request, token, simInfoLinkHead);
            LynqQueueHead = lynqInQueue(request,token,LynqQueueHead);
            break;
        }
        default:
            break;
    }
    return;
}
void addImsiInfo(int request,RIL_Errno respe,int32_t token,simInfoLink *head,void *response,size_t respLen)
{
    if(head==NULL)
    {
        LYDBGLOG("[addImsiInfo] the head is NULL!\n");
        return;
    }
    LYDBGLOG("addImsiInfo respLen is %d\n",respLen);
    if(response==NULL)
    {
        LYDBGLOG("the get IMSI response is NULL!\n");
        return;
    }
    simInfoLink * temp=head;
    do
    {
        if(temp->token==token)
        {
            temp->Error_tok=respe;
            memcpy(temp->imsi,((char *)response),respLen+1);
            //temp->imsi = (char *)response;
            temp->simInfoLen=respLen/strlen((char*)response);
            break;
        }
        temp=temp->next;
    }while(temp!=NULL);
    return;
}
static int updateCallStatus(void *response,size_t responselen)
{
    if(response ==NULL||responselen==0)
    {
        s_callStatus=LYNQ_CALL_OFF;
        LYDBGLOG("[%s] update call status to call off\n",__FUNCTION__);
    }
    return 0;
}
int callListToParcel(void *response,size_t responselen,Parcel &p)
{
    int num;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        s_callStatus=LYNQ_CALL_OFF;
        return -1;
    }
    if(response ==NULL)
    {
        s_callStatus=LYNQ_CALL_OFF;
        LYDBGLOG("[%s] update call state to CALL_OFF!\n",__FUNCTION__);
    }
    if (responselen % sizeof (RIL_Call *) != 0) {
        LYDBGLOG("responseCallList: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_Call *));
        s_callStatus=LYNQ_CALL_OFF;
        return -1;
    }
    /* number of call info's */
    num = responselen / sizeof(RIL_Call *);
    p.setDataPosition(0);
    p.writeInt32(num);
    for (int i = 0 ; i < num ; i++) 
    {
        RIL_Call *p_cur = ((RIL_Call **) response)[i];
        /* each call info */
        p.writeInt32(p_cur->state);
        //printf("callListToParcel state is %d\n",p_cur->state);
        p.writeInt32(p_cur->index);
        p.writeInt32(p_cur->toa);
        p.writeInt32(p_cur->isMpty);
        p.writeInt32(p_cur->isMT);
        StringWriteToParcel(p, p_cur->number);
        s_callStatus=LYNQ_CALL_ON;
        //printf("----parcel write success----\n");
    }
    return 0;
}
int imsiToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] get imsi fail\n");
        return -1;
    }
    /* number of imsi info's */
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    num=responselen/strlen((char*)response);
    node->parcel.writeInt32(num);
    for (int i = 0 ; i < num ; i++) 
    {
        StringWriteToParcel(node->parcel, response);
        LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    }
    return 0;
}
int simInfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] get sim fail\n",__FUNCTION__);
        return -1;
    }
    /* number of imsi info's */
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] simInfoToParcel search token %d failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (responselen == sizeof (RIL_CardStatus_v6)) 
    {
        RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) response);
        node->parcel.writeInt32(p_cur->card_state);
        node->parcel.writeInt32(p_cur->num_applications);
        for(int i=0;i<p_cur->num_applications;i++)
        {
            node->parcel.writeInt32(p_cur->applications[i].app_type);
            node->parcel.writeInt32(p_cur->applications[i].pin1);
            LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
        }
    }
    return 0;
}
int lastCallFailCauseToParce(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("get last call fail cause fail\n");
        return -1;
    }
    /* number of imsi info's */
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    node->parcel.writeInt32(responselen);
    RIL_LastCallFailCauseInfo *p_cur = (RIL_LastCallFailCauseInfo *)response;
    //num=responselen/strlen((char*)response);
    node->parcel.writeInt32(p_cur->cause_code);
    StringWriteToParcel(node->parcel, p_cur->vendor_cause);
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;

}
int dataCalllistToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        RLOGD("get data call list fail\n");
        return -1;
    }
    /* number of data call list info's */
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    num = responselen/sizeof(RIL_Data_Call_Response_v11);
    node->parcel.writeInt32(num);
    RIL_Data_Call_Response_v11 *p_cur = (RIL_Data_Call_Response_v11 *)response;
    for(int i=0;i<num;i++)
    {
        //RIL_Data_Call_Response_v11 *p_cur = (RIL_Data_Call_Response_v11 *)response;
        node->parcel.writeInt32(p_cur[i].status);
        node->parcel.writeInt32(p_cur[i].suggestedRetryTime);
        node->parcel.writeInt32(p_cur[i].cid);
        node->parcel.writeInt32(p_cur[i].active);
        StringWriteToParcel(node->parcel, p_cur[i].type);
        StringWriteToParcel(node->parcel, p_cur[i].ifname);
        StringWriteToParcel(node->parcel, p_cur[i].addresses);
        StringWriteToParcel(node->parcel, p_cur[i].dnses);
        StringWriteToParcel(node->parcel, p_cur[i].gateways);
        StringWriteToParcel(node->parcel, p_cur[i].pcscf);
        node->parcel.writeInt32(p_cur[i].mtu);
    }
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;

}
int currentOperatorInfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    char **pString=NULL;
    char * subString=NULL;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        RLOGD("response is null\n");
        return -1;
    }
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    num = responselen/(sizeof(char*));
    LYDBGLOG("currentOperatorInfoToParcel is %d\n",num);
    node->t_Errno = e;
    pString=(char **)response;
    node->parcel.writeInt32(num);
    for (int i=0;i<num;i++)
    {
        subString = pString[i];
        LYDBGLOG("[%s] subString is %s\n",__FUNCTION__,subString);
        StringWriteToParcel(node->parcel,subString);
    }
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;

}
//int queryNetSelectModeToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e);
static int stringsToParecl(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    char **pString=NULL;
    char * subString=NULL;
    if (response == NULL && responselen != 0){
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("response is null\n");
        node = searchTokeninQueue(token,LynqQueueHead);
        if(node==NULL)
        {
            LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
            return -1;
        }
        node->parcel.writeInt32(0);
        node->t_Errno = e;
        return -1;
    }
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s][%d] search token %x failure from lynq queue\n",__FUNCTION__,__LINE__,token);
        return -1;
    }
    num = responselen/(sizeof(char*));
    node->t_Errno = e;
    pString=(char **)response;
    node->parcel.writeInt32(num);
    for (int i=0;i<num;i++)
    {
        subString = pString[i];
        LYDBGLOG("[%s] subString is %s\n",__FUNCTION__,subString);
        StringWriteToParcel(node->parcel,subString);
    }
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;
}
static int stringToParecl(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num;
    lynqQueue * node;
    char *pString=NULL;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0){
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] response is null\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
    pString=(char *)response;
    node->parcel.writeInt32(1);
    StringWriteToParcel(node->parcel,pString);
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;
}

static int intToParcel(int32_t request, int32_t token, void * response, size_t responselen, RIL_Errno e)
{
    int num;
    lynqQueue * node;
    int *pInts=NULL;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0){
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] response is null\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
    num = responselen/(sizeof(int));
    //printf("intToParcel is %d\n",num);
    pInts=(int*)response;
    node->parcel.writeInt32(num);
    for (int i=0;i<num;i++)
    {
        //printf("subints is %d\n",pInts[i]);
        node->parcel.writeInt32(pInts[i]);
    }
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;
}
static int updateErrnoToQueue(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int status=0;//something change
    lynqQueue * node;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    status =1;
    node->t_Errno=e;
    node->parcel.writeInt32(status);
    LYDBGLOG("[%s,%d] end!!! \n",__FUNCTION__,__LINE__);
    return 0;
}
int cellinfoToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num = 0;
    lynqQueue * node;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] response is null\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
    num = responselen/sizeof(RIL_CellInfo);
    node->parcel.writeInt32(num);
    RIL_CellInfo *p_cur = (RIL_CellInfo *)response;
    for (int i = 0; i< num; i++) {
    node->parcel.writeInt32(p_cur[i].cellInfoType);
    node->parcel.writeInt32(p_cur[i].registered);
    node->parcel.writeInt32(p_cur[i].timeStampType);
    node->parcel.writeInt64(p_cur[i].timeStamp);
    switch(p_cur[i].cellInfoType) {
        case RIL_CELL_INFO_TYPE_GSM: {
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.cellIdentityGsm.mcc);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.cellIdentityGsm.mnc);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.cellIdentityGsm.lac);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.cellIdentityGsm.cid);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.signalStrengthGsm.signalStrength);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.signalStrengthGsm.bitErrorRate);
            node->parcel.writeInt32(p_cur[i].CellInfo.gsm.signalStrengthGsm.timingAdvance);
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.cellIdentityWcdma.mcc);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.cellIdentityWcdma.mnc);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.cellIdentityWcdma.lac);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.cellIdentityWcdma.cid);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.cellIdentityWcdma.psc);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.signalStrengthWcdma.signalStrength);
            node->parcel.writeInt32(p_cur[i].CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.cellIdentityCdma.networkId);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.cellIdentityCdma.systemId);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.cellIdentityCdma.basestationId);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.cellIdentityCdma.longitude);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.cellIdentityCdma.latitude);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.signalStrengthCdma.dbm);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.signalStrengthCdma.ecio);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.signalStrengthEvdo.dbm);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.signalStrengthEvdo.ecio);
            node->parcel.writeInt32(p_cur[i].CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.cellIdentityLte.mcc);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.cellIdentityLte.mnc);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.cellIdentityLte.ci);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.cellIdentityLte.pci);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.cellIdentityLte.tac);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.signalStrength);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.rsrp);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.rsrq);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.rssnr);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.cqi);
            node->parcel.writeInt32(p_cur[i].CellInfo.lte.signalStrengthLte.timingAdvance);
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.cellIdentityTdscdma.mcc);
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.cellIdentityTdscdma.mnc);
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.cellIdentityTdscdma.lac);
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.cellIdentityTdscdma.cid);
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.cellIdentityTdscdma.cpid);
            node->parcel.writeInt32(p_cur[i].CellInfo.tdscdma.signalStrengthTdscdma.rscp);
            break;
        }
    }
    }
    LYDBGLOG("[%s] parcel write success\n",__FUNCTION__);
    return 0;
}
int neighboringCellToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num = 0;
    lynqQueue * node;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s]  get cell list fail\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
    num = responselen/sizeof(RIL_NeighboringCell*);
    node->parcel.writeInt32(num);
    RIL_NeighboringCell **p_cur = (RIL_NeighboringCell **)response;
    for (int i = 0; i< num; i++) {
        StringWriteToParcel(node->parcel,p_cur[i]->cid);
        node->parcel.writeInt32(p_cur[i]->rssi);
    }
    return 0;
}
int solicitedSignalStrengthToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num = 0;
    lynqQueue * node;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s]  get signal strength fail\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
#ifdef TELEMATIC_5G_SUPPORT
        RIL_SignalStrength_v14 *p_cur = ((RIL_SignalStrength_v14 *) response);
        num = responselen/sizeof(RIL_SignalStrength_v14);
#else
        RIL_SignalStrength_v10 *p_cur = ((RIL_SignalStrength_v10 *) response);
        num = responselen/sizeof(RIL_SignalStrength_v10);
#endif
    node->parcel.writeInt32(num);
    //RIL_SignalStrength_v10 *p_cur = (RIL_SignalStrength_v10 *)response;
    node->parcel.writeInt32(p_cur->GW_SignalStrength.signalStrength);
    node->parcel.writeInt32(p_cur->GW_SignalStrength.bitErrorRate);
    node->parcel.writeInt32(p_cur->GW_SignalStrength.timingAdvance);
    node->parcel.writeInt32(p_cur->CDMA_SignalStrength.dbm);
    node->parcel.writeInt32(p_cur->CDMA_SignalStrength.ecio);
    node->parcel.writeInt32(p_cur->EVDO_SignalStrength.dbm);
    node->parcel.writeInt32(p_cur->EVDO_SignalStrength.ecio);
    node->parcel.writeInt32(p_cur->EVDO_SignalStrength.signalNoiseRatio);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.signalStrength);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.rsrp);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.rsrq);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.rssnr);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.cqi);
    node->parcel.writeInt32(p_cur->LTE_SignalStrength.timingAdvance);
    node->parcel.writeInt32(p_cur->TD_SCDMA_SignalStrength.signalStrength);
    node->parcel.writeInt32(p_cur->TD_SCDMA_SignalStrength.bitErrorRate);
    node->parcel.writeInt32(p_cur->TD_SCDMA_SignalStrength.rscp);
    node->parcel.writeInt32(p_cur->WCDMA_SignalStrength.signalStrength);
    node->parcel.writeInt32(p_cur->WCDMA_SignalStrength.bitErrorRate);
    node->parcel.writeInt32(p_cur->WCDMA_SignalStrength.rscp);
    node->parcel.writeInt32(p_cur->WCDMA_SignalStrength.ecno);
#ifdef TELEMATIC_5G_SUPPORT
    node->parcel.writeInt32(p_cur->NR_SignalStrength.ssRsrp);
    node->parcel.writeInt32(p_cur->NR_SignalStrength.ssRsrq);
    node->parcel.writeInt32(p_cur->NR_SignalStrength.ssSinr);
    node->parcel.writeInt32(p_cur->NR_SignalStrength.csiRsrp);
    node->parcel.writeInt32(p_cur->NR_SignalStrength.csiRsrq);
    node->parcel.writeInt32(p_cur->NR_SignalStrength.csiSinr);
#endif
    return 0;
}
int smsResponseToParcel(int32_t request,int32_t token,void *response,size_t responselen,RIL_Errno e)
{
    int num = 0;
    lynqQueue * node;
    node = searchTokeninQueue(token,LynqQueueHead);
    if(node==NULL)
    {
        LYDBGLOG("[%s] search token %x failure from lynq queue\n",__FUNCTION__,token);
        return -1;
    }
    node->t_Errno = e;
    if (response == NULL && responselen != 0) {
        LYDBGLOG("[%s] invalid response: NULL\n",__FUNCTION__);
        return -1;
    }
    if(responselen ==0)
    {
        LYDBGLOG("[%s] sms response\n",__FUNCTION__);
        node->parcel.writeInt32(0);
        return -1;
    }
    num = responselen/sizeof(RIL_SMS_Response);
    node->parcel.writeInt32(num);
    RIL_SMS_Response *p_cur = (RIL_SMS_Response *)response;
    node->parcel.writeInt32(p_cur->messageRef);
    StringWriteToParcel(node->parcel,p_cur->ackPDU);
    node->parcel.writeInt32(p_cur->errorCode);
    return 0;
}

/*****mobiletek-end****/
