#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h> 
#include <unistd.h>
#include <string.h>
//#include <log/log.h>
#include <lynq_uci.h>
#include "liblog.h"
#define LOG_ENABLE 0
#if 1
#define LOG_NAME_LEN 128
#define LOG_OUT_LEN 2*1024+100 //lt add @2021.9.22 for write outbuf define len 
#define LOG_LEN 2*1024 //lt add @2021.9.22 for write buf define len 
#define LOG_UCI_MODULE "lynq_log"
#define LOG_UCI_FILE "lynq_uci"
static unsigned int log_level = 0; 
static unsigned char log_name_arr[LOG_NAME_LEN] = {0};

int lynq_log_set_value(char *key, char *value);
int lynq_log_get_value(char *key, char *tmp);

void lynq_log_global_output(log_level_enum Level,const char *format,...)
{
#if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
	
    if(Level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> Level)&0x00000001)
    {
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
		printf("[%s]",log_name_arr);
	 }
        
        //LevelName
        printf("%s:",LogLevelNameInfoTable[Level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s", LogLevelNameInfoTable[Level], buf);//lt add @2021.7.22 for write outbuf
        switch(Level) //lt mod @2021.9.22 for matching MTK log level 
        {
            case LOG_VERBOSE:
                __android_log_print(ANDROID_LOG_VERBOSE,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
                break;
            case LOG_ERROR:
                __android_log_print(ANDROID_LOG_ERROR,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
                break;
            case LOG_WARNING:
                __android_log_print(ANDROID_LOG_WARN,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
                break;		
            case LOG_INFO:
                __android_log_print(ANDROID_LOG_INFO,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
                break;
            case LOG_DEBUG:
                __android_log_print(ANDROID_LOG_DEBUG,log_name_arr, "%s",out_buf); //lt add @2021.7.22 for write syslog.log		
                break;
            default :
                __android_log_print(ANDROID_LOG_DEBUG,log_name_arr, "Log Level is Error!!!!!!"); //lt add @2021.9.22 for write syslog.log		
                break;
        }
	
    }
    return ;
#endif //LOG_ENABLE
}

void lynq_log_configuration_set(char *log_name,char log_data_arr)
{
    char log_data_str[32] = {0};
    if(log_name == NULL)
    {
        return ;
    }
    if(log_data_arr < LOG_LEVEL_MAX)
    {
        sprintf(log_data_str,"%d",log_data_arr);
        if((strlen(log_name)) < LOG_NAME_LEN)
        {
            lynq_log_set_value(log_name, log_data_str);//lt mod @2021.8.3 for uci
        }
    }
    lynq_log_configuration_init(log_name);  
    return ;
}

void lynq_deal_with_level(unsigned int get_log_level)
{
    switch(get_log_level)
    {
        case LOG_DEBUG:
            log_level |= ENABLE(LOG_DEBUG);
        case LOG_INFO:
            log_level |= ENABLE(LOG_INFO);
        case LOG_WARNING:
            log_level |= ENABLE(LOG_WARNING);
        case LOG_ERROR:
            log_level |= ENABLE(LOG_ERROR);
        case LOG_VERBOSE:
            log_level |= ENABLE(LOG_VERBOSE);
            break;
        default:
            log_level |= ENABLE(LOG_VERBOSE);
            break;
    }
    return ;
}

void lynq_log_configuration_init(char *log_name)
{
    char get_propty_log_data[32] ={0};
    unsigned int get_log_level = 0;
    if(log_name == NULL)
    {
        return ;
    }
    if((strlen(log_name)) < LOG_NAME_LEN)
    {
        strcpy(log_name_arr,log_name);
        if(0 == lynq_log_get_value(log_name,get_propty_log_data))//lt mod @2021.8.3 for uci
        {
            get_log_level = atoi(get_propty_log_data);
        }
        else
        {
            lynq_log_configuration_set(log_name, get_log_level);//lt add @2021.09.06 for uci
        }
    }
    lynq_deal_with_level(get_log_level);
    return ;
}

//lt add @2021.8.3 for in encapsulating the UCI set function
int lynq_log_set_value(char *key, char *value)
{
    return lynq_set_value(LOG_UCI_MODULE, key, value);
}

//lt add @2021.8.3 for in encapsulating the UCI get function
int lynq_log_get_value(char *key, char *tmp)
{
	return lynq_get_value(LOG_UCI_FILE, LOG_UCI_MODULE, key, tmp);
}

//lt add @2022.1.5 for  add fota lib name.
char* lynq_read_log_version()
{
	return "LOG-V1.0";
}

/**
 * @brief Verbose logs are printed and stored
 * 
 * @param log data
 * @return void 
 */
void lynq_log_verbose(const char *format,...)
{
#if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
    log_level_enum lynq_level = LOG_VERBOSE;
    
    if(lynq_level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> lynq_level)&0x00000001)
    {
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
            printf("[%s]",log_name_arr);
        }

        //LevelName
        printf("%s:",LogLevelNameInfoTable[lynq_level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s",LogLevelNameInfoTable[lynq_level], buf);//lt add @2021.7.22 for write outbuf
        __android_log_print(ANDROID_LOG_VERBOSE,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
    }
    return ;
#endif //LOG_ENABLE
}

/**
 * @brief Error logs are printed and stored
 * 
 * @param log data
 * @return void 
 */
void lynq_log_error(const char *format,...)
{
#if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
    log_level_enum lynq_level = LOG_ERROR;

    if(lynq_level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> lynq_level)&0x00000001)
    {
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
            printf("[%s]",log_name_arr);
        }

        //LevelName
        printf("%s:",LogLevelNameInfoTable[lynq_level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s",LogLevelNameInfoTable[lynq_level], buf);//lt add @2021.7.22 for write outbuf
        __android_log_print(ANDROID_LOG_ERROR,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
    }
    return ;
#endif //LOG_ENABLE
    return ;
}

/**
 * @brief Warning logs are printed and stored
 * 
 * @param log data
 * @return void 
 */
void lynq_log_warning(const char *format,...)
{
 #if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
    log_level_enum lynq_level = LOG_WARNING;

    if(lynq_level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> lynq_level)&0x00000001)
    {
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
            printf("[%s]",log_name_arr);
        }

        //LevelName
        printf("%s:",LogLevelNameInfoTable[lynq_level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s",LogLevelNameInfoTable[lynq_level], buf);//lt add @2021.7.22 for write outbuf
        __android_log_print(ANDROID_LOG_WARN,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
    }
    return ;
#endif //LOG_ENABLE
    return ;
}

/**
 * @brief Info logs are printed and stored
 * 
 * @param log data
 * @return void 
 */
void lynq_log_info(const char *format,...)
{
 #if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
    log_level_enum lynq_level = LOG_INFO;

    if(lynq_level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> lynq_level)&0x00000001)
    {	
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
            printf("[%s]",log_name_arr);
        }

        //LevelName
        printf("%s:",LogLevelNameInfoTable[lynq_level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s",LogLevelNameInfoTable[lynq_level], buf);//lt add @2021.7.22 for write outbuf
        __android_log_print(ANDROID_LOG_INFO,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
    }
    return ;
#endif //LOG_ENABLE
    return ;
}

/**
 * @brief debug logs are printed and stored
 * 
 * @param log data
 * @return void 
 */
void lynq_log_debug(const char *format,...)
{
#if LOG_ENABLE

    char out_buf[LOG_OUT_LEN] = {0};    
    char buf[LOG_LEN] = {0};
    log_level_enum lynq_level = LOG_DEBUG;

    if(lynq_level >=  LOG_LEVEL_MAX)
        return;
    if((log_level >> lynq_level)&0x00000001)
    {	
        va_list args;
        //TagName
        if(log_name_arr[0]  > 0)
        {
            printf("[%s]",log_name_arr);
        }

        //LevelName
        printf("%s:",LogLevelNameInfoTable[lynq_level]); //lt dele @2021.7.22 for []

        va_start(args,format);
        vprintf(format,args);
        vsnprintf(buf, sizeof(buf), format, args);  //lt add @2021.7.22 for write buf
        va_end(args);
        printf("\r\n");

        sprintf(out_buf, "%s %s",LogLevelNameInfoTable[lynq_level], buf);//lt add @2021.7.22 for write outbuf
        __android_log_print(ANDROID_LOG_DEBUG,log_name_arr, "%s",out_buf); //lt add @2021.9.22 for write syslog.log		
    }
    return ;
#endif //LOG_ENABLE
    return ;
}
#endif
