#!/bin/sh
#
# Run the daemon with CPU cgroup limitation
#

DAEMON="lynq-fota-backup-service"
PIDFILE="/var/run/$DAEMON.pid"
EXEC="/usr/bin/lynq-fota-backup"
EXEC_ARGS=""

# Cgroup配置
CGROUP_NAME="fota_backup"
CGROUP_PATH="/sys/fs/cgroup/cpu/$CGROUP_NAME"
CPU_LIMIT="20000"  # 20% CPU (100000 = 100%)

# 创建Cgroup并设置CPU限制
setup_cgroup() {
	if [ ! -d "$CGROUP_PATH" ]; then
		mkdir -p "$CGROUP_PATH"
		echo "$CPU_LIMIT" > "$CGROUP_PATH/cpu.cfs_quota_us"
		echo "100000" > "$CGROUP_PATH/cpu.cfs_period_us"
		echo "Cgroup $CGROUP_NAME created with 20% CPU limit"
	else
		echo "Cgroup $CGROUP_NAME already exists, updating limit"
		echo "$CPU_LIMIT" > "$CGROUP_PATH/cpu.cfs_quota_us"
	fi
}

# 将进程添加到Cgroup
add_to_cgroup() {
	PID=$1
	if [ -d "$CGROUP_PATH" ]; then
		echo "$PID" > "$CGROUP_PATH/tasks"
		echo -n "Process $PID added to Cgroup $CGROUP_NAME"
	else
		echo -n "ERROR: Cgroup $CGROUP_PATH does not exist!"
	fi
}

start() {
	sleep 600
	echo "Starting $DAEMON with 20% CPU limit... "
	setup_cgroup
	start-stop-daemon --no-close -S -b -m -p $PIDFILE -x $EXEC -- $EXEC_ARGS
	RETVAL=$?
	if [ $RETVAL -eq 0 ]; then
		PID=$(cat $PIDFILE 2>/dev/null)
		if [ -n "$PID" ]; then
			add_to_cgroup "$PID"
		else
			echo "WARNING: Failed to read PID from $PIDFILE"
		fi
			echo "OK"
		else
			echo "ERROR"
	fi
}

stop() {
        echo -n "Stopping $DAEMON... "
        start-stop-daemon -K -p $PIDFILE
        [ $? -eq 0 ] && echo "OK" || echo "ERROR"
}

restart() {
        stop 
        start &
}

case "$1" in
	start)
	start &
	;;
	stop|restart)
        "$1"
        ;;
	*)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
esac

exit $?


