/*============================================================================= 
**     FileName: lynq_common.cpp
**     Desc: lynq common
**     Author: Warren
**     Version: V1.0
**     LastChange: 2021-09-27 
**     History: 
**=============================================================================*/

#include <stdio.h>
#include <string.h>
#include <log/log.h>
#include "lynq_common.h"
#include "lynq_user.h"
#include "common.h"
#include <pthread.h>
#define USB_BUF_SIZE 8192
#include <liblog/lynq_deflog.h>
#include <sys/time.h>
#include "Phone_utils.h"
#include "utils.h"
#include "data_gdbus.h"
usb_cmd_t Usb_commands[] = {
#include "lynq_commands.h"
};

usb_at_transfer_t Usb_transfer_commands[] = {
#include "lynq_at_transfer_table.h"
};
#undef LOG_TAG
#define LOG_TAG "LYNQ_COMMON"

extern apn_table_t apn_table[LYNQ_APN_CHANNEL_MAX] = {};
//xf.il@20230610 modify for T106 data start
#ifdef MOBILETEK_TARGET_PLATFORM_T106
extern lynq_apn_cid_table_t lynq_apn_cid_table[LYNQ_APN_CHANNEL_MAX] = {
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""}, \
    {-1, "", "", "", -1, -1, -1, -1, -1, ""},
};
#endif
//xf.il@20230610 modify for T106 data end
extern int apn_count = 0;
extern char lynq_at[LYNQ_AT_LEN_MAX]= {};
char mccmnc[8] = {0};
pthread_cond_t lynq_at_cond = PTHREAD_COND_INITIALIZER;
pthread_mutex_t lynq_at_mutex= PTHREAD_MUTEX_INITIALIZER;


//int lynqSendToRil(int argc,char *argv[],int uToken);
usb_at_transfer_t *lynqFindId(char *cmd)
{
    if(cmd==NULL)
    {
        RLOGD("lynqFindId CMD is NULL!!!");
        return ((usb_at_transfer_t*)NULL);
    }
    for(int i=0;Usb_transfer_commands[i].cmdName;i++)
    {
        if (strcmp (cmd, Usb_transfer_commands[i].cmdName) == 0)
        return (&Usb_transfer_commands[i]);
    }
    return ((usb_at_transfer_t*)NULL);
}

usb_cmd_t * lynqFindUsbEvent(char *cmd)
{
    if(cmd==NULL)
    {
        RLOGD("lynqFindUsbEvent CMD is NULL!!!");
        return ((usb_cmd_t*)NULL);
    }
    printf("cmd =%s\n",cmd);
    for(int i=0;Usb_commands[i].cmdName;i++)
    {
        if (strcmp (cmd, Usb_commands[i].cmdName) == 0)
        return (&Usb_commands[i]);
    }
    return ((usb_cmd_t *)NULL);
}

int routeCmd(int request)
{
    switch (request)
    {
        case LYNQ_REQUEST_CGMI:
        case LYNQ_REQUEST_GMI:
        case LYNQ_REQUEST_CGACT:
        case LYNQ_REQUEST_CGDCONT:
        {
             return LYNQ_GOTO_AT;
        }
        case LYNQ_REQUEST_ATD:
        case LYNQ_REQUEST_LAPNACT:
        case LYNQ_REQUEST_ELAPNACT:
        case LYNQ_REQUEST_SCREEN_STATE:
        case LYNQ_REQUEST_APN:
        case LYNQ_REQUEST_SWITCH_SIM:
        {
            return LYNQ_GOTO_TELE_REQ;
        }
        case LYNQ_REQUEST_SEND_LOG_DATA:
        {
            return LYNQ_GOTO_PLAT_REQ;
        }
        case LYNQ_USER_REQUEST_GNSS:
        case LYNQ_USER_REQUEST_OTHRE:
        case LYNQ_REQUEST_INSIDE_VERSION:
        case LYNQ_PLAT_LGMDS:
        {
            return LYNQ_GOTO_USER_REQ;
        }
        case LYNQ_REQUEST_RNDIS:
        {

            return LYNQ_GOTO_RNDIS_REQ;
        }
        case LYNQ_REQUEST_LINFO:
            return LYNQ_GOTO_LINFO_REQ;
        case LYNQ_REQUEST_FACTORY:
            return LYNQ_GOTO_FACTORY;
        case LYNQ_REQUEST_FOTA:
            return LYNQ_GOTO_FOTA;
        case LYNQ_REQUEST_TEMP:
            return LYNQ_GOTO_TEMP;
        default:
            return -1;
    }
}
int g_number(const char *p){
    int cnt = 0;
    while(*p != '\0'){
        if(*p == ','){
            cnt++;
        }
        *p++;
    }
    return cnt+4;//for count character string

}
int syncRespToUsb(int error_code)
{
    char BUF[32] = {};
    int ret = -1;
    int len = 0;
    if(error_code==0)
    {
        len = write(ttyGS3_fd,"OK\n",3);
    }
    else
    {
        sprintf(BUF,"+CME ERROR: %d\n\0",error_code);
        len = write(ttyGS3_fd,BUF,strlen(BUF));
    }
    if(len < 0)
    {
        perror("lynq resp write:");
        return -1;
    }
    return 0;
}
void lynqSetArgv(char **argv, char** Point,const char* value)
{
    *argv=*Point;
     sprintf(*argv, "%s", value);    
     (*Point) += (strlen(value)+1);
}
//argv[2]:0 send,1 list,2 get
int lynqParseUsbCommand(const char* cmd,char *argv[],char test[],char* parser_buf,int maxArgc)
{
    char *token;
    char *str = test;
    char *string;
    char *parameter;
    char* Point=parser_buf;
    int cnt = g_number(cmd);
    memcpy(test, cmd, strlen(cmd));
    test[strlen(cmd)] = '\0';
    argv[1] = (char *)cmd;
    if(strstr(cmd,"=?"))
    {
        token = strtok(str, "=?");
        //argv[0] = token;
        argv[0] = strstr(token, "+")+1; 
        lynqSetArgv(&(argv[2]),&Point,"1");
        while (token != NULL)
        {
            string = token;
            token = strtok(NULL, "=?");
        }
        parameter = strtok(string, ",");
        int i = 3;
        while (parameter != NULL)
        {
            argv[i++] = parameter;
            parameter = strtok(NULL, ",");
        }
    }
    else if(strstr(cmd,"="))
    {
        lynqSetArgv(&(argv[2]),&Point,"0");
        token = strtok(str, "=");
        //argv[0] = token;
        if(strstr(token, "+"))
        {
            argv[0] = strstr(token, "+")+1;
            while (token != NULL)
            {
                string = token;
                token = strtok(NULL, "=");
            }
            parameter = strtok(string, ",");
            int i = 3;
            while (parameter != NULL)
            {
                argv[i++] = parameter;
                parameter = strtok(NULL, ",");
            }
        }
        else
        {
            argv[0] = token;
        }
    }
    else if(strstr(cmd,"?"))
    {
        lynqSetArgv(&(argv[2]),&Point,"2");
        token = strtok(str, "?");
        //argv[0] = token;
        argv[0] = strstr(token, "+")+1;
        while (token != NULL)
        {
            string = token;
            token = strtok(NULL, "?");
        }
        parameter = strtok(string, ",");
        int i = 3;
        while (parameter != NULL)
        {
            argv[i++] = parameter;
            parameter = strtok(NULL, ",");
        }
    }
    else
    {
        lynqSetArgv(&(argv[2]),&Point,"0");
        if(strstr(cmd,"+"))
        {
            argv[0] = test+3;
            return 3;
        }
        else
        {
            RLOGD("sp test 01");
            if(!strcmp(cmd, "ATA")){
                lynqSetArgv(&(argv[0]),&Point,"ATA");
                return 3;
            }
            if(!strcmp(cmd, "AT")){
                lynqSetArgv(&(argv[0]),&Point,"AT");
                return 3;
            }
            /*UNKNOW*/
            else if(!strncmp(cmd, "ATD", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATD");
                argv[3] = test+3;
                return 4;
            }
            else if(!strncmp(cmd, "ATE", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATE");
                argv[3] = test+3;
                return 4;
            }
            else if(!strcmp(cmd, "ATH")){
                lynqSetArgv(&(argv[0]),&Point,"ATH");
                return 3;
            }
            else if(!strncmp(cmd, "ATI", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATI");
                argv[3] = test+3;
                return 4;
            }
            else if(!strncmp(cmd, "ATL", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATL");
                argv[3] = test+3;
                return 4;
            }
            else if(!strncmp(cmd, "ATO", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATO");
                argv[3] = test+3;
                return 3;
            }
            /*ATP*/
            /*
            */
            else if(!strncmp(cmd, "ATQ", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATQ");
                argv[3] = test+3;
                return 4;
            }
            else if(!strncmp(cmd, "ATS3", 4)){
                lynqSetArgv(&(argv[0]),&Point,"ATS3");
                argv[3] = test+4;
                return 4;
            }
            else if(!strncmp(cmd, "ATS4", 4)){
                lynqSetArgv(&(argv[0]),&Point,"ATS4");
                argv[3] = test+4;
                return 4;
            }
            else if(!strncmp(cmd, "ATS5", 4)){
                lynqSetArgv(&(argv[0]),&Point,"ATS5");
                argv[3] = test+4;
                return 4;
            }
            /*ATS6*/
            /*
            */
            else if(!strncmp(cmd, "ATS7", 4)){
                lynqSetArgv(&(argv[0]),&Point,"ATS7");
                argv[3] = test+4;
                return 4;
            }
            else if(!strncmp(cmd, "ATS8", 4)){
                lynqSetArgv(&(argv[0]),&Point,"ATS8");
                argv[3] = test+4;
                return 4;
            }
            else if(!strncmp(cmd, "ATS10", 5)){
                lynqSetArgv(&(argv[0]),&Point,"ATS10");
                argv[3] = test+5;
                return 4;
            }
            /*ATT*/
            /*



            */
            else if(!strncmp(cmd, "ATV", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATV");
                argv[3] = test+3;
                return 4;
            }
            /*ATX*/
            /*



            */
            else if(!strncmp(cmd, "ATZ", 3)){
                lynqSetArgv(&(argv[0]),&Point,"ATZ");
                argv[3] = test+3;
                return 4;
            }
            else if(!strncmp(cmd, "AT&F", 4)){
                lynqSetArgv(&(argv[0]),&Point,"AT&F");
                argv[3] = test+4;
                return 4;
            }
            else
            {
                RLOGD("can't find this command");
                return -1;
            }
        }
    }
    //char *testtest = strstr(argv[0], "+")+1;
    //printf("testtest:%s\n", testtest);
    //argv[0] = testtest;
    //printf("%d\n", __FUNCTION__);
    if(cnt > maxArgc)
        return -1;
    return cnt;
}

int CGMI(int argc,char*argv[],char *rilReq, int uToken)
{
    return 0;
}
int dialACall(int argc,char*argv[],char *rilReq, int uToken)
{
    if(argc < 4)
    {
        RLOGD("parameter error!!!");
        return 1;
    }
    char *new_argv[3] = {};
    new_argv[0] = (char *)rilReq;
    new_argv[1] = argv[3];
    new_argv[2] = "0";
    android::lynqSendToRil(3,new_argv,uToken);
    return 0;
}
int checkDataRegistration(int uToken)
{
    /*chech radio status*/
    int ret = -1;
    char *argv_temp[3]={};
    argv_temp[0] = "RIL_REQUEST_DATA_REGISTRATION_STATE";
    android::lynqSendToRil(1,argv_temp,uToken);
    if(lynqATWaitWithTime(2000))
    {
        RLOGD("function %s line %d time out", __FUNCTION__, __LINE__);
        return -1;
    }
    /*
    if(ret == ETIMEDOUT)
    {
        int n = write(ttyGS3_fd,"+CME:ERROR 8004\n",strlen("+CME:ERROR 8004\n"));
        if(n<0)
        {
            perror("lynq resp write:");
        }
        return -1;
    }
    */
    if(current_data_reg!=0)
    {
        return -1;
    }
    return 0;
}
int setupData(int argc,char*argv[],char *rilReq, int uToken)
{
    int status = 0;
    int ret = -1;
    if(argc < 4)
    {
        RLOGD("parameter error!!!");
        return -1;
    }
    bzero(lynq_at,LYNQ_AT_LEN_MAX);
    sprintf(lynq_at,"LAPNACT");
    status = atoi(argv[3]);
    char *new_argv[3] = {};
    if(status==1)
    {
        ret = checkDataRegistration(uToken);
        if(ret != 0)
        {
            RLOGD("[setupData] radio is not available!!!");
            return -1;
        }
        new_argv[0] = (char *)rilReq;
        android::lynqSendToRil(1,new_argv,uToken);
        syncRespToUsb(0);
    }
    else if(status == 0)
    {
        new_argv[0] = "RIL_REQUEST_DEACTIVATE_DATA_CALL";
        android::lynqSendToRil(1,new_argv,uToken);
    }
    return 0;
}

static void lynq_display_pdnstate(void)
{
    lynq_output_info("\n");
    for(int i = 0;i < apn_count; i ++)
    {
        lynq_output_info("+ELAPNACT:%s,%s,%d,%s,%s\n", apn_table[i].apn, apn_table[i].apntype ,apn_table[i].pdpstate, apn_table[i].ifaceName, apn_table[i].address);
    }
    lynq_output_info("OK\n");
    return;
}

int setupData_e(int argc,char*argv[],char *rilReq, int uToken)
{
    int status = 0;
    int ret = -1;
    char *new_argv[10] = {};
    if(NULL == argv[2])
    {
        lynq_output_info("\n+ELAPNACT: 10\n");
        return -1;
    }
    int type = atoi(argv[2]);
    if(type == 0)
    {
        if(argc < 5)
        {
            RLOGD("parameter error!!!");
            return 1;
        }
        status = atoi(argv[3]);
        if(status == 1 )
        {
            ret = checkDataRegistration(uToken);
            if(ret != 0)
            {
                RLOGD("[setupData] radio is not available!!!");
                return -1;
            }
            new_argv[0] = (char *)rilReq;
            new_argv[1] = argv[4];//apn
            new_argv[2] = argv[5];//apntype
            new_argv[3] = argv[6];//user
            new_argv[4] = argv[7];//password
            new_argv[5] = argv[8];//authType
            new_argv[6] = argv[9];//normalprotocol
            new_argv[7] = argv[10];//roamingprotocol
            //memcpy(apn_table[apn_count].apn,argv[4],strlen(argv[4]));
            //apn_count++;
            android::lynqSendToRil(8,new_argv,uToken);
            syncRespToUsb(0);
        }
        else if(status == 0)
        {
            new_argv[0] = "RIL_REQUEST_DEACTIVATE_DATA_CALL";
            new_argv[1] = argv[4];//apntype
            android::lynqSendToRil(2,new_argv,uToken);
        }
    }
    else if (type == 1)
    {
        lynq_output_info("\n+ELAPNACT: (0-7)\n");
        lynq_output_info("OK\n\n");
    }
    else if (type == 2)
    {
        lynq_display_pdnstate();
    }
    return 0;
}

int insert_apn_char(char *agc, char *id,char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][64];
    if (!strcmp(id,"null"))
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (!strcmp(mcc,"null"))
    {
        char mcc[8] = {0};
        if(strlen(mccmnc))
        {
            strncpy(mcc, mccmnc, 3);
            sprintf(strtmp[1], "mcc=%s;", mcc);
        }
        else
        {
            sprintf(strtmp[2], "mcc=;");
        }
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (!strcmp(mnc,"null"))
    {
        if(strlen(mccmnc))
        {
            sprintf(strtmp[2], "mnc=%s;", mccmnc+3);
        }
        else
        {
            sprintf(strtmp[2], "mnc=;");
        }
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (!strcmp(apn,"null"))
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (!strcmp(apntype,"null"))
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "type=%s;", apntype);
    }
    if (!strcmp(user,"null"))
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (!strcmp(password,"null"))
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (!strcmp(normalprotocol,"null"))
    {
        sprintf(strtmp[7], "protocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (!strcmp(roamingprotocol,"null"))
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (!strcmp(carrier,"null"))
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s",strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}

void lynq_req_mccmnc(int uToken)
{
    char *new_argv[10] = {};
    new_argv[0] = "RIL_REQUEST_OPERATOR";
    android::lynqSendToRil(1,new_argv,uToken);//for get mccmnc
}

int lynq_modify_apn_info(int argc,char*argv[],char *rilReq, int uToken)
{
    /*
        argv[4];//id argv[5];//mcc argv[6];//mnc argv[7];//apn argv[8];//apntype argv[9];//user
        argv[10];//password  argv[11] normalprotocol argv[12] roamingprotocol
    */
    int operate = 0;
    int ret = -1;
    if(argc < 3)
    {
        RLOGD("parameter error!!!");
        return 1;
    }
    if(argv[3] == NULL)
    {
        syncRespToUsb(100);
        return -1;
    }
    char *new_argv[10] = {};
    char apn_info[512];
    operate = atoi(argv[3]);
    new_argv[0] = (char *)rilReq;
    if(operate == 0)//insert apn db
    {
        for(int i = 4; i < 14; i++)
        {
            if(argv[i] == NULL)
            {
                syncRespToUsb(100);
                return -1;
            }
        }
        lynq_req_mccmnc(uToken);
        usleep(500*1000);
        insert_apn_char(apn_info, argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12], argv[13]);
        new_argv[1] = "0";
        new_argv[2] = apn_info;
        android::lynqSendToRil(3,new_argv,uToken);
        usleep(100*1000);
        syncRespToUsb(0);
    }
    else if(operate == 1)//delete apn db
    {
        if(argv[4] == NULL)
        {
            syncRespToUsb(100);
            return -1;
        }
        sprintf(apn_info, "id=%s", argv[4]);
        new_argv[1] = "1";
        new_argv[2] = apn_info;
        android::lynqSendToRil(3,new_argv,uToken);
        usleep(100*1000);
        syncRespToUsb(0);
    }
    else if(operate == 2)//query apn db
    {
        if(argv[4] == NULL)
        {
            syncRespToUsb(100);
            return -1;
        }
        sprintf(apn_info, "id=%s", argv[4]);
        new_argv[1] = "2";
        new_argv[2] = apn_info;
        android::lynqSendToRil(3,new_argv,uToken);
        usleep(100*1000);
        syncRespToUsb(0);
    }
    else if(operate == 3)//modify apn db
    {
        for(int i = 4; i < 14; i++)
        {
            printf("argv[%d] %s\n", i,argv[i]);
            if(argv[i] == NULL)
            {
                syncRespToUsb(100);
                return -1;
            }
        }
        insert_apn_char(apn_info, argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12], argv[13]);
        //sprintf(new_argv[1], "%d", operate);
        new_argv[1] = "3";
        new_argv[2] = apn_info;
        android::lynqSendToRil(3,new_argv,uToken);
        usleep(100*1000);
        syncRespToUsb(0);
    }
    return 0;
}

static void lynq_get_current_card(void)
{
    int id = get_default_sim_all();
    lynq_output_info("+LCSUS: %d\n", id);
    lynq_output_info("OK\n");
    return;
}

static void lynq_switch_card(char*argv[], char *rilReq, int uToken)
{
    int slot = 0;
    int ret = -1;
    char *new_argv[10] = {};
    slot = atoi(argv[3]);
    new_argv[0] = (char *)rilReq;
    new_argv[1] = argv[3];
    android::lynqSendToRil(2,new_argv,uToken);
    return;
}

static void lynq_display_dsds_mode(void)
{
    lynq_output_info("+LCSUS: (0-1)\n");
    lynq_output_info("OK\n");
    return;
}

int lynq_dsds_support(int argc,char*argv[],char *rilReq, int uToken)
{
    if(argc < 4)
    {
        RLOGD("parameter error!!!");
        return 1;
    }
    int type = atoi(argv[2]);
    if(type == 2)//get mode
    {
        RLOGD("lynq_dsds_support get mode\n");
        lynq_get_current_card();
    }
    else if(type == 0)//set mode
    {
        RLOGD("lynq_dsds_support set mode\n");
        lynq_switch_card(argv, rilReq, uToken);
    }
    else if(type == 1)//get list mode
    {
        RLOGD("lynq_dsds_support get list mode\n");
        lynq_display_dsds_mode();
    }
    return 0;
}

void * thread_test(void * arg)
{
    FILE *fp;
    char buf[1024*3] = {0};
    sprintf(buf, "echo 7 | emdlogger_ctrl 2>&1");
    fp=popen(buf, "r");
    if(!fp){
        perror("popen:");
    }
    while(fgets(buf, 4072, fp) != NULL){}
    pclose(fp);
    return 0;
}

/*lei modify :Low power consumption for factory test only*/
int lynq_screen(int argc,char*argv[],char *rilReq, int uToken){
    pthread_t thid;
    int ret = pthread_create(&thid, NULL, thread_test, NULL);
    if(ret != 0){
        RLOGD("pthread_create error!!!");
        return ret;
    }
    #if 0
    char eBuf[64] = {0};
    sprintf(eBuf,"\nOK\n\0");
    int n = write(ttyGS3_fd,eBuf,strlen(eBuf));
    if(n<0)
    {
        perror("lynq resp write:");
    }
    #endif
    /*lei modify*/
    system("echo \"Sys flight mode\" >/dev/console");
    /*lei modify*/
    char *new_argv[2] = {};
    if(argc < 4)
    {
        RLOGD("parameter error!!!");
        return -1;
    }
    /*Cut to SIM2*/
    new_argv[0] = "SET_DEFAULT_SIM_ALL";
    new_argv[1] = "1";
    android::lynqSendToRil(2,new_argv,uToken);
    sleep(1);
    new_argv[0] = (char *)rilReq;
    new_argv[1] = argv[3];
    android::lynqSendToRil(2,new_argv,uToken);
    sleep(1);
    /*Cut to SIM1*/
    new_argv[0] = "SET_DEFAULT_SIM_ALL";
    new_argv[1] = "0";
    android::lynqSendToRil(2,new_argv,uToken);
    sleep(1);
    new_argv[0] = (char *)rilReq;
    new_argv[1] = argv[3];
    android::lynqSendToRil(2,new_argv,uToken);
    system("echo reg_netsys_srcclkena_mask_b 0 > /sys/power/spm/suspend_ctrl");
    system("echo reg_netsys_infra_req_mask_b 0 > /sys/power/spm/suspend_ctrl");
    system("echo reg_netsys_apsrc_req_mask_b 0 > /sys/power/spm/suspend_ctrl");
    system("echo reg_netsys_vrf18_req_mask_b 0 > /sys/power/spm/suspend_ctrl");
    system("echo reg_netsys_ddr_en_mask_b 0 > /sys/power/spm/suspend_ctrl");
    system("echo mem > /sys/power/autosleep");
    ret = pthread_join(thid,NULL);
    if(ret != 0){
        RLOGD("pthread_join error!!!");
        return ret;
    }
    return 0;
}
/*lei modify :Low power consumption for factory test only*/

void* getMDstate(int argc,char*argv[],int uToken)
{
    FILE *FP;
    char BUFFER[64]={};
    char BUF[32] = {};
    int ret = -1;
    int len = 0;
    FP = popen("cat /sys/kernel/ccci/boot","r");
    fgets(BUFFER,sizeof(BUFFER),FP);
    printf("buffer %s",BUFFER);
    modemStatus = atoi(&BUFFER[4]);
    sprintf(BUF,"+LGMDS:%d\n\0",modemStatus);
    len = write(ttyGS3_fd,BUF,strlen(BUF));
    if(len < 0)
    {
        perror("lynq resp write:");
        return 0;
    }
    syncRespToUsb(0);
    return 0;
}

void* lynq_get_inside_version(int argc,char*argv[],int uToken)
{
    int request = RIL_REQUEST_OEM_HOOK_RAW;
    RIL_SOCKET_ID id = RIL_SOCKET_1;
    if(utils::is_support_dsds())
    {
        id = (RIL_SOCKET_ID)get_default_sim_all_except_data();
    }
    else if(utils::is_suppport_dsss())
    {
        id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
    }
    RequestInfo *pRI  = creatRILInfoAndInit(request, UDP, (RIL_SOCKET_ID)(id));
    //only for factory test
    /*lei add for factory test*/
    pRI->lynqEvent=3;
    argv[1] = "AT+CGMR";
    /*lei add for factory test*/
    sendATCMD(2, argv,id,pRI);
    return 0;
}

int lynqATWaitWithTime(int mtime)
{
    RLOGD("wait_call_state");
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec outtime;
    gettimeofday(&now,NULL);
    sec = mtime/1000;
    outtime.tv_sec = now.tv_sec+sec;
    unsigned long long ns;
    ns = now.tv_usec*1000ull + (mtime%1000)*1000000ull;
    outtime.tv_sec += ns/1000000000;
    outtime.tv_nsec = ns%1000000000;
    pthread_mutex_lock(&lynq_at_mutex);
    int ret = pthread_cond_timedwait(&lynq_at_cond,&lynq_at_mutex,&outtime);
    pthread_mutex_unlock(&lynq_at_mutex);
    RLOGD("wait_call_state end");
    return ret;
}
void lynqAtRespWatingEvent()
{
    pthread_mutex_lock(&lynq_at_mutex);
    pthread_cond_signal(&lynq_at_cond);
    pthread_mutex_unlock(&lynq_at_mutex);
    return;
}
void lynqInfo(char*argv[])
{
    int type = atoi(argv[2]);
   
    if(type==2){                            
        //lynq_output_LINFO_all();     
        syncRespToUsb(0);
    }
    else if(type==0){                           
        int status = atoi(argv[3]);
        if(status==1 || status==0){
            //lynq_output_LINFO_enable=status;
            //lynq_output_info("+LINFO: Report switch when key information changed is set: %d\n",lynq_output_LINFO_enable);    
            syncRespToUsb(0);
        }   
        else {
            //lynq_output_info("parameter error\n"); 
            syncRespToUsb(100);    
        }
    }
    else if(type==1){        
        //lynq_output_info("+LINFO: (0-1)\n");         
        syncRespToUsb(0);
    }
    else {   
        //lynq_output_info("parameter error\n"); 
        syncRespToUsb(100);
    }
}
