#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sc_bsp.h>
#include <errno.h>
#include "lynq-adc.h"
#include "liblog/lynq_deflog.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ADC0_NODES "/sys/kernel/debug/pmu_zx29/adc0"
#define ADC1_NODES "/sys/kernel/debug/pmu_zx29/adc1"
#define ADC2_NODES "/sys/kernel/debug/pmu_zx29/adc2"

/********************************************************************
* @brief: qser_adc_show, function to read ADC value from specific channel
* @param qadc [IN]: ADC_CHANNEL_E, the ADC channel to read from
* @return : int, the read ADC value, or error code if failed
* @todo: NA
* @see: NA
* @warning: NA
*********************************************************************/
int qser_adc_show(ADC_CHANNEL_E qadc)
{
    int adc_value;
    char cmd_ret[1024]={0};
    FILE *fd;
    switch(qadc)
    {
        case QADC_NONE:
        {
            LYERRLOG("function %s line %d\n", __FUNCTION__, __LINE__);
            return 0;
        }
        case ADC0:
        {
            LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
            fd = fopen(ADC0_NODES, "r");
            if(fd == NULL)
            {
                LYERRLOG("fopen error: %s", strerror(errno));
                return -1;
            }
            if(fgets(cmd_ret, sizeof(cmd_ret), fd) == NULL)
            {
                LYERRLOG("fgets error!!!\n");
                fclose(fd);
                return -1;
            }
            fclose(fd);
            break;
        }
        case ADC1:
        {
            LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
            fd = fopen(ADC1_NODES, "r");
            if(fd == NULL)
            {
                LYERRLOG("fopen error: %s", strerror(errno));
                return -1;
            }
            if(fgets(cmd_ret, sizeof(cmd_ret), fd) == NULL)
            {
                LYERRLOG("fgets error!!!\n");
                fclose(fd);
                return -1;
            }
            fclose(fd);
            break;
        }
        case ADC2:
        {
            LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
            fd = fopen(ADC2_NODES, "r");
            if(fd == NULL)
            {
                LYERRLOG("fopen error: %s", strerror(errno));
                return -1;
            }
            if(fgets(cmd_ret, sizeof(cmd_ret), fd) == NULL)
            {
                LYERRLOG("fgets error!!!\n");
                fclose(fd);
                return -1;
            }
            fclose(fd);
            break;
        }
        default:
        {
            LYERRLOG("input error\n");
            return -1;
        }
    }

    adc_value = atoi(cmd_ret);
    if (adc_value < 0 || adc_value > 12000)
    {
        LYERRLOG("bad adc value %s!", cmd_ret);
        return -1;
    }
    return adc_value;
}

DEFINE_LYNQ_LIB_LOG(LYNQ_ADC)

#ifdef __cplusplus
}
#endif

