#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <log/log.h>
#include "liblog/lynq_deflog.h"
#include <include/lynq_uci.h>
#include "lynq_led.h"

#include <fcntl.h>
#include <unistd.h>

#define BUF_LEN 258
#define LYNQ_UCI_SECTION "lynq_led"
#define LYNQ_UCI_STATUSLED_KEY "lynq_statusled_on"
#define LYNQ_UCI_NETLED_KEY "lynq_netled_on"
#define GPIO_LED 100
int lynq_set_netled_on(int led_mode)
{
    char buf_netled[BUF_LEN] = "";

    if(led_mode != 0 && led_mode != 1)
        return -1;
    sprintf(buf_netled,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_UCI_SECTION, LYNQ_UCI_NETLED_KEY, led_mode);
    lynq_uci_set(buf_netled);

    return 0;
}


int lynq_set_statusled_on(int led_mode)
{
    char buf_statusled[BUF_LEN] = "";
    char com_val[GPIO_LED] = "";

    if(led_mode != 0 && led_mode != 1)
        return -1;
    sprintf(buf_statusled,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_UCI_SECTION, LYNQ_UCI_STATUSLED_KEY, led_mode);
    lynq_uci_set(buf_statusled);
    sprintf(com_val, "echo %d > /sys/class/gpio/gpio127/value",led_mode);
    if (access("/sys/class/gpio/gpio127", F_OK) != 0) {
           system("echo 127 > /sys/class/gpio/export");
     }
    system("echo out > /sys/class/gpio/gpio127/direction");
    system(com_val);

    
    return 0;
}