#ifndef __LIBLOG_H__
#define __LIBLOG_H__

#include <unistd.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
    LOG_UNSET = -1,
    LOG_VERBOSE = 0,
    LOG_ERROR,  
    LOG_WARNING,
    LOG_INFO,
    LOG_DEBUG,  
    LOG_LEVEL_MAX
}log_level_enum;

void lynq_log_global_output(log_level_enum Level,const char *format,...);
void lynq_log_configuration_init(const char *log_name);
const char* lynq_read_log_version();

//log level api
int lynq_set_log_level(const char * module_name, log_level_enum level);
int lynq_get_log_level(const char * module_name, log_level_enum *level);
int lynq_set_special_log_level(const char * exe_name, const char * module_name, log_level_enum level);
int lynq_get_special_log_level(const char * exe_name, const char * module_name, log_level_enum *level);
int lynq_notify_recalc_log_level(pid_t pid);

#ifdef __cplusplus
}
#endif

#endif  //__LOG_H__
