﻿#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include <log/log.h>
#include "lynq_monitor_internal.h"
#include "lynq_monitor_nw.h"
#include "lynq_monitor_cfg.h"
#include "lynq_monitor_api.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "LYNQ_MONITOR"
static Lynq_Monitor_Nw_Check_Count s_nw_check_count = {0};

static void lynq_monitor_nw_check_count_reset(void)
{
    memset(&s_nw_check_count, 0, sizeof(s_nw_check_count));
}

static void lynq_monitor_switch_to_flight_mode_or_reset_sim(int exception_type, int error_code)
{
    if (s_nw_check_count.nw_reset_count++ % 2 == 0)
    {
        lynq_monitor_need_reset_flight_mode(exception_type, error_code);
    }
    else
    {
        lynq_monitor_need_reset_sim(exception_type, error_code);
    }
}


// 网络注册成功返回1，注册不上返回0
static int lynq_monitor_check_network(void)
{
    LYINFLOG("s_nw_check_count.nw_error_count %d\n", s_nw_check_count.nw_error_count);
    if (g_monitor_config.network_monitor_enabled == 0)
    {
        return 1;
    }

    if (lynq_monitor_is_network_registered())
    {
        s_nw_check_count.nw_error_count = 0;
        s_nw_check_count.nw_reset_count = 0;
        return 1;
    }
    else
    {
        s_nw_check_count.nw_error_count++;
    }
    
    if (s_nw_check_count.nw_error_count > g_monitor_config.limit_reset_nad_1)
    {
        lynq_monitor_need_reset_nad(LYNQ_EXCEPTION_TYPE_NW, LYNQ_ERR_NW_TIMEOUT);
        lynq_monitor_nw_check_count_reset();
    }
    
    if ((s_nw_check_count.nw_error_count > 0 ) && (s_nw_check_count.nw_error_count % g_monitor_config.limit_reset_nw_1 == 0))
    {
        lynq_monitor_switch_to_flight_mode_or_reset_sim(LYNQ_EXCEPTION_TYPE_NW, LYNQ_ERR_NW_TIMEOUT);
        s_nw_check_count.data_error_count = 0;
    }
    return 0;
}

// 运行正常返回1，异常返回0
static int lynq_monitor_check_dev(void)
{
    LYINFLOG("s_nw_check_count.dev_error_count %d\n", s_nw_check_count.dev_error_count);
    if (g_monitor_config.device_monitor_enabled == 0)
    {
        return 1;
    }

    if (lynq_monitor_is_device_runtime_state_ok())
    {
        s_nw_check_count.dev_error_count = 0;
        return 1;
    }
    else
    {
        s_nw_check_count.dev_error_count++;
    }

    if (s_nw_check_count.dev_error_count > g_monitor_config.limit_reset_nad_1)
    {
        lynq_monitor_need_reset_nad(LYNQ_EXCEPTION_TYPE_DEV, LYNQ_ERR_DEV_TIMEOUT);
        lynq_monitor_nw_check_count_reset();
    }
    return 0;
}
static void * lynq_monitor_network_check_thread(void *arg)
{
    while (1)
    {
        lynq_monitor_sleep(g_monitor_config.nw_monitor_period);
        if (lynq_monitor_check_state())
        {
            continue;
        }

        // 设备运行状态检测
        if (lynq_monitor_check_dev() == 1)
        {
            // 网络状态检测
            if (lynq_monitor_check_network())
            {
                LYERRLOG("lynq_monitor_check_network ret 1\n");
            }
            else
            {
                LYERRLOG("lynq_monitor_check_network ret 0\n");
            }
        }
        else
        {
            LYERRLOG("lynq_monitor_check_dev ret 0\n");
        }

    }

    return NULL;
}

int lynq_monitor_start_network_check_thread(void)
{
    int result = 0;
    int ret = 0;
    pthread_t thread_id;

    ret = lynq_network_monitor_init();
    result = pthread_create(&thread_id, NULL, lynq_monitor_network_check_thread, NULL);
    if (result != 0)
    {
        LYERRLOG("Error creating network check thread: %s\n", strerror(result));
        return result;
    }

    return 0;
}
