#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <errno.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <dlfcn.h>
#include <pthread.h>
#include "lynq_atsvc_controller.h"
#include "liblog/lynq_deflog.h"

#define FUNC __FUNCTION__
#define LINE __LINE__

typedef enum
{
    INIT_SUCCESS=0,
    INIT_PULGIN_FAIL,
    INIT_SOCKET_FAIL,
    INIT_THREAD_FAIL
}init_reuslt_t;

typedef struct
{
    xmlChar* name;
    xmlChar* reg;
    xmlChar* cmd;
}plugin_conf_t;

void upper_string(char *org_string)
{
    int len = strlen(org_string);
    for(int i=0;i<len;i++)
    {
        if(org_string[i]>=97 && org_string[i]<=122)
        {
            org_string[i]=org_string[i]-32;
        }
    }
    return;
}

int load_pulgin(const char * plugin_conf_path)
{
    ALOGD("[%d][%s]load pulgin",LINE,FUNC);
    int count = 0;
    char *atcmd = NULL;
    int atcmd_len = 0;
    xmlDocPtr pdoc = NULL;
    xmlNodePtr root = NULL;
    plugin_conf_t plugin_conf;
    //memset(plugin_msg_array,0,sizeof(plugin_msg_array));
    pdoc = xmlReadFile(plugin_conf_path ,"UTF-8",XML_PARSE_RECOVER);
    if(NULL == pdoc)
    {
        ALOGI("[%d][%s]copy file %s" ,LINE,FUNC, plugin_conf_path);
        system("cp -r /data/atsvc /mnt/userdata/");
        pdoc = xmlReadFile(plugin_conf_path ,"UTF-8",XML_PARSE_RECOVER);
        if (NULL == pdoc)
        {
            ALOGE("[%d][%s]open file %s" ,LINE,FUNC, plugin_conf_path);
            return -1;
        }
    }
    root = xmlDocGetRootElement(pdoc);
    if(NULL == root)
    {
        ALOGE("get xmlDocGetRootElement() empty document fail");
        return -1;
    }
    ALOGD("root->name :%s",root->name);
    root = root->xmlChildrenNode;
    while (root != NULL)
    {
        ALOGD("count is:%d",count);
        if(PLUGINE_MAX_COUNT <= count)
        {
            ALOGW("plugin too many!!!");
            break;
        }
        if ((!xmlStrcmp(root->name, (const xmlChar *)"module")))
        {
            ALOGD("find module");
            plugin_conf.name = xmlGetProp(root, "name");
            plugin_conf.reg = xmlGetProp(root, "register");
            plugin_conf.cmd = xmlGetProp(root, "cmd");
            if((NULL == plugin_conf.name)||(NULL == plugin_conf.reg)||(NULL == plugin_conf.cmd))
            {
                ALOGE("get prop fail,name:%s,reg:%s,cmd=%s",plugin_conf.name,plugin_conf.reg,plugin_conf.cmd);
                root = root->next;
                continue;
            }
            ALOGD("[%d][%s]plugin_conf name:%s,reg:%s,cmd=%s",LINE,FUNC,plugin_conf.name,plugin_conf.reg,plugin_conf.cmd);
            plugin_msg_array[count].dlHandle_plugin = dlopen(plugin_conf.name, RTLD_NOW);
            if(NULL == plugin_msg_array[count].dlHandle_plugin)
            {
                ALOGE("open lib %s fail",plugin_conf.name);
                root = root->next;
                continue;
            }
            ALOGD("plugin_msg_array[%d].dlHandle_plugin :%p",count,plugin_msg_array[count].dlHandle_plugin);
            plugin_msg_array[count].register_module = (lynq_atsvc_incb(*)(lynq_atsvc_outcb out_cb))dlsym(plugin_msg_array[count].dlHandle_plugin, plugin_conf.reg);
            if(NULL == plugin_msg_array[count].register_module)
            {
                ALOGE("open plugin_msg_array[%d].%p fail",count,plugin_msg_array[count].register_module);
                ALOGE("dlsym failed: %s", dlerror());
                root = root->next;
                continue;
            }
            plugin_msg_array[count].atsvc_incb = plugin_msg_array[count].register_module(plugin_msg_array[count].plugin_cb);
            if(NULL == plugin_msg_array[count].atsvc_incb)
            {
                ALOGE("call %s fail",plugin_conf.reg);
                root = root->next;
                continue;
            }
            atcmd_len = strlen(plugin_conf.cmd);
            atcmd = (char *)malloc(atcmd_len*(sizeof(char)+1));
            if(NULL == atcmd)
            {
                ALOGE("count %d atcmd malloc fail",count);
                root = root->next;
                continue;
            }
            plugin_msg_array[count].state = 1;
            memcpy(atcmd,plugin_conf.cmd,atcmd_len);
            atcmd[atcmd_len] = '\0';
            //plugin_msg_array[count].atcmd = atcmd;
            upper_string(atcmd);
            plugin_msg_array[count].atcmd = atcmd;
            count++;
        }
        root = root->next;
    }
    ALOGD("pcurnode->name return");
    xmlFreeDoc(pdoc);
    xmlCleanupParser();
    return 0;
}

int lynq_atsvc_init(int count,const char * plugin_conf_path)
{
    ALOGD("start [%d][%s]",LINE,FUNC);
    int res = 0;
    res = load_pulgin(PLUGIN_CONF_PATH);
    if(0 > res)
    {
        for(int i = 0;i < PLUGINE_MAX_COUNT; i++)
        {
            if(NULL != plugin_msg_array[i].atcmd)
            {
                free(plugin_msg_array[i].atcmd);
            }
        }
        ALOGE("load_pulgin fail,code is %d",res);
        return INIT_PULGIN_FAIL;
    }
    for(int i = 0;i < PLUGINE_MAX_COUNT; i++)
    {
        if(NULL != plugin_msg_array[i].atcmd)
        {
            ALOGD("atcmd:%s",plugin_msg_array[i].atcmd);
        }
    }
    //todo at liblynq-at-extension
    /*create thread for reacive ril msg*/
    /*load pulgin from plugin config*/
    return 0;
}
