#include <vendor-ril/telephony/ril.h>
#include <log/log.h>

#include "atci_at_util.h"
#include "atci_util.h"

#undef LOG_TAG
#define LOG_TAG "DEMO_ATCI_UTIL"

static atci_cmd_type_t *atci_cmd_table[MAX_CMD_HANDLER_MODULE_NUM];
int atci_cmd_register(atci_cmd_type_t *ptr) {
  int i = 0;
  for (i = 0; i < MAX_CMD_HANDLER_MODULE_NUM; i++) {
    if (NULL == atci_cmd_table[i]) {
      atci_cmd_table[i] = ptr;
      return SYS_SUCC;
    }
  }
  RLOGE("atci_cmd_table,is full,cmd_register fail!!!");
  return SYS_FAIL;
}

atci_cmd_type_t* atci_find_cmd_handler(char *prefix) {

  atci_cmd_type_t *reasult = NULL;
  atci_cmd_type_t **reasult_ptr;

  reasult_ptr = atci_cmd_table;
  int i, j;
  for (i = 0; i < MAX_CMD_HANDLER_MODULE_NUM; i++) {
    atci_cmd_type_t *tmp_ptr;
    if (NULL == reasult_ptr[i]) {
      continue;
    }
    tmp_ptr = reasult_ptr[i];
    for (j = 0;; j++) {
      if (NULL == tmp_ptr[j].cmd_prefix) {
        break;
      }
      //RLOGD("scan [%s]",tmp_ptr[j].cmd_prefix);
      if (0 == strcasecmp(prefix, tmp_ptr[j].cmd_prefix)) {
        RLOGD("find cmd[%s] handle", prefix);
        reasult = &tmp_ptr[j];
        return reasult;
      }
    }
    if (NULL != reasult) {
      break;
    }
  }
  RLOGD("can't find cmd[%s],need handle by default", prefix);
  return reasult;
}

char* request2RILStr(int request) {
  switch (request) {
  case RIL_REQUEST_SET_CALL_FORWARD:
    return "RIL_REQUEST_SET_CALL_FORWARD";
  case RIL_REQUEST_SET_CALL_WAITING:
    return "RIL_REQUEST_SET_CALL_WAITING";
  case RIL_REQUEST_SET_FACILITY_LOCK:
    return "RIL_REQUEST_SET_FACILITY_LOCK";
  case RIL_REQUEST_DIAL:
    return "RIL_REQUEST_DIAL";
  case RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER:
    return "RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER";
  case RIL_REQUEST_RADIO_POWER:
    return "RIL_REQUEST_RADIO_POWER";
  case RIL_REQUEST_SET_MUTE:
    return "RIL_REQUEST_SET_MUTE";
  case RIL_REQUEST_CONFERENCE:
    return "RIL_REQUEST_CONFERENCE";
  case RIL_REQUEST_CONFERENCE_DIAL:
    return "RIL_REQUEST_CONFERENCE_DIAL";
  case RIL_REQUEST_DIAL_WITH_SIP_URI:
    return "RIL_REQUEST_DIAL_WITH_SIP_URI";
  case RIL_REQUEST_SET_IMS_ENABLE:
    return "RIL_REQUEST_SET_IMS_ENABLE";
  case RIL_REQUEST_DEACTIVATE_DATA_CALL:
    return "RIL_REQUEST_DEACTIVATE_DATA_CALL";
  case RIL_REQUEST_SETUP_DATA_CALL:
    return "RIL_REQUEST_SETUP_DATA_CALL";
  case RIL_REQUEST_MODIFY_APN:
    return "RIL_REQUEST_MODIFY_APN";
  case RIL_REQUEST_OPERATOR:
    return "RIL_REQUEST_OPERATOR";
  default:
    return "unknown define";
  }
}
